/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.client.factory;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.gcube.rest.index.client.exceptions.IndexException;
import org.gcube.rest.index.common.apis.IndexFactoryAPI;
import org.gcube.rest.index.common.discover.IndexDiscoverer;
import org.gcube.rest.index.common.discover.IndexDiscovererAPI;
import org.gcube.rest.index.common.resources.IndexResource;
import org.gcube.rest.resourcemanager.discoverer.ri.RunningInstancesDiscoverer;
import org.gcube.rest.resourcemanager.harvester.IResourceHarvester;
import org.gcube.rest.resourcemanager.harvester.ResourceHarvester;
import org.gcube.rest.resourcemanager.is.discoverer.ri.icclient.RIDiscovererISimpl;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFactoryClient {
    private static Gson gson = new Gson();
    private String endpoint;
    private static final Logger logger = LoggerFactory.getLogger(IndexFactoryClient.class);

    public IndexFactoryClient(Builder builder) throws IndexException {
        this.endpoint = builder.endpoint;
        String scope = builder.scope;
        Object indexDiscoverer = builder.indexDiscoverer != null ? builder.indexDiscoverer : new IndexDiscoverer((RunningInstancesDiscoverer)new RIDiscovererISimpl("FullTextIndexNode", "Index", "resteasy-servlet", scope), (IResourceHarvester)new ResourceHarvester(scope), scope);
        this.intialize((IndexDiscovererAPI<IndexResource>)indexDiscoverer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void intialize(IndexDiscovererAPI<IndexResource> indexDiscoverer) throws IndexException {
        try {
            Set fulltextIndexNodes = indexDiscoverer.discoverFullTextNodeRunningInstances();
            ArrayList endpoints = Lists.newArrayList((Iterable)fulltextIndexNodes);
            if (this.endpoint != null) {
                if (!endpoints.contains(this.endpoint)) throw new IndexException("could not initialize random client. given endpoint : " + this.endpoint + " found endpoints : " + endpoints);
                endpoints = Lists.newArrayList((Object[])new String[]{this.endpoint});
            } else {
                Collections.shuffle(endpoints);
            }
            this.endpoint = (String)endpoints.get(0);
            logger.info("Initialized at : " + this.endpoint);
            return;
        }
        catch (Exception e) {
            logger.error("could not initialize random client", (Throwable)e);
            throw new IndexException("could not initialize random client", e);
        }
    }

    public String createResource(String clusterID) throws IndexException {
        logger.warn("CALLING createResource without scope! this will create an error later because it will not be discovered by the IS");
        return this.createResource(clusterID, null);
    }

    public String createResource(String clusterID, String scope) throws IndexException {
        logger.info("calling createResourcee with parameters. clusterID : " + clusterID + ", scope : " + scope);
        IndexResource resource = new IndexResource();
        resource.setClusterID(clusterID);
        if (scope != null) {
            resource.setScope(scope);
        }
        String json = resource.toJSON();
        logger.info("calling create resource with json params : " + json);
        Response response = null;
        response = IndexFactoryClient.getFullTextIndexFactoryProxy(this.endpoint).createResourceREST(scope, json);
        logger.info("createResource returned");
        if (response.getStatus() != Response.Status.CREATED.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            throw new IndexException("resource could not be created : " + error);
        }
        String responseJSON = (String)response.readEntity(String.class);
        response.close();
        Map resp = (Map)gson.fromJson(responseJSON, new TypeToken<Map<String, String>>(){}.getType());
        logger.info("Created resource with id : " + (String)resp.get("resourceID"));
        String resourceID = (String)resp.get("resourceID");
        return resourceID;
    }

    private static IndexFactoryAPI getFullTextIndexFactoryProxy(String endpoint) throws IndexException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        IndexFactoryAPI simple = null;
        logger.info("getting proxy from index factory service...");
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(endpoint);
            simple = (IndexFactoryAPI)target.proxy(IndexFactoryAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint : " + endpoint, (Throwable)e);
            throw new IndexException("Client could not connect to endpoint : " + endpoint, e);
        }
        logger.info("getting proxy from index factory service...OK");
        return simple;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public static class Builder {
        private String endpoint;
        private String scope;
        private final IndexDiscovererAPI<IndexResource> indexDiscoverer;

        @Inject
        public Builder(IndexDiscovererAPI<IndexResource> indexDiscoverer) {
            this.indexDiscoverer = indexDiscoverer;
        }

        public Builder() {
            this.indexDiscoverer = null;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public IndexFactoryClient build() throws IndexException {
            return new IndexFactoryClient(this);
        }
    }
}

