/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.client.globals;

import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.gcube.rest.index.client.internals.EndpointsHelper;
import org.gcube.rest.index.client.tasks.UpdateEndpoints;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointProvider {
    private static final int UPDATE_EVERY_SECS = 300;
    private static final Logger logger = LoggerFactory.getLogger(EndpointProvider.class);
    private String scope;
    private Set<String> endpoints = null;
    private Scheduler scheduler = null;

    public EndpointProvider(String scope) {
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown();
            }
            catch (SchedulerException schedulerException) {}
        } else {
            this.scope = scope;
            this.endpoints = Collections.synchronizedSet(new HashSet());
            try {
                this.initScheduler();
            }
            catch (SchedulerException e) {
                logger.warn("Index client could not enable its smart update feature of the service endpoints of scope: " + scope);
            }
            this.endpoints = EndpointsHelper.getEndpointsOfScope(scope);
        }
    }

    private void initScheduler() throws SchedulerException {
        this.scheduler = StdSchedulerFactory.getDefaultScheduler();
        JobDetail job = JobBuilder.newJob(UpdateEndpoints.class).withIdentity("endpoint-updater-job-" + this.scope, "endpoint-updater-job").build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("endpoint-updater-trigger" + this.scope, "endpoint-updater-trigger").startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(300).repeatForever()).build();
        this.scheduler.getContext().put("endpoints-" + this.scope, this.endpoints);
        job.getJobDataMap().put("scope", this.scope);
        this.scheduler.scheduleJob(job, trigger);
        this.scheduler.start();
    }

    public int endpointsNumber() {
        return this.endpoints.size();
    }

    public String getAnEndpoint() {
        return this.endpoints.toArray(new String[this.endpoints.size()])[new Random().nextInt(this.endpoints.size())];
    }

    public void remove(String endpoint) {
        this.endpoints.remove(endpoint);
    }

    public void stopForCurrentScope() {
        if (this.scheduler == null) {
            return;
        }
        try {
            boolean status = this.scheduler.deleteJob(JobKey.jobKey((String)("endpoint-updater-job-" + this.scope), (String)"endpoint-updater-job"));
            logger.debug("Removing smart updater of endpoints of scope: " + this.scope + "... STATUS: " + status);
        }
        catch (SchedulerException e) {
            logger.debug("Filed to stop the smart update feature of the service endpoints of scope: " + this.scope);
        }
    }

    public void terminate() {
        if (this.scheduler == null) {
            return;
        }
        try {
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            logger.debug("Terminated smart update of the index endpoints feature");
        }
    }
}

