/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.common.discover;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.rest.index.common.discover.IndexDiscovererAPI;
import org.gcube.rest.index.common.discover.exceptions.IndexDiscoverException;
import org.gcube.rest.index.common.resources.IndexResource;
import org.gcube.rest.resourcemanager.discoverer.Discoverer;
import org.gcube.rest.resourcemanager.discoverer.exceptions.DiscovererException;
import org.gcube.rest.resourcemanager.discoverer.ri.RunningInstancesDiscoverer;
import org.gcube.rest.resourcemanager.harvester.IResourceHarvester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IndexDiscoverer
extends Discoverer<IndexResource>
implements IndexDiscovererAPI<IndexResource> {
    private static final Logger logger = LoggerFactory.getLogger(IndexDiscoverer.class);

    @Inject
    public IndexDiscoverer(RunningInstancesDiscoverer riDiscoverer, IResourceHarvester<IndexResource> harvester) {
        super(riDiscoverer, harvester);
    }

    @Override
    public Map<String, Set<String>> discoverFulltextIndexNodes(String clusterID, String indexID, String collectionID, String scope) throws IndexDiscoverException {
        Set<String> endpoints = this.discoverFullTextNodeRunningInstances(scope);
        try {
            Map foundResources = this.discoverResources(endpoints, IndexResource.class, scope);
            if (foundResources == null || foundResources.size() == 0) {
                logger.warn("No resources found by the default discoverer");
                return null;
            }
            HashMap<String, Set<String>> serviceResources = new HashMap<String, Set<String>>();
            for (Map.Entry entry : foundResources.entrySet()) {
                String endpoint = (String)entry.getKey();
                Set resources = (Set)entry.getValue();
                for (IndexResource resource : resources) {
                    if (!IndexDiscoverer.filterResource(resource, clusterID, indexID, scope, collectionID).booleanValue()) continue;
                    if (!serviceResources.containsKey(endpoint)) {
                        serviceResources.put(endpoint, new HashSet());
                    }
                    ((Set)serviceResources.get(endpoint)).add(resource.getResourceID());
                }
            }
            return serviceResources;
        }
        catch (DiscovererException e) {
            throw new IndexDiscoverException("error while discovering fulltextnode resources", (Exception)((Object)e));
        }
    }

    @Override
    public Set<IndexResource> discoverFulltextIndexNodeResources(String clusterID, String indexID, String collectionID, String scope) throws IndexDiscoverException {
        logger.info("calling discoverFulltextIndexNodeResources with parameters. clusterID : " + clusterID + ", indexID : " + indexID + ", scope : " + scope);
        Set<String> endpoints = this.discoverFullTextNodeRunningInstances(scope);
        try {
            Map foundResources = this.discoverResources(endpoints, IndexResource.class, scope);
            if (foundResources == null || foundResources.size() == 0) {
                logger.warn("No resources found by the default discoverer");
                return null;
            }
            HashSet<IndexResource> serviceResources = new HashSet<IndexResource>();
            for (Map.Entry entry : foundResources.entrySet()) {
                Set resources = (Set)entry.getValue();
                for (IndexResource resource : resources) {
                    if (!IndexDiscoverer.filterResource(resource, clusterID, indexID, scope, collectionID).booleanValue()) continue;
                    serviceResources.add(resource);
                }
            }
            return serviceResources;
        }
        catch (DiscovererException e) {
            throw new IndexDiscoverException("error while discovering fulltextnode resources", (Exception)((Object)e));
        }
    }

    private static Boolean filterResource(IndexResource resource, String clusterID, String indexID, String scope, String collectionID) {
        logger.info("calling filterResource with parameters. clusterID : " + clusterID + ", indexID : " + indexID + ", scope : " + scope + ", collectionID : " + collectionID);
        logger.info("                      resource params : clusterID : " + resource.getClusterID() + ", indexID : " + resource.getIndexID() + ", scope : " + resource.getScope() + ", collectionIDs : " + resource.getCollections());
        if (!(clusterID == null || resource.getClusterID() != null && resource.getClusterID().equalsIgnoreCase(clusterID))) {
            logger.info("resource clusterID different than : " + clusterID + ". resource has : " + resource.getClusterID());
            return false;
        }
        if (!(indexID == null || resource.getIndexID() != null && resource.getIndexID().equalsIgnoreCase(indexID))) {
            logger.info("resource indexID different than : " + indexID + ". resource has : " + resource.getIndexID());
            return false;
        }
        if (!(scope == null || resource.getScope() != null && resource.getScope().equalsIgnoreCase(scope))) {
            logger.info("resource scope different than : " + scope + " .resource has : " + resource.getScope());
            return false;
        }
        if (!(collectionID == null || resource.getCollections() != null && resource.getCollections().contains(collectionID))) {
            logger.info("resource collections different than : " + collectionID + " .resource has : " + resource.getCollections());
            return false;
        }
        return true;
    }

    @Override
    public Set<String> discoverFullTextNodeRunningInstances(String scope) {
        return this.discoverRunningInstances("Index", "FullTextIndexNode", "resteasy-servlet", scope);
    }
}

