/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.elasticsearch.FullTextNode;
import org.gcube.rest.commons.filter.IResourceFilter;
import org.gcube.rest.commons.helpers.JSONConverter;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourcefile.IResourceFileUtils;
import org.gcube.rest.index.client.IndexClient;
import org.gcube.rest.index.common.apis.IndexServiceAPI;
import org.gcube.rest.index.common.discover.IndexDiscovererAPI;
import org.gcube.rest.index.common.helpers.ResultReader;
import org.gcube.rest.index.common.resources.IndexResource;
import org.gcube.rest.index.service.IndexService;
import org.gcube.rest.index.service.resources.IndexResourceFactory;
import org.gcube.rest.resourceawareservice.ResourceAwareService;
import org.gcube.rest.resourceawareservice.exceptions.ResourceAwareServiceException;
import org.gcube.rest.resourceawareservice.exceptions.ResourceNotFoundException;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.jboss.resteasy.annotations.GZIP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
@Singleton
public class IndexService
extends ResourceAwareService<IndexResource>
implements IndexServiceAPI {
    private final IndexDiscovererAPI<IndexResource> indexDiscoverer;
    private final Provider<IndexClient.Builder> clientProvider;
    final IndexResourceFactory factory;
    static final Logger logger = LoggerFactory.getLogger(IndexService.class);
    private String scope;

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public String getResourceClass() {
        return "IndexResources";
    }

    public String getResourceNamePref() {
        return "IndexResource";
    }

    @Inject
    public IndexService(IndexResourceFactory factory, ResourcePublisher<IndexResource> publisher, IndexDiscovererAPI<IndexResource> indexDiscoverer, Provider<IndexClient.Builder> clientProvider, IResourceFilter<IndexResource> resourceFilter, IResourceFileUtils<IndexResource> resourceFileUtils) throws ResourceAwareServiceException {
        super((ResourceFactory)factory, publisher, resourceFilter, resourceFileUtils);
        this.factory = factory;
        this.indexDiscoverer = indexDiscoverer;
        this.clientProvider = clientProvider;
        logger.info("In IndexService constructor");
    }

    @GET
    @Path(value="/{id}/feedLocator")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response feedLocator(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @QueryParam(value="rsuri") String resultSetLocation, @QueryParam(value="indexName") String indexName, @DefaultValue(value="false") @QueryParam(value="activate") Boolean activate, @QueryParam(value="sids") Set<String> sids, @DefaultValue(value="false") @QueryParam(value="block") Boolean block) {
        Response.Status status;
        String msg;
        block6: {
            logger.info("in feed locator");
            logger.info("feedLocator activate : " + activate);
            logger.info("feedLocator resultSetLocation : " + resultSetLocation);
            logger.info("feedLocator activate : " + activate);
            msg = null;
            status = null;
            IndexResource resource = null;
            try {
                resource = (IndexResource)this.getResource(resourceID);
            }
            catch (ResourceNotFoundException e) {
                logger.warn("error while getting resource", (Throwable)e);
                msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
                status = Response.Status.NOT_FOUND;
                return Response.status((Response.Status)status).entity((Object)msg).build();
            }
            String clusterID = resource.getClusterID();
            logger.info("clusterID = " + clusterID);
            String key = resourceID;
            logger.info("resource key in feeding : " + key);
            IndexDiscovererAPI idxDiscoverer = this.indexDiscoverer;
            IndexResource fresource = resource;
            IndexClient.Builder indexClientBuilder = (IndexClient.Builder)this.clientProvider.get();
            String serviceScope = this.scope;
            try {
                1 feedThread = new /* Unavailable Anonymous Inner Class!! */;
                feedThread.start();
                logger.info("will feed block? " + block);
                if (!block.booleanValue()) break block6;
                try {
                    feedThread.join();
                }
                catch (InterruptedException e) {
                    logger.warn("error while waiting feed to complete", (Throwable)e);
                    msg = JSONConverter.convertToJSON((String)"Error", (Object)"error while waiting feed to complete ");
                    status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)msg).build();
                }
            }
            catch (ResourceNotFoundException e) {
                logger.warn("error while getting resource", (Throwable)e);
                msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
                status = Response.Status.NOT_FOUND;
                return Response.status((Response.Status)status).entity((Object)msg).build();
            }
        }
        logger.info("feed locator completed");
        msg = JSONConverter.convertToJSON((String)"result", (Object)Boolean.TRUE);
        status = Response.Status.OK;
        Response resp = Response.status((Response.Status)status).entity((Object)msg).build();
        logger.info("feed block? " + block + " will return " + msg);
        return resp;
    }

    @POST
    @Path(value="/{id}/query")
    @Produces(value={"application/json; charset=UTF-8"})
    @Consumes(value={"application/x-www-form-urlencoded;charset=UTF-8"})
    @GZIP
    public Response query(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @FormParam(value="queryString") String queryString, @DefaultValue(value="0") @FormParam(value="from") Integer from, @DefaultValue(value="-1") @FormParam(value="count") Integer count, @FormParam(value="sids") Set<String> sids, @DefaultValue(value="true") @FormParam(value="useRR") Boolean useRR, @DefaultValue(value="false") @FormParam(value="result") Boolean result, @DefaultValue(value="false") @FormParam(value="stream") Boolean stream, @DefaultValue(value="false") @FormParam(value="pretty") Boolean pretty) {
        String msg = null;
        Response.Status status = null;
        try {
            logger.info("queryString : " + queryString);
            logger.info("from : " + from);
            logger.info("count : " + count);
            logger.info("sids : " + sids);
            IndexResource resource = (IndexResource)this.getResource(resourceID);
            String grslocator = this.factory.getIndexNode(resource).query(queryString, from, count, sids, useRR);
            if (result.booleanValue()) {
                if (stream.booleanValue()) {
                    2 stm = new /* Unavailable Anonymous Inner Class!! */;
                    msg = stm;
                    status = Response.Status.OK;
                } else {
                    msg = ResultReader.resultSetToJsonRecords((String)grslocator, (boolean)pretty);
                    status = Response.Status.OK;
                }
            } else {
                msg = JSONConverter.convertToJSON((String)"grslocator", (Object)grslocator);
                status = Response.Status.OK;
            }
        }
        catch (Exception e) {
            logger.error("error while querying", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("error while querying : " + e.getMessage()));
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/frequentTerms")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response frequentTerms(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @QueryParam(value="queryString") String queryString, @DefaultValue(value="10") @QueryParam(value="maxTerms") Integer maxTerms, @QueryParam(value="sids") Set<String> sids, @DefaultValue(value="true") @QueryParam(value="useRR") Boolean useRR, @DefaultValue(value="false") @QueryParam(value="pretty") Boolean pretty) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        try {
            Map hits = this.factory.getIndexNode(resource).frequentTerms(queryString, maxTerms, sids, useRR);
            msg = JSONConverter.convertToJSON((Object)hits, (boolean)pretty);
            status = Response.Status.OK;
        }
        catch (Exception e) {
            logger.error("error while getting frequent terms for query : " + queryString, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("error while querying : " + e.getMessage()));
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/clustering")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response clustering(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @QueryParam(value="queryString") String queryString, @DefaultValue(value="") @QueryParam(value="queryHint") String queryHint, @QueryParam(value="clustersCount") Integer clustersCount, @QueryParam(value="urlField") String urlField, @QueryParam(value="titleFields") List<String> titleFields, @QueryParam(value="contentFields") List<String> contentFields, @QueryParam(value="languageFields") List<String> languageFields, @DefaultValue(value="kmeans") @QueryParam(value="algorithm") String algorithm, @DefaultValue(value="100") @QueryParam(value="searchHits") Integer searchHits, @QueryParam(value="sids") Set<String> sids, @DefaultValue(value="true") @QueryParam(value="useRR") Boolean useRR, @DefaultValue(value="false") @QueryParam(value="pretty") Boolean pretty) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        try {
            List hits = this.factory.getIndexNode(resource).cluster(queryString, queryHint, clustersCount, urlField, titleFields, contentFields, languageFields, sids, algorithm, searchHits);
            msg = JSONConverter.convertToJSON((Object)hits, (boolean)pretty);
            status = Response.Status.OK;
        }
        catch (Exception e) {
            logger.error("error while getting cluster for query : " + queryString, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("error while querying : " + e.getMessage()));
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/refresh")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response refresh(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        try {
            logger.info("invalidating tha cache");
            this.factory.getIndexNode(resource).invalidateCache();
            logger.info("recreating meta-index");
            this.factory.getIndexNode(resource).recreateMetaIndex();
            logger.info("refreshing index types of index");
            this.factory.getIndexNode(resource).refreshIndexTypesOfIndex();
            logger.info("getting meta index values for existing (recreated) meta-index");
            List collectionsOfMetaIndex = null;
            List fieldsOfMetaIndex = null;
            try {
                collectionsOfMetaIndex = this.factory.getIndexNode(resource).getCollectionsFromMeta();
                fieldsOfMetaIndex = this.factory.getIndexNode(resource).getFieldsFromMeta();
            }
            catch (Exception e) {
                logger.warn("query to the meta index failed. Collection and fields will be considered null and will be updated be the next update", (Throwable)e);
            }
            logger.info("resource will have collections : " + collectionsOfMetaIndex);
            logger.info("resource will have fields      : " + fieldsOfMetaIndex);
            if (collectionsOfMetaIndex != null && fieldsOfMetaIndex != null) {
                resource.setCollections(collectionsOfMetaIndex);
                resource.setFields(fieldsOfMetaIndex);
            } else {
                resource.setCollections(Collections.emptyList());
                resource.setFields(Collections.emptyList());
            }
            logger.info("saving resource " + resourceID + "...");
            this.saveResource(resourceID);
            logger.info("saving resource " + resourceID + "...OK");
            msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.TRUE);
            status = Response.Status.OK;
        }
        catch (Exception e) {
            logger.error("error while refershing the index", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
            status = Response.Status.BAD_REQUEST;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/rebuildMetaIndex")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response rebuildMetaIndex(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        try {
            List collections = resource.getCollections();
            List fields = resource.getFields();
            this.factory.getIndexNode(resource).rebuildMetaIndex(collections, fields);
            logger.info("saving resource");
            this.saveResource(resourceID);
            msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.TRUE);
            status = Response.Status.OK;
        }
        catch (Exception e) {
            logger.error("error while rebuilding the meta index", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/activateIndex")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response activateIndex(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @QueryParam(value="indexName") String indexName) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        try {
            boolean activateResult = this.factory.getIndexNode(resource).activateIndex(indexName);
            logger.info("Activate result was: " + activateResult);
            if (activateResult) {
                try {
                    IndexService.updateAllResourcesCollectionsAndFields((FullTextNode)this.factory.getIndexNode(resource), (IndexClient.Builder)((IndexClient.Builder)this.clientProvider.get()), (String)resource.getClusterID(), (IndexDiscovererAPI)this.indexDiscoverer, (String)this.scope);
                    status = Response.Status.OK;
                    msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.TRUE);
                }
                catch (Exception e) {
                    logger.error("Error while updating manager properties", (Throwable)e);
                    status = Response.Status.INTERNAL_SERVER_ERROR;
                    msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
                }
            } else {
                status = Response.Status.OK;
                msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
            }
        }
        catch (Exception e) {
            logger.error("error while activating the index with name : " + indexName, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/deactivateIndex")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deactivateIndex(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @QueryParam(value="indexName") String indexName) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        try {
            boolean deactivateResult = this.factory.getIndexNode(resource).deactivateIndex(indexName);
            logger.info("Deactivate result was: " + deactivateResult);
            if (deactivateResult) {
                try {
                    IndexService.updateAllResourcesCollectionsAndFields((FullTextNode)this.factory.getIndexNode(resource), (IndexClient.Builder)((IndexClient.Builder)this.clientProvider.get()), (String)resource.getClusterID(), (IndexDiscovererAPI)this.indexDiscoverer, (String)this.scope);
                    status = Response.Status.OK;
                    msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.TRUE);
                }
                catch (Exception e) {
                    logger.error("Error while updating manager properties", (Throwable)e);
                    status = Response.Status.INTERNAL_SERVER_ERROR;
                    msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
                }
            } else {
                status = Response.Status.OK;
                msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
            }
        }
        catch (Exception e) {
            logger.error("error while activating the index with name : " + indexName, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/flush")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response flush(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        try {
            try {
                IndexService.updateAllResourcesCollectionsAndFields((FullTextNode)this.factory.getIndexNode(resource), (IndexClient.Builder)((IndexClient.Builder)this.clientProvider.get()), (String)resource.getClusterID(), (IndexDiscovererAPI)this.indexDiscoverer, (String)this.scope);
                status = Response.Status.OK;
                msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                logger.error("Error while updating manager properties", (Throwable)e);
                status = Response.Status.INTERNAL_SERVER_ERROR;
                msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
            }
        }
        catch (Exception e) {
            logger.error("error while flushing", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/deleteIndex")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deleteIndex(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @QueryParam(value="indexName") String indexName) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        try {
            boolean deleteIndexResult = this.factory.getIndexNode(resource).deleteIndex(indexName);
            logger.info("DeleteIndex result was: " + deleteIndexResult);
            if (deleteIndexResult) {
                try {
                    IndexService.updateAllResourcesCollectionsAndFields((FullTextNode)this.factory.getIndexNode(resource), (IndexClient.Builder)((IndexClient.Builder)this.clientProvider.get()), (String)resource.getClusterID(), (IndexDiscovererAPI)this.indexDiscoverer, (String)this.scope);
                    status = Response.Status.OK;
                    msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.TRUE);
                }
                catch (Exception e) {
                    logger.error("Error while updating manager properties", (Throwable)e);
                    status = Response.Status.INTERNAL_SERVER_ERROR;
                    msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
                }
            } else {
                status = Response.Status.OK;
                msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
            }
        }
        catch (Exception e) {
            logger.error("error while deleting the index with name : " + indexName, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/collectionCount")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response collectionCount(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @QueryParam(value="collectionID") String collectionID) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        Long collectionCount = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
            collectionCount = this.factory.getIndexNode(resource).getCollectionDocumentsCount(collectionID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        logger.info("collectionCount for collection :  " + collectionID + " returned : " + collectionCount);
        msg = JSONConverter.convertToJSON((String)"response", (Object)collectionCount.toString());
        status = Response.Status.OK;
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/collectionsOfIndex")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response collectionsOfIndex(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @QueryParam(value="indexName") String indexName) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        Set collections = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
            collections = this.factory.getIndexNode(resource).getCollectionsOfIndex(indexName);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        logger.info("collections of index : " + indexName + " found : " + collections);
        msg = JSONConverter.convertToJSON((String)"response", (Object)collections);
        status = Response.Status.OK;
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/indicesOfCollection")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response indicesOfCollection(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @QueryParam(value="collectionID") String collectionID) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        Set indices = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
            indices = this.factory.getIndexNode(resource).getIndicesOfCollection(collectionID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        logger.info("indices of collection : " + collectionID + " found : " + indices);
        msg = JSONConverter.convertToJSON((String)"response", (Object)indices);
        status = Response.Status.OK;
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @POST
    @Path(value="/{id}/setCollectionsAndFields")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response setCollectionsAndFields(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @FormParam(value="collections") List<String> collections, @FormParam(value="fields") List<String> fields) {
        String msg = null;
        Response.Status status = null;
        try {
            logger.info("collections : " + collections);
            logger.info("fields : " + fields);
            IndexResource resource = (IndexResource)this.getResource(resourceID);
            if (resource == null) {
                msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
                status = Response.Status.NOT_FOUND;
            } else {
                resource.setCollections(collections);
                resource.setFields(fields);
                this.saveResource(resourceID);
                msg = JSONConverter.convertToJSON((String)"Status", (Object)("Resource with ID : " + resourceID + " updated"));
                status = Response.Status.OK;
            }
        }
        catch (Exception e) {
            logger.error("error while setting collections and fields at resource with id : " + resourceID, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Collections and field could not be set in resource with ID : " + resourceID));
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/shutdown")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response shutdown(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @DefaultValue(value="false") @QueryParam(value="delete") Boolean delete) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        try {
            if (delete.booleanValue()) {
                logger.error("shutting down + delete resource with ID : " + resourceID);
                this.factory.getIndexNode(resource).deleteAll();
                logger.error("updating resource collections and fields resource with ID : " + resourceID);
                IndexService.clearResourcesCollectionsAndFields((IndexClient.Builder)((IndexClient.Builder)this.clientProvider.get()), (String)resource.getClusterID(), (IndexDiscovererAPI)this.indexDiscoverer, (String)scope);
            }
            this.factory.getIndexNode(resource).close();
            msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.TRUE);
            status = Response.Status.OK;
        }
        catch (Exception e) {
            logger.error("error while shutting down node with resource ID : " + resourceID, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/destroyCluster")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response destroyCluster(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        Boolean delete = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
            delete = this.factory.getIndexNode(resource).deleteAll();
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        logger.info("deleting all indices...");
        if (!delete.booleanValue()) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
            msg = JSONConverter.convertToJSON((Object)"response", (boolean)false);
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        logger.info("deleting all indices...OK");
        String currentEndpoint = null;
        status = Response.Status.OK;
        boolean hasFailed = false;
        try {
            Map resources = this.indexDiscoverer.discoverFulltextIndexNodes(resource.getClusterID(), null, null, this.scope);
            logger.info("will destroy the resources in : " + resources);
            for (Map.Entry resourceEnpdoint : resources.entrySet()) {
                String endpoint = (String)resourceEnpdoint.getKey();
                for (String rID : (Set)resourceEnpdoint.getValue()) {
                    if (resourceID.equalsIgnoreCase(rID)) {
                        currentEndpoint = endpoint;
                        continue;
                    }
                    logger.info("Calling destroy on resource ID : " + rID + "...");
                    IndexClient client = ((IndexClient.Builder)this.clientProvider.get()).scope(resource.getScope()).endpoint(endpoint).resourceID(rID).build();
                    try {
                        if (!client.destroy().booleanValue()) {
                            hasFailed = true;
                            logger.warn("destroy on resource ID : " + rID + "failed");
                            continue;
                        }
                        logger.info("Calling destroy on resource ID : " + rID + "...OK");
                    }
                    catch (Exception e) {
                        hasFailed = true;
                        logger.warn("destroy on resource ID : " + rID + "failed", (Throwable)e);
                    }
                }
                status = Response.Status.OK;
            }
        }
        catch (Exception e) {
            logger.error("error while destroying resources of the cluster with id : " + resource.getClusterID(), (Throwable)e);
            hasFailed = true;
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        if (hasFailed) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
        } else {
            try {
                if (currentEndpoint == null) {
                    logger.warn("current endpoing not found. cant call destroy");
                } else {
                    IndexClient client = ((IndexClient.Builder)this.clientProvider.get()).scope(resource.getScope()).endpoint(currentEndpoint).resourceID(resourceID).build();
                    if (!client.destroy().booleanValue()) {
                        hasFailed = true;
                        status = Response.Status.INTERNAL_SERVER_ERROR;
                    }
                }
            }
            catch (Exception e) {
                logger.error("error while destroying local resource with id : " + resourceID, (Throwable)e);
                hasFailed = true;
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        msg = JSONConverter.convertToJSON((Object)"response", (!hasFailed ? 1 : 0) != 0);
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/{id}/deleteDocuments")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deleteDocuments(@HeaderParam(value="gcube-scope") String scope, @PathParam(value="id") String resourceID, @QueryParam(value="docIDs") List<String> docIDs) {
        String msg = null;
        Response.Status status = null;
        IndexResource resource = null;
        Boolean delete = null;
        try {
            resource = (IndexResource)this.getResource(resourceID);
            delete = this.factory.getIndexNode(resource).deleteDocuments(docIDs);
            if (delete.booleanValue()) {
                status = Response.Status.OK;
                msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.TRUE);
            } else {
                status = Response.Status.INTERNAL_SERVER_ERROR;
                msg = JSONConverter.convertToJSON((String)"response", (Object)Boolean.FALSE);
            }
        }
        catch (ResourceNotFoundException e) {
            logger.warn("error while getting resource", (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"Error", (Object)("Resource with ID : " + resourceID + " not found"));
            status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    public static void updateAllResourcesCollectionsAndFields(FullTextNode fulltextnode, IndexClient.Builder clientBuilder, String clusterID, IndexDiscovererAPI<IndexResource> indexDiscoverer, String scope) throws Exception {
        logger.info("will discover index nodes with clusterID : " + clusterID);
        Map endpoints = indexDiscoverer.discoverFulltextIndexNodes(clusterID, null, null, scope);
        logger.info("found endpoints : " + endpoints);
        if (endpoints == null || endpoints.size() == 0) {
            logger.warn("no endpoints found to update");
            return;
        }
        for (String endpoint : endpoints.keySet()) {
            for (String key : (Set)endpoints.get(endpoint)) {
                logger.info("Recreating resource " + endpoint + " " + key);
                try {
                    IndexClient client = clientBuilder.scope(fulltextnode.getScope()).endpoint(endpoint).resourceID(key).build();
                    client.refresh();
                }
                catch (Exception e) {
                    logger.error("Exception", (Throwable)e);
                    throw e;
                }
            }
        }
    }

    private static void clearResourcesCollectionsAndFields(IndexClient.Builder clientBuilder, String clusterID, IndexDiscovererAPI<IndexResource> indexDiscoverer, String scope) throws Exception {
        ArrayList collectionsOfIndex = new ArrayList();
        ArrayList fieldsOfIndex = new ArrayList();
        logger.info("fields to be added: " + fieldsOfIndex);
        logger.info("Collections to be added: " + collectionsOfIndex);
        Map endpoints = indexDiscoverer.discoverFulltextIndexNodes(clusterID, null, null, scope);
        logger.info("found endpoints : " + endpoints);
        if (endpoints == null || endpoints.size() == 0) {
            logger.warn("no endpoints found to clear");
            return;
        }
        for (String endpoint : endpoints.keySet()) {
            for (String key : (Set)endpoints.get(endpoint)) {
                logger.info("Recreating resource " + endpoint + " " + key);
                try {
                    IndexClient client = clientBuilder.scope(scope).endpoint(endpoint).resourceID(key).build();
                    client.setCollectionsAndFields(collectionsOfIndex, fieldsOfIndex);
                }
                catch (Exception e) {
                    logger.error("Exception", (Throwable)e);
                    throw e;
                }
            }
        }
    }
}

