/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service;

import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.DecoderException;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.global.Global;
import org.elasticsearch.search.aggregations.bucket.global.GlobalBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.DoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.gcube.rest.index.common.apis.IndexServiceI;
import org.gcube.rest.index.common.search.Query;
import org.gcube.rest.index.common.search.SearchResult;
import org.gcube.rest.index.common.search.Search_Response;
import org.gcube.rest.index.common.search.facets.Facet;
import org.gcube.rest.index.common.search.facets.Facets;
import org.gcube.rest.index.common.tools.MapTransformations;
import org.gcube.rest.index.common.tools.Toolbox;
import org.gcube.rest.index.service.accessors.CacheAccessor;
import org.gcube.rest.index.service.accessors.IndexAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class IndexService
implements IndexServiceI {
    static final Logger logger = LoggerFactory.getLogger(IndexService.class);
    private static final Gson prettygson = new GsonBuilder().setPrettyPrinting().create();

    @GET
    @Path(value="/listCollections")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response listCollections(@HeaderParam(value="gcube-scope") String gcubeScope) {
        return CacheAccessor.getIndexServiceCache().listCollections();
    }

    @GET
    @Path(value="/getAllCollectionFields")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getAllCollectionFields(@DefaultValue(value="true") @QueryParam(value="aliasFields") boolean aliasFields, @HeaderParam(value="gcube-scope") String gcubeScope) {
        return CacheAccessor.getIndexServiceCache().getAllCollectionFields(aliasFields);
    }

    @POST
    @Path(value="/create/{collectionID}")
    @Consumes(value={"application/x-www-form-urlencoded; charset=UTF-8"})
    public Response create(@PathParam(value="collectionID") String collectionID, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        try {
            IndexAccessor.getFullTextNode().createIndex(collectionID.toLowerCase());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)("Failed to create index: " + collectionID.toLowerCase())).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)("Created index: " + collectionID.toLowerCase())).build();
    }

    @POST
    @Path(value="/insert/{collectionID}/{recordID}")
    @Consumes(value={"application/x-www-form-urlencoded; charset=UTF-8"})
    public Response insert(@PathParam(value="collectionID") String collectionID, @PathParam(value="recordID") String recordID, @FormParam(value="recordJSON") String recordJSON, @HeaderParam(value="gcube-scope") String gcubeScope) {
        String transformer;
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        if (recordJSON == null || recordJSON.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No record payload is provided").build();
        }
        Response resp = this.getJSONTransformer(collectionID.toLowerCase(), gcubeScope);
        String string = transformer = resp.getStatus() != 500 ? (String)((Map)prettygson.fromJson((String)resp.getEntity(), new /* Unavailable Anonymous Inner Class!! */.getType())).get(collectionID.toLowerCase()) : null;
        if (transformer != null && !transformer.isEmpty()) {
            Chainr chainr = Chainr.fromSpec((Object)JsonUtils.jsonToList((String)transformer));
            recordJSON = JsonUtils.toJsonString((Object)chainr.transform(JsonUtils.jsonToObject((String)recordJSON)));
        }
        IndexResponse response = recordID == null || recordID.isEmpty() ? IndexAccessor.getFullTextNode().addRecord(collectionID.toLowerCase(), recordJSON) : IndexAccessor.getFullTextNode().addRecord(collectionID.toLowerCase(), recordID, recordJSON);
        String modType = response.isCreated() ? "Created" : "Updated";
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)(modType + " record with id: " + response.getId())).build();
    }

    @POST
    @Path(value="/insert/{collectionID}")
    @Consumes(value={"application/x-www-form-urlencoded; charset=UTF-8"})
    public Response insert(@PathParam(value="collectionID") String collectionID, @FormParam(value="recordJSON") String recordJSON, @HeaderParam(value="gcube-scope") String gcubeScope) {
        return this.insert(collectionID.toLowerCase(), null, recordJSON, gcubeScope);
    }

    @DELETE
    @Path(value="/delete/{collectionID}/{recordID}")
    public Response delete(@PathParam(value="collectionID") String collectionID, @PathParam(value="recordID") String recordID, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        DeleteResponse response = (DeleteResponse)IndexAccessor.getFullTextNode().getIndexClient().prepareDelete(collectionID.toLowerCase(), "gcube", recordID).get();
        String responseStr = response.isFound() ? "Deleted document with id " + recordID + " from collection " + collectionID.toLowerCase() : "Could not find document with id " + recordID + " from collection " + collectionID.toLowerCase() + " to delete!";
        return Response.status((Response.Status)Response.Status.OK).entity((Object)(responseStr + " record with id: " + response.getId())).build();
    }

    @DELETE
    @Path(value="/dropCollection/{collectionID}")
    public Response dropCollection(@PathParam(value="collectionID") String collectionID, @HeaderParam(value="gcube-scope") String gcubeScope) {
        DeleteIndexResponse response = (DeleteIndexResponse)IndexAccessor.getFullTextNode().getIndexClient().admin().indices().delete(new DeleteIndexRequest(collectionID.toLowerCase())).actionGet();
        if (!response.isAcknowledged()) {
            Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)("Did not delete collection  " + collectionID.toLowerCase())).build();
        } else {
            Response.status((int)200).entity((Object)("Deleted collectiList<SearchResult>on  " + collectionID.toLowerCase())).build();
        }
        return Response.status((int)200).entity((Object)("Deleted collection  " + collectionID.toLowerCase())).build();
    }

    @GET
    @Path(value="/listFulltextEndpoints")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response listFulltextEndpoints(@QueryParam(value="scope") String scope, @HeaderParam(value="gcube-scope") String gcubeScope) {
        return CacheAccessor.getIndexServiceCache().listFulltextEndpoints(scope);
    }

    @GET
    @Path(value="/getCollectionFieldsAlias")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getCollectionFieldsAlias(@QueryParam(value="collectionID") String collectionID, @DefaultValue(value="true") @QueryParam(value="fromIndexToView") boolean fromIndexToView, @HeaderParam(value="gcube-scope") String gcubeScope) {
        return CacheAccessor.getIndexServiceCache().getCollectionFieldsAlias(collectionID.toLowerCase(), fromIndexToView);
    }

    @POST
    @Path(value="/setCollectionFieldsAlias")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response setCollectionFieldsAlias(@QueryParam(value="collectionID") String collectionID, @FormParam(value="mappingsJSON") String mappingsJSON, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        if (mappingsJSON == null || mappingsJSON.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No mappings json is provided").build();
        }
        mappingsJSON = "{\"mappings\":\"" + Toolbox.encode((String)mappingsJSON) + "\"}";
        IndexResponse response = IndexAccessor.getFullTextNode().addRecord("gcube-collection-mappings", collectionID.toLowerCase(), mappingsJSON);
        String modType = response.isCreated() ? "Created" : "Updated";
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)(modType + " mappings of collection: " + response.getId())).build();
    }

    @DELETE
    @Path(value="/deleteCollectionFieldsAlias")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deleteCollectionFieldsAlias(@QueryParam(value="collectionID") String collectionID, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        DeleteResponse response = (DeleteResponse)IndexAccessor.getFullTextNode().getIndexClient().prepareDelete("gcube-collection-mappings", "gcube", collectionID.toLowerCase()).get();
        String responseStr = response.isFound() ? "Deleted configuration of collection " + collectionID.toLowerCase() : "Could not find any configuration for collection " + collectionID.toLowerCase() + " to delete!";
        return Response.status((Response.Status)Response.Status.OK).entity((Object)responseStr).build();
    }

    @GET
    @Path(value="/getJSONTransformer")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getJSONTransformer(@QueryParam(value="collectionID") String collectionID, @HeaderParam(value="gcube-scope") String gcubeScope) {
        return CacheAccessor.getIndexServiceCache().getJSONTransformer(collectionID.toLowerCase());
    }

    @POST
    @Path(value="/setJSONTransformer")
    @Consumes(value={"application/x-www-form-urlencoded; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response setJSONTransformer(@QueryParam(value="collectionID") String collectionID, @FormParam(value="transformerJSON") String transformerJSON, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        if (transformerJSON == null || transformerJSON.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No transformer json is provided").build();
        }
        transformerJSON = "{\"transformer\":\"" + Toolbox.encode((String)transformerJSON) + "\"}";
        IndexResponse response = IndexAccessor.getFullTextNode().addRecord("gcube-collection-transformers", collectionID.toLowerCase(), transformerJSON);
        if (response.isCreated()) {
            while (CacheAccessor.getIndexServiceCache().getJSONTransformerUncached(collectionID.toLowerCase()).get(collectionID.toLowerCase()) == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        String modType = response.isCreated() ? "Created" : "Updated";
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)(modType + " mappings of collection: " + response.getId())).build();
    }

    @DELETE
    @Path(value="/deleteJSONTransformer")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deleteJSONTransformer(@QueryParam(value="collectionID") String collectionID, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        DeleteResponse response = (DeleteResponse)IndexAccessor.getFullTextNode().getIndexClient().prepareDelete("gcube-collection-transformers", "gcube", collectionID.toLowerCase()).get();
        String responseStr = response.isFound() ? "Deleted configuration of collection " + collectionID.toLowerCase() : "Could not find any configuration for collection " + collectionID.toLowerCase() + " to delete!";
        return Response.status((Response.Status)Response.Status.OK).entity((Object)responseStr).build();
    }

    @GET
    @Path(value="/getCollectionInfo")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getCollectionInfo(@QueryParam(value="collectionID") String collectionID, @HeaderParam(value="gcube-scope") String gcubeScope) {
        return CacheAccessor.getIndexServiceCache().getCollectionInfo(collectionID.toLowerCase());
    }

    @POST
    @Path(value="/setCollectionInfo")
    @Consumes(value={"application/x-www-form-urlencoded; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response setCollectionInfo(@QueryParam(value="collectionID") String collectionID, @FormParam(value="infoJSON") String infoJSON, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        if (infoJSON == null || infoJSON.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection info json is provided").build();
        }
        infoJSON = "{\"info\":\"" + Toolbox.encode((String)infoJSON) + "\"}";
        IndexResponse response = IndexAccessor.getFullTextNode().addRecord("gcube-collection-info", collectionID.toLowerCase(), infoJSON);
        String modType = response.isCreated() ? "Created" : "Updated";
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)(modType + " information of collection: " + response.getId())).build();
    }

    @DELETE
    @Path(value="/deleteCollectionInfo")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deleteCollectionInfo(@QueryParam(value="collectionID") String collectionID, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        DeleteResponse response = (DeleteResponse)IndexAccessor.getFullTextNode().getIndexClient().prepareDelete("gcube-collection-info", "gcube", collectionID.toLowerCase()).get();
        String responseStr = response.isFound() ? "Deleted information of collection " + collectionID.toLowerCase() : "Could not find any information for collection " + collectionID.toLowerCase() + " to delete!";
        return Response.status((Response.Status)Response.Status.OK).entity((Object)responseStr).build();
    }

    @POST
    @Path(value="/search")
    @Consumes(value={"application/x-www-form-urlencoded; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response search(@FormParam(value="query") String queryJson, @HeaderParam(value="gcube-scope") String gcubeScope) {
        SearchHit[] search_hits;
        BoolQueryBuilder mainQb = QueryBuilders.boolQuery();
        Map mapAlias = (Map)prettygson.fromJson((String)this.getCollectionFieldsAlias("", false, gcubeScope).getEntity(), new /* Unavailable Anonymous Inner Class!! */.getType());
        Map inversedMapAlias = (Map)prettygson.fromJson((String)this.getCollectionFieldsAlias("", true, gcubeScope).getEntity(), new /* Unavailable Anonymous Inner Class!! */.getType());
        Map flatMapAlias = MapTransformations.flatMap((Map)mapAlias);
        Map flatInversedMapAlias = MapTransformations.flatMap((Map)inversedMapAlias);
        try {
            queryJson = Toolbox.decode((String)queryJson);
        }
        catch (DecoderException ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not access or apply the collection field alias names").build();
        }
        Query query = (Query)prettygson.fromJson(queryJson, Query.class);
        Map outerMap = query.get_SearchTerms();
        int position_paging = query.getPosition_paging();
        int size_paging = query.getSize_paging();
        ArrayList<String> list = new ArrayList<String>();
        Iterator keySetIteratorOuter = outerMap.keySet().iterator();
        while (keySetIteratorOuter.hasNext()) {
            BoolQueryBuilder qb = QueryBuilders.boolQuery();
            String keyOuter = (String)keySetIteratorOuter.next();
            Map innerMap = (Map)outerMap.get(keyOuter);
            list.add(keyOuter);
            for (String fieldAliasName2 : innerMap.keySet()) {
                String fieldValue = (String)innerMap.get(fieldAliasName2);
                SearchHit[] collection_alias = (SearchHit[])mapAlias.get(keyOuter);
                if (collection_alias != null) {
                    String fieldName2 = (String)collection_alias.get(fieldAliasName2);
                    if (fieldName2 == null) {
                        qb = qb.must((QueryBuilder)QueryBuilders.queryStringQuery((String)fieldValue).field(fieldAliasName2));
                        continue;
                    }
                    qb = qb.must((QueryBuilder)QueryBuilders.queryStringQuery((String)fieldValue).field(fieldName2));
                    continue;
                }
                qb = qb.must((QueryBuilder)QueryBuilders.queryStringQuery((String)fieldValue).field(fieldAliasName2));
            }
            mainQb = mainQb.should((QueryBuilder)QueryBuilders.indicesQuery((QueryBuilder)qb, (String[])new String[]{keyOuter}).noMatchQuery("none"));
        }
        String[] Indexes = list.toArray(new String[list.size()]);
        SearchRequestBuilder search_results = IndexAccessor.getFullTextNode().getIndexClient().prepareSearch(Indexes).setSearchType(SearchType.QUERY_THEN_FETCH).setQuery((QueryBuilder)mainQb).setFrom(position_paging).setSize(size_paging);
        if (!query.getFacetFields().isEmpty()) {
            HashSet alreadyAdded = new HashSet();
            GlobalBuilder aggregation = AggregationBuilders.global((String)"aggregations");
            query.getFacetFields().forEach((fieldAliasName, howMany) -> {
                List alias = (List)flatMapAlias.get(fieldAliasName);
                if (alias != null && !alias.isEmpty()) {
                    String fieldName = (String)alias.get(0);
                    if (!alreadyAdded.contains(fieldName)) {
                        aggregation.subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)fieldName).field(fieldName)).size(howMany.intValue()));
                        alreadyAdded.add(fieldName);
                    }
                } else if (!alreadyAdded.contains(fieldAliasName)) {
                    aggregation.subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)fieldAliasName).field(fieldAliasName)).size(howMany.intValue()));
                    alreadyAdded.add(fieldAliasName);
                }
            });
            search_results.addAggregation((AbstractAggregationBuilder)aggregation);
        }
        logger.debug("===========SUBMITTED QUERY========== " + query.toString());
        SearchResponse response = (SearchResponse)search_results.execute().actionGet();
        long totalHits = response.getHits().getTotalHits();
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (SearchHit hit : search_hits = response.getHits().getHits()) {
            Map source_alias_map = hit.getSource();
            HashMap source_map = new HashMap();
            for (String fieldName3 : source_alias_map.keySet()) {
                Object fieldValue = source_alias_map.get(fieldName3);
                Map collection_inversed_alias = (Map)inversedMapAlias.get(hit.getIndex());
                if (collection_inversed_alias != null) {
                    String fieldAliasName3 = (String)collection_inversed_alias.get(fieldName3);
                    if (fieldAliasName3 == null) {
                        source_map.put(fieldName3, fieldValue);
                        continue;
                    }
                    source_map.put(fieldAliasName3, fieldValue);
                    continue;
                }
                source_map.put(fieldName3, fieldValue);
            }
            SearchResult searchResult = new SearchResult(hit.getId(), hit.getIndex(), source_map);
            results.add(searchResult);
        }
        Search_Response searchresponse = new Search_Response();
        searchresponse.setTotalHits(totalHits);
        searchresponse.setSearchResultList(results);
        if (!query.getFacetFields().isEmpty()) {
            Map aggregations = ((Global)response.getAggregations().get("aggregations")).getAggregations().getAsMap();
            Facets facets = new Facets();
            aggregations.forEach((fieldName, terms) -> {
                Facet facet = new Facet();
                List buckets = terms instanceof StringTerms ? ((StringTerms)terms).getBuckets() : (terms instanceof DoubleTerms ? ((DoubleTerms)terms).getBuckets() : (terms instanceof LongTerms ? ((LongTerms)terms).getBuckets() : ((UnmappedTerms)terms).getBuckets()));
                buckets.forEach(bucket -> facet.addPair(bucket.getKeyAsString(), bucket.getDocCount()));
                List inversedAlias = (List)flatInversedMapAlias.get(fieldName);
                if (inversedAlias != null) {
                    String fieldAliasName = (String)inversedAlias.get(0);
                    facets.addFacet(fieldAliasName, facet);
                } else {
                    facets.addFacet(fieldName, facet);
                }
            });
            searchresponse.setFacets(facets);
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)prettygson.toJson((Object)searchresponse)).build();
    }
}

