/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service.accessors;

import java.io.Serializable;
import java.util.Set;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.gcube.elasticsearch.FullTextNode;
import org.gcube.rest.index.common.discover.IndexDiscoverer;
import org.gcube.rest.index.service.jobs.IndexReplicationUpdater;
import org.gcube.rest.index.service.resources.ServiceProperties;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexAccessor
implements Serializable,
ServletContextListener {
    private static final long serialVersionUID = 1L;
    private static FullTextNode ftn;
    private static final Logger logger;
    private Scheduler scheduler;
    private static final int UPDATE_REPLICATION_INTERVAL = 60;

    public void contextDestroyed(ServletContextEvent context) {
        ftn.stopAndCloseNode();
    }

    public void contextInitialized(ServletContextEvent context) {
        ServiceProperties indexProps = new ServiceProperties();
        try {
            logger.info("Will initiate an index node by the following properties read from local setup (deploy.properties)");
            logger.info("fragm_cnt           : " + indexProps.getMaxFragmentCnt());
            logger.info("fragm_size          : " + indexProps.getMaxFragmentSize());
            logger.info("noShards            : " + indexProps.getNoShards());
            logger.info("esPort              : " + indexProps.getElasticSearchPort());
            logger.info("dataDirectory       : " + indexProps.getDataDir());
            logger.info("maxResults          : " + indexProps.getMaxResults());
            logger.info("hostname            : " + indexProps.getHostname());
            logger.info("Setting index scope to " + indexProps.getScope());
            logger.info("Initializing fulltextnode...");
            FullTextNode.Builder builder = new FullTextNode.Builder().scope(indexProps.getScope()).hostname(indexProps.getHostname()).dataDir(indexProps.getDataDir()).clusterName("gCubeIndex").noOfShards(Integer.valueOf(indexProps.getNoShards())).maxFragmentCnt(Integer.valueOf(indexProps.getMaxFragmentCnt())).maxResults(Integer.valueOf(indexProps.getMaxResults())).maxFragmentSize(Integer.valueOf(indexProps.getMaxFragmentSize()));
            ftn = builder.build();
            Set indexNodes = new IndexDiscoverer().discoverFulltextIndexNodes(indexProps.getScope());
            logger.info("Initializing Index Node...");
            ftn.createOrJoinCluster(indexNodes);
            logger.info("Index Node initalized!");
            try {
                this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            }
            catch (SchedulerException schedulerException) {
                // empty catch block
            }
            if (this.scheduler != null) {
                logger.debug("Initializing smart replication factor updater!");
                JobDetail job = JobBuilder.newJob(IndexReplicationUpdater.class).build();
                Trigger trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(60).repeatForever()).build();
                this.scheduler.getContext().put("ftn", (Object)ftn);
                this.scheduler.scheduleJob(job, trigger);
                this.scheduler.start();
            } else {
                logger.error("Could not initate smart replication factor updater! However, do not panic...");
            }
        }
        catch (Exception e) {
            logger.error("Error while initializing the index client", (Throwable)e);
        }
    }

    public static FullTextNode getFullTextNode() {
        return ftn;
    }

    public static String getScope() {
        return ftn.getScope();
    }

    public static String getClusterName() {
        return ftn.getClusterName();
    }

    static {
        logger = LoggerFactory.getLogger(IndexAccessor.class);
    }
}

