/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service.cache;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.github.wnameless.json.flattener.JsonFlattener;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.DecoderException;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.gcube.rest.index.common.discover.IndexDiscoverer;
import org.gcube.rest.index.common.tools.Toolbox;
import org.gcube.rest.index.service.accessors.IndexAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;

public class IndexServiceCache {
    static final Logger logger = LoggerFactory.getLogger(IndexServiceCache.class);
    private static final Gson prettygson = new GsonBuilder().setPrettyPrinting().create();

    protected IndexServiceCache() {
    }

    @Cacheable(value={"COLLECTION_NAMES"})
    public Response listCollections() {
        ArrayList indicesNames = IndexAccessor.getFullTextNode().getAllCollections();
        Iterator iterator = indicesNames.iterator();
        while (iterator.hasNext()) {
            String collectionName = (String)iterator.next();
            if (!collectionName.equals("gcube-collection-mappings") && !collectionName.equals("gcube-collection-transformers") && !collectionName.equals("gcube-collection-info")) continue;
            iterator.remove();
        }
        String msg = prettygson.toJson((Object)indicesNames);
        return Response.status((int)200).entity((Object)msg).build();
    }

    @Cacheable(value={"COLLECTIONS_FIELDS"})
    public Response getAllCollectionFields(boolean aliasFields) {
        ImmutableOpenMap mappings = ((GetMappingsResponse)IndexAccessor.getFullTextNode().getIndexClient().admin().indices().getMappings(new GetMappingsRequest()).actionGet()).getMappings();
        HashMap collectionFields = new HashMap();
        for (ObjectObjectCursor item : mappings) {
            String collectionName = (String)item.key;
            HashMap fieldsNameAndType = new HashMap();
            ImmutableOpenMap value = (ImmutableOpenMap)item.value;
            for (ObjectObjectCursor indexTypeFieldNameType : value) {
                Map fieldNameType = new HashMap();
                try {
                    fieldNameType = JsonFlattener.flattenAsMap((String)prettygson.toJson((Object)((MappingMetaData)indexTypeFieldNameType.value).getSourceAsMap()));
                }
                catch (IOException e) {
                    return Response.status((int)500).entity((Object)"Could not parse collection fields from ElasticSearch").build();
                }
                fieldNameType.entrySet().stream().forEach(keyval -> {
                    String fieldName = (String)keyval.getKey();
                    String fieldDataType = (String)keyval.getValue();
                    if (!(fieldName = fieldName.substring(0, fieldName.lastIndexOf("."))).endsWith(".type")) {
                        fieldDataType = "string";
                    }
                    fieldName = fieldName.replace("properties.properties.", "properties._properties_.").replace("properties.", "").replace("_properties_", "properties");
                    fieldsNameAndType.put(fieldName, fieldDataType);
                });
            }
            collectionFields.put(collectionName, new ArrayList(fieldsNameAndType.keySet()));
        }
        collectionFields.remove("gcube-collection-transformers");
        collectionFields.remove("gcube-collection-mappings");
        collectionFields.remove("gcube-collection-info");
        if (aliasFields) {
            Map collectionFieldAliases = (Map)prettygson.fromJson((String)this.getCollectionFieldsAlias("", true).getEntity(), new /* Unavailable Anonymous Inner Class!! */.getType());
            HashSet intersection = new HashSet(collectionFields.keySet());
            intersection.retainAll(collectionFieldAliases.keySet());
            for (String collectionName : intersection) {
                ArrayList<String> aliasNames = new ArrayList<String>();
                for (String indexFieldName : (List)collectionFields.get(collectionName)) {
                    String aliasName = (String)((Map)collectionFieldAliases.get(collectionName)).get(indexFieldName);
                    if (aliasName == null || aliasName.isEmpty()) {
                        aliasNames.add(indexFieldName);
                        continue;
                    }
                    aliasNames.add(aliasName);
                }
                collectionFields.put(collectionName, aliasNames);
            }
        }
        String msg = prettygson.toJson(collectionFields);
        return Response.status((int)200).entity((Object)msg).build();
    }

    @Cacheable(value={"COLLECTIONS_FIELDS_ALIASES"})
    public Response getCollectionFieldsAlias(String collectionID, boolean fromIndexToView) {
        SearchResponse resp;
        HashMap<String, Map> collFieldAlias = new HashMap<String, Map>();
        SearchRequestBuilder srb = IndexAccessor.getFullTextNode().getIndexClient().prepareSearch(new String[]{"gcube-collection-mappings"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(10000);
        if (collectionID != null && !collectionID.isEmpty()) {
            srb = srb.setQuery((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)collectionID));
        }
        try {
            resp = (SearchResponse)srb.execute().actionGet();
        }
        catch (IndexNotFoundException ex) {
            return Response.status((int)200).entity((Object)prettygson.toJson(collFieldAlias)).build();
        }
        SearchHits hits = resp.getHits();
        Iterator iter = hits.iterator();
        try {
            while (iter.hasNext()) {
                SearchHit sh = (SearchHit)iter.next();
                String id = sh.getId();
                String source = sh.getSourceAsString();
                source = source.substring(13, source.length() - 2);
                try {
                    source = Toolbox.decode((String)source);
                }
                catch (DecoderException de) {
                    logger.error("Could not decode the string of the Transformer", (Object)de.getMessage());
                }
                Map mappings = (Map)prettygson.fromJson(source, new /* Unavailable Anonymous Inner Class!! */.getType());
                if (!fromIndexToView) {
                    HashMap mapInversed = new HashMap();
                    for (Map.Entry entry : mappings.entrySet()) {
                        mapInversed.put(entry.getValue(), entry.getKey());
                    }
                    collFieldAlias.put(id, mapInversed);
                    continue;
                }
                collFieldAlias.put(id, mappings);
            }
            return Response.status((int)200).entity((Object)prettygson.toJson(collFieldAlias)).build();
        }
        catch (JsonSyntaxException ex) {
            return Response.status((int)500).entity((Object)"Could not parse the JSON into a Map").build();
        }
    }

    @Cacheable(value={"ENDPOINTS"})
    public Response listFulltextEndpoints(String scope) {
        IndexDiscoverer indexDiscoverer = new IndexDiscoverer();
        Set endpoints = indexDiscoverer.discoverFulltextIndexNodes(scope);
        String msg = prettygson.toJson((Object)endpoints);
        return Response.status((int)200).entity((Object)msg).build();
    }

    public Map<String, String> getJSONTransformerUncached(String collectionID) {
        SearchResponse resp;
        HashMap<String, String> collectionTransformers = new HashMap<String, String>();
        SearchRequestBuilder srb = IndexAccessor.getFullTextNode().getIndexClient().prepareSearch(new String[]{"gcube-collection-transformers"}).setSearchType(SearchType.QUERY_AND_FETCH).setFrom(0).setSize(10000);
        if (collectionID != null && !collectionID.isEmpty()) {
            srb = srb.setQuery((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)collectionID));
        }
        try {
            resp = (SearchResponse)srb.execute().actionGet();
        }
        catch (IndexNotFoundException ex) {
            return collectionTransformers;
        }
        SearchHits hits = resp.getHits();
        Iterator iter = hits.iterator();
        try {
            while (iter.hasNext()) {
                SearchHit sh = (SearchHit)iter.next();
                String id = sh.getId();
                String source = sh.getSourceAsString();
                source = source == null || source.isEmpty() ? source : source.substring(16, source.length() - 2);
                try {
                    source = Toolbox.decode((String)source);
                }
                catch (DecoderException de) {
                    logger.error("Could not decode the string of the Transformer", (Object)de.getMessage());
                }
                collectionTransformers.put(id, source);
            }
            return collectionTransformers;
        }
        catch (JsonSyntaxException ex) {
            return null;
        }
    }

    @Cacheable(value={"JSON_TRANSFORMERS"})
    public Response getJSONTransformer(String collectionID) {
        Map collectionTransformers = this.getJSONTransformerUncached(collectionID);
        if (collectionTransformers == null) {
            return Response.status((int)500).entity((Object)"Could not parse the JSON into a Map").build();
        }
        return Response.status((int)200).entity((Object)prettygson.toJson((Object)collectionTransformers)).build();
    }

    @Cacheable(value={"COLLECTION_INFOS"})
    public Response getCollectionInfo(String collectionID) {
        SearchResponse resp;
        HashMap<String, String> collectionInfos = new HashMap<String, String>();
        SearchRequestBuilder srb = IndexAccessor.getFullTextNode().getIndexClient().prepareSearch(new String[]{"gcube-collection-info"}).setSearchType(SearchType.QUERY_AND_FETCH).setFrom(0).setSize(10000);
        if (collectionID != null && !collectionID.isEmpty()) {
            srb = srb.setQuery((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)collectionID));
        }
        try {
            resp = (SearchResponse)srb.execute().actionGet();
        }
        catch (IndexNotFoundException ex) {
            return Response.status((int)200).entity((Object)prettygson.toJson(collectionInfos)).build();
        }
        SearchHits hits = resp.getHits();
        Iterator iter = hits.iterator();
        try {
            while (iter.hasNext()) {
                SearchHit sh = (SearchHit)iter.next();
                String id = sh.getId();
                String source = sh.getSourceAsString();
                source = source == null || source.isEmpty() ? source : source.substring(9, source.length() - 2);
                try {
                    source = Toolbox.decode((String)source);
                }
                catch (DecoderException de) {
                    logger.error("Could not decode the string of the collection infos", (Object)de.getMessage());
                }
                collectionInfos.put(id, source);
            }
            return Response.status((int)200).entity((Object)prettygson.toJson(collectionInfos)).build();
        }
        catch (JsonSyntaxException ex) {
            return Response.status((int)500).entity((Object)"Could not parse the JSON into a Map").build();
        }
    }
}

