/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service.cache;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.github.wnameless.json.flattener.JsonFlattener;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.DecoderException;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.gcube.rest.index.common.discover.IndexDiscoverer;
import org.gcube.rest.index.common.entities.CollectionInfo;
import org.gcube.rest.index.common.entities.configuration.DatasourceType;
import org.gcube.rest.index.common.entities.fields.Field;
import org.gcube.rest.index.common.entities.fields.config.FacetType;
import org.gcube.rest.index.common.entities.fields.config.FieldConfig;
import org.gcube.rest.index.common.entities.fields.helpers.FieldTranslator;
import org.gcube.rest.index.common.tools.Toolbox;
import org.gcube.rest.index.service.accessors.IndexAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;

/*
 * Exception performing whole class analysis ignored.
 */
public class IndexServiceCache {
    static final Logger logger = LoggerFactory.getLogger(IndexServiceCache.class);
    private static final Gson prettygson = new GsonBuilder().setPrettyPrinting().create();

    protected IndexServiceCache() {
    }

    public List<String> listCollections(String collectionDomain) {
        ArrayList<String> collections = new ArrayList<String>();
        for (CollectionInfo ci : this.getCompleteCollectionInfo(null, collectionDomain).values()) {
            collections.add(ci.getId());
        }
        return collections;
    }

    public Map<String, Set<Field>> getAllCollectionFields(boolean aliasFields, String collectionDomain) throws IOException {
        Map colls = this.getCompleteCollectionInfo(null, collectionDomain);
        HashMap<String, Set<Field>> collectionFields = new HashMap<String, Set<Field>>();
        for (CollectionInfo ci : colls.values()) {
            if (aliasFields && (ci.getCollectionFieldsAliases() != null || ci.getCollectionFieldsAliases().isEmpty())) {
                HashSet<Field> aliasedFields = new HashSet<Field>(ci.getCollectionFields().size());
                for (Field origField : ci.getCollectionFields()) {
                    String aliased = (String)ci.getCollectionFieldsAliases().get(origField.getName());
                    if (aliased != null && !aliased.isEmpty()) {
                        Field f = Field.copyOf((Field)origField);
                        f.setName(aliased);
                        aliasedFields.add(f);
                        continue;
                    }
                    aliasedFields.add(origField);
                }
                collectionFields.put(ci.getId(), aliasedFields);
                continue;
            }
            collectionFields.put(ci.getId(), ci.getCollectionFields());
        }
        return collectionFields;
    }

    public static Map<String, Set<Field>> getAllCollectionFieldsFromES() throws IOException {
        ImmutableOpenMap mappings = ((GetMappingsResponse)IndexAccessor.getFullTextNode().getIndexClient().admin().indices().getMappings(new GetMappingsRequest()).actionGet()).getMappings();
        HashMap<String, Set<Field>> collectionFields = new HashMap<String, Set<Field>>();
        for (ObjectObjectCursor item : mappings) {
            String collectionName = (String)item.key;
            HashSet esFields = new HashSet();
            ImmutableOpenMap value = (ImmutableOpenMap)item.value;
            for (ObjectObjectCursor indexTypeFieldNameType : value) {
                Map fieldNameType = JsonFlattener.flattenAsMap((String)prettygson.toJson((Object)((MappingMetaData)indexTypeFieldNameType.value).getSourceAsMap()));
                fieldNameType.entrySet().stream().forEach(keyval -> {
                    String fieldName = (String)keyval.getKey();
                    String fieldDataType = (String)keyval.getValue();
                    if (!fieldName.endsWith(".type")) {
                        return;
                    }
                    fieldName = fieldName.substring(0, fieldName.lastIndexOf("."));
                    fieldName = fieldName.replace("properties.properties.", "properties._properties_.").replace("properties.", "").replace("_properties_", "properties");
                    for (FacetType ft : FacetType.values()) {
                        if (!fieldName.endsWith(".fields.raw_" + ft.toString().toLowerCase())) continue;
                        return;
                    }
                    esFields.add(new Field(fieldName, FieldTranslator.fromLuceneDataType((String)fieldDataType)));
                });
            }
            collectionFields.put(collectionName, new HashSet(esFields));
        }
        collectionFields.remove("gcube-complete-collection-info");
        return collectionFields;
    }

    public Map<String, Map<String, String>> getCollectionFieldsAlias(String collectionID, String collectionDomain, boolean fromIndexToView) {
        Map collInfo = this.getCompleteCollectionInfo(collectionID, collectionDomain);
        HashMap<String, Map<String, String>> collFieldAlias = new HashMap<String, Map<String, String>>();
        for (CollectionInfo ci : collInfo.values()) {
            Map mappings = ci.getCollectionFieldsAliases();
            if (!fromIndexToView) {
                HashMap mapInversed = new HashMap();
                for (Map.Entry entry : mappings.entrySet()) {
                    mapInversed.put(entry.getValue(), entry.getKey());
                }
                collFieldAlias.put(ci.getId(), mapInversed);
                continue;
            }
            collFieldAlias.put(ci.getId(), mappings);
        }
        return collFieldAlias;
    }

    public Response listFulltextEndpoints(String scope) {
        IndexDiscoverer indexDiscoverer = new IndexDiscoverer();
        Set endpoints = indexDiscoverer.discoverFulltextIndexNodesOfThisAndAllOtherVres(scope);
        String msg = prettygson.toJson((Object)endpoints);
        return Response.status((int)200).entity((Object)msg).build();
    }

    public Map<String, CollectionInfo> getCompleteCollectionInfo(String collectionID, String collectionDomain) throws IndexNotFoundException, JsonSyntaxException {
        HashMap<String, CollectionInfo> completeCollectionInfos = new HashMap<String, CollectionInfo>();
        int windowSize = 10000;
        Map esColl = new HashMap();
        try {
            esColl = IndexServiceCache.getAllCollectionFieldsFromES();
        }
        catch (IOException e) {
            logger.error("Could not build the Collections schema from Elastic");
        }
        if (collectionID != null && !collectionID.isEmpty()) {
            SearchRequestBuilder srb = IndexAccessor.getFullTextNode().getIndexClient().prepareSearch(new String[]{"gcube-complete-collection-info"}).setSearchType(SearchType.QUERY_AND_FETCH).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)collectionID));
            SearchResponse resp = (SearchResponse)srb.execute().actionGet();
            SearchHits hits = resp.getHits();
            for (SearchHit sh : hits) {
                String source = sh.getSourceAsString();
                source = source == null || source.isEmpty() ? source : source.substring(8, source.length() - 2);
                try {
                    source = Toolbox.decode((String)source);
                    CollectionInfo ci = (CollectionInfo)prettygson.fromJson(source, CollectionInfo.class);
                    if (collectionDomain != null && !collectionDomain.isEmpty() && !ci.getCollectionDomain().equals(collectionDomain)) continue;
                    if (DatasourceType.ELASTIC.equals((Object)ci.getDatasourceType()) && esColl.keySet().contains(ci.getId())) {
                        Map configs = ci.getCollectionFieldsConfigs();
                        Set<String> esCollFieldNames = ((Set)esColl.get(ci.getId())).parallelStream().map(field -> field.getName()).collect(Collectors.toSet());
                        esCollFieldNames.forEach(esfieldName -> {
                            FieldConfig fc = (FieldConfig)configs.get(esfieldName);
                            if (fc == null) {
                                configs.put(esfieldName, new FieldConfig());
                            }
                        });
                        Map<String, FieldConfig> fixed = configs.entrySet().parallelStream().filter(entry -> esCollFieldNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                        ci.setCollectionFieldsConfigs(fixed);
                        ci.setCollectionFields((Set)esColl.get(ci.getId()));
                    }
                    completeCollectionInfos.put(ci.getId(), ci);
                }
                catch (DecoderException de) {
                    logger.error("Could not decode the string of the collection infos", (Object)de.getMessage());
                }
            }
        } else {
            Client client = IndexAccessor.getFullTextNode().getIndexClient();
            SearchResponse scrollResp = (SearchResponse)client.prepareSearch(new String[]{"gcube-complete-collection-info"}).setScroll(new TimeValue(60000L)).setSize(10000).execute().actionGet();
            do {
                for (SearchHit sh : scrollResp.getHits().getHits()) {
                    String source = sh.getSourceAsString();
                    source = source == null || source.isEmpty() ? source : source.substring(8, source.length() - 2);
                    try {
                        source = Toolbox.decode((String)source);
                        CollectionInfo ci = (CollectionInfo)prettygson.fromJson(source, CollectionInfo.class);
                        if (ci.getCollectionDomain() != null && !ci.getCollectionDomain().isEmpty() && !ci.getCollectionDomain().equals(collectionDomain)) continue;
                        if (DatasourceType.ELASTIC.equals((Object)ci.getDatasourceType()) && esColl.keySet().contains(ci.getId())) {
                            Map configs = ci.getCollectionFieldsConfigs();
                            Set<String> esCollNames = ((Set)esColl.get(ci.getId())).parallelStream().map(field -> field.getName()).collect(Collectors.toSet());
                            esCollNames.forEach(esfieldName -> {
                                FieldConfig fc = (FieldConfig)configs.get(esfieldName);
                                if (fc == null) {
                                    configs.put(esfieldName, new FieldConfig());
                                }
                            });
                            Map<String, FieldConfig> fixed = configs.entrySet().parallelStream().filter(entry -> esCollNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                            ci.setCollectionFieldsConfigs(fixed);
                            ci.setCollectionFields((Set)esColl.get(ci.getId()));
                        }
                        completeCollectionInfos.put(ci.getId(), ci);
                    }
                    catch (DecoderException de) {
                        logger.error("Could not decode the string of the collection infos", (Object)de.getMessage());
                    }
                }
            } while ((scrollResp = (SearchResponse)client.prepareSearchScroll(scrollResp.getScrollId()).setScroll(new TimeValue(600000L)).execute().actionGet()).getHits().getHits().length != 0);
        }
        return completeCollectionInfos;
    }

    @CacheEvict(value={"COMPLETE_COLLECTION_INFOS", "COLLECTIONS_FIELDS_ALIASES", "COLLECTIONS_FIELDS", "COLLECTION_NAMES", "ENDPOINTS", "JSON_TRANSFORMERS"}, allEntries=true)
    public void clearCompleteCache() {
    }
}

