/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.DecoderException;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.gcube.rest.index.common.entities.CollectionInfo;
import org.gcube.rest.index.common.entities.configuration.CollectionStatus;
import org.gcube.rest.index.common.entities.configuration.DatasourceType;
import org.gcube.rest.index.common.entities.fields.config.FacetType;
import org.gcube.rest.index.common.entities.fields.config.FieldConfig;
import org.gcube.rest.index.common.search.Query;
import org.gcube.rest.index.common.search.Search_Response;
import org.gcube.rest.index.common.tools.MapTransformations;
import org.gcube.rest.index.common.tools.Toolbox;
import org.gcube.rest.index.service.accessors.CacheAccessor;
import org.gcube.rest.index.service.accessors.IndexAccessor;
import org.gcube.rest.index.service.elements.IndexFacet;
import org.gcube.rest.index.service.helpers.IndexFacetFunctions;
import org.gcube.rest.index.service.helpers.IndexResponseFunctions;
import org.gcube.rest.index.service.helpers.IndexSearchFunctions;
import org.gcube.rest.index.service.procedures.InternalProcedures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class IndexService {
    static final Logger logger = LoggerFactory.getLogger(IndexService.class);
    private static final Gson prettygson = new GsonBuilder().setPrettyPrinting().create();

    @GET
    @Path(value="/collectionsDocCount")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response collectionsDocCount(@QueryParam(value="collectionDomain") String collectionDomain, @HeaderParam(value="gcube-scope") String gcubeScope) {
        Map collDocCount = CacheAccessor.getIndexServiceCache().getCollectionDocumentCounts(collectionDomain);
        return Response.status((int)200).entity((Object)prettygson.toJson((Object)collDocCount, new /* Unavailable Anonymous Inner Class!! */.getType())).build();
    }

    @GET
    @Path(value="/listCollections")
    @Produces(value={"application/xml; charset=UTF-8"})
    public Response listCollections(@QueryParam(value="collectionDomain") String collectionDomain, @HeaderParam(value="gcube-scope") String gcubeScope) {
        List col = CacheAccessor.getIndexServiceCache().listCollections(collectionDomain);
        return Response.status((int)200).entity((Object)prettygson.toJson((Object)col, new /* Unavailable Anonymous Inner Class!! */.getType())).build();
    }

    @GET
    @Path(value="/getAllCollectionFields")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getAllCollectionFields(@DefaultValue(value="true") @QueryParam(value="aliasFields") boolean aliasFields, @QueryParam(value="collectionDomain") String collectionDomain, @HeaderParam(value="gcube-scope") String gcubeScope) {
        Map allCollFields;
        try {
            allCollFields = CacheAccessor.getIndexServiceCache().getAllCollectionFields(aliasFields, collectionDomain);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Failed to fetch field names").build();
        }
        return Response.status((int)200).entity((Object)prettygson.toJson((Object)allCollFields, new /* Unavailable Anonymous Inner Class!! */.getType())).build();
    }

    @POST
    @Path(value="/createEmptyIndex")
    @Consumes(value={"application/x-www-form-urlencoded; charset=UTF-8"})
    @Deprecated
    public Response createEmptyIndex(@FormParam(value="cci") CollectionInfo completeColInfo, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (completeColInfo.getId() == null || completeColInfo.getId().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        Map coll = CacheAccessor.getIndexServiceCache().getCompleteCollectionInfo(completeColInfo.getId().toLowerCase(), completeColInfo.getCollectionDomain());
        if (coll == null || coll.isEmpty()) {
            CollectionInfo ci = new CollectionInfo(completeColInfo.getId(), completeColInfo.getCollectionDomain(), DatasourceType.ELASTIC, null, null, new Date());
            this.setCompleteCollectionInfo(prettygson.toJson((Object)ci, new /* Unavailable Anonymous Inner Class!! */.getType()), completeColInfo.getCollectionDomain());
        }
        try {
            IndexAccessor.getFullTextNode().createIndex(completeColInfo);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)("Failed to create index: " + completeColInfo.getId())).build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)("Created index: " + completeColInfo.getId().toLowerCase())).build();
    }

    @POST
    @Path(value="/reIndex")
    @Consumes(value={"application/x-www-form-urlencoded; charset=UTF-8"})
    public Response reIndex(@FormParam(value="cci") String completeColInfoJSON, @HeaderParam(value="gcube-scope") String gcubeScope) {
        CacheAccessor.getIndexServiceCache().clearCompleteCache();
        if (completeColInfoJSON == null || completeColInfoJSON.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No 'cci' parameter specified").build();
        }
        CollectionInfo completeColInfo = null;
        try {
            completeColInfo = (CollectionInfo)prettygson.fromJson(completeColInfoJSON, new /* Unavailable Anonymous Inner Class!! */.getType());
        }
        catch (JsonSyntaxException ex) {
            logger.debug("Could not parse a serialized org.gcube.rest.index.common.entities.CollectionInfo");
        }
        if (completeColInfo.getId() == null || completeColInfo.getId().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        Map coll = CacheAccessor.getIndexServiceCache().getCompleteCollectionInfo(completeColInfo.getId().toLowerCase(), completeColInfo.getCollectionDomain());
        if (coll == null || coll.isEmpty()) {
            logger.error("Did not find collection with id: " + completeColInfo.getId() + " within domain: " + completeColInfo.getCollectionDomain());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("No index with id: " + completeColInfo.getId() + " on domain: " + completeColInfo.getCollectionDomain() + " to reindex: " + completeColInfo.getId())).build();
        }
        Map<String, FacetType> fieldsFacets = completeColInfo.getCollectionFieldsConfigs().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), ((FieldConfig)entry.getValue()).getFacetType())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (FacetType)e.getValue()));
        completeColInfo.setStatus(CollectionStatus.REINDEXING);
        this.setCompleteCollectionInfo(prettygson.toJson((Object)completeColInfo), gcubeScope);
        boolean status = false;
        try {
            status = InternalProcedures.softReIndex((String)completeColInfo.getId(), fieldsFacets);
        }
        catch (IOException ex) {
            completeColInfo.setStatus(CollectionStatus.ERROR);
            completeColInfo.getCollectionFieldsConfigs().entrySet().parallelStream().forEach(entry -> ((FieldConfig)entry.getValue()).setFacetType(FacetType.NONE));
            this.setCompleteCollectionInfo(prettygson.toJson((Object)completeColInfo), gcubeScope);
            logger.error("Problem while reindexing collection with id: " + completeColInfo.getId(), (Throwable)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Failed to reindex: " + completeColInfo.getId())).build();
        }
        if (status) {
            completeColInfo.setStatus(CollectionStatus.OK);
            this.setCompleteCollectionInfo(prettygson.toJson((Object)completeColInfo), gcubeScope);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)("Created index: " + completeColInfo.getId().toLowerCase())).build();
        }
        completeColInfo.setStatus(CollectionStatus.ERROR);
        completeColInfo.getCollectionFieldsConfigs().entrySet().parallelStream().forEach(entry -> ((FieldConfig)entry.getValue()).setFacetType(FacetType.NONE));
        this.setCompleteCollectionInfo(prettygson.toJson((Object)completeColInfo), gcubeScope);
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)("Failed to reindex: " + completeColInfo.getId())).build();
    }

    @POST
    @Path(value="/insertWithRecID")
    @Consumes(value={"application/x-www-form-urlencoded; charset=UTF-8"})
    public Response insertWithRecID(@QueryParam(value="collectionID") String collectionID, @QueryParam(value="recordID") String recordID, @FormParam(value="recordJSON") String recordJSON, @QueryParam(value="domain") String domain, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        if (recordJSON == null || recordJSON.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No record payload is provided").build();
        }
        if (domain == null || domain.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No domain is specified").build();
        }
        IndexResponse response = recordID == null || recordID.isEmpty() ? IndexAccessor.getFullTextNode().addRecord(collectionID.toLowerCase(), recordJSON) : IndexAccessor.getFullTextNode().addRecord(collectionID.toLowerCase(), recordID, recordJSON);
        String modType = response.isCreated() ? "Created" : "Updated";
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)(modType + " record with id: " + response.getId())).build();
    }

    @POST
    @Path(value="/insertWithoutRecID")
    @Consumes(value={"application/x-www-form-urlencoded; charset=UTF-8"})
    public Response insertWithoutRecID(@QueryParam(value="collectionID") String collectionID, @QueryParam(value="domain") String domain, @FormParam(value="recordJSON") String recordJSON, @HeaderParam(value="gcube-scope") String gcubeScope) {
        return this.insertWithRecID(collectionID.toLowerCase(), null, recordJSON, domain, gcubeScope);
    }

    @DELETE
    @Path(value="/delete/{collectionID}/{recordID}")
    public Response delete(@PathParam(value="collectionID") String collectionID, @PathParam(value="recordID") String recordID, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        DeleteResponse response = (DeleteResponse)IndexAccessor.getFullTextNode().getIndexClient().prepareDelete(collectionID.toLowerCase(), "gcube", recordID).get();
        String responseStr = response.isFound() ? "Deleted document with id " + recordID + " from collection " + collectionID.toLowerCase() : "Could not find document with id " + recordID + " from collection " + collectionID.toLowerCase() + " to delete!";
        return Response.status((Response.Status)Response.Status.OK).entity((Object)(responseStr + " record with id: " + response.getId())).build();
    }

    @DELETE
    @Path(value="/dropCollection/{collectionID}")
    public Response dropCollection(@PathParam(value="collectionID") String collectionID, @HeaderParam(value="gcube-scope") String gcubeScope) {
        DeleteIndexResponse response = (DeleteIndexResponse)IndexAccessor.getFullTextNode().getIndexClient().admin().indices().delete(new DeleteIndexRequest(collectionID.toLowerCase())).actionGet();
        int status = this.deleteCompleteCollectionInfo(collectionID, gcubeScope).getStatus();
        if (!response.isAcknowledged() || status != Response.Status.OK.getStatusCode()) {
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)("Did not delete collection  " + collectionID.toLowerCase())).build();
        }
        return Response.status((int)200).entity((Object)("Deleted collection  " + collectionID.toLowerCase())).build();
    }

    @GET
    @Path(value="/listFulltextEndpoints")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response listFulltextEndpoints(@QueryParam(value="scope") String scope, @HeaderParam(value="gcube-scope") String gcubeScope) {
        return CacheAccessor.getIndexServiceCache().listFulltextEndpoints(scope);
    }

    @GET
    @Path(value="/getCompleteCollectionInfo")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getCompleteCollectionInfo(@QueryParam(value="collectionID") String collectionID, @QueryParam(value="collectionDomain") String collectionDomain, @HeaderParam(value="gcube-scope") String gcubeScope) {
        try {
            Map coll = CacheAccessor.getIndexServiceCache().getCompleteCollectionInfo(collectionID.toLowerCase(), collectionDomain);
            return Response.status((int)200).entity((Object)prettygson.toJson((Object)coll, new /* Unavailable Anonymous Inner Class!! */.getType())).build();
        }
        catch (JsonSyntaxException e) {
            return Response.status((int)500).entity((Object)"Could not parse the serialized CollectionInfo into a List<CollectionInfo>").build();
        }
        catch (IndexNotFoundException ex) {
            return Response.status((int)500).entity((Object)"No index instance available").build();
        }
    }

    @POST
    @Path(value="/setCompleteCollectionInfo")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response setCompleteCollectionInfo(@FormParam(value="cci") String completeCollectionInformation, @HeaderParam(value="gcube-scope") String gcubeScope) {
        CacheAccessor.getIndexServiceCache().clearCompleteCache();
        if (completeCollectionInformation == null || completeCollectionInformation.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No 'completeCollectionInformation' parameter specified").build();
        }
        String collectionID = null;
        try {
            collectionID = ((CollectionInfo)prettygson.fromJson(completeCollectionInformation, new /* Unavailable Anonymous Inner Class!! */.getType())).getId();
        }
        catch (JsonSyntaxException ex) {
            logger.debug("Could not parse a serialized org.gcube.rest.index.common.entities.CollectionInfo");
        }
        if (collectionID == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Specified serialized CollectionInfo class instance is unparseable").build();
        }
        completeCollectionInformation = "{\"cci\":\"" + Toolbox.encode((String)completeCollectionInformation) + "\"}";
        IndexResponse response = IndexAccessor.getFullTextNode().addRecord("gcube-complete-collection-info", collectionID.toLowerCase(), completeCollectionInformation);
        String modType = response.isCreated() ? "Created" : "Updated";
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)(modType + " mappings of collection: " + response.getId())).build();
    }

    @DELETE
    @Path(value="/deleteCompleteCollectionInfo")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deleteCompleteCollectionInfo(@QueryParam(value="collectionID") String collectionID, @HeaderParam(value="gcube-scope") String gcubeScope) {
        CacheAccessor.getIndexServiceCache().clearCompleteCache();
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        DeleteResponse response = (DeleteResponse)IndexAccessor.getFullTextNode().getIndexClient().prepareDelete("gcube-complete-collection-info", "gcube", collectionID.toLowerCase()).get();
        String responseStr = response.isFound() ? "Deleted complete information of collection " + collectionID.toLowerCase() : "Could not find any complete information for collection " + collectionID.toLowerCase() + " to delete!";
        return Response.status((Response.Status)Response.Status.OK).entity((Object)responseStr).build();
    }

    @GET
    @Path(value="/getCollectionFieldsAlias")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getCollectionFieldsAlias(@QueryParam(value="collectionID") String collectionID, @QueryParam(value="collectionDomain") String collectionDomain, @DefaultValue(value="true") @QueryParam(value="fromIndexToView") boolean fromIndexToView, @HeaderParam(value="gcube-scope") String gcubeScope) {
        Map res = CacheAccessor.getIndexServiceCache().getCollectionFieldsAlias(collectionID.toLowerCase(), collectionDomain, fromIndexToView);
        return Response.status((int)200).entity((Object)prettygson.toJson((Object)res)).build();
    }

    @POST
    @Path(value="/setCollectionFieldsAlias")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response setCollectionFieldsAlias(@QueryParam(value="collectionID") String collectionID, @FormParam(value="mappingsJSON") String mappingsJSON, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        if (mappingsJSON == null || mappingsJSON.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No mappings json is provided").build();
        }
        CacheAccessor.getIndexServiceCache().clearCompleteCache();
        Map collInfos = CacheAccessor.getIndexServiceCache().getCompleteCollectionInfo(collectionID, null);
        if (collInfos == null || collInfos.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)("No collection with id " + collectionID + " was found! Please create one first")).build();
        }
        CollectionInfo collInfo = (CollectionInfo)collInfos.get(collectionID);
        Map collFieldAlias = (Map)prettygson.fromJson(mappingsJSON, new /* Unavailable Anonymous Inner Class!! */.getType());
        for (Map.Entry entry : collFieldAlias.entrySet()) {
            FieldConfig fc = (FieldConfig)collInfo.getCollectionFieldsConfigs().get(entry.getKey());
            if (fc == null) {
                collInfo.getCollectionFieldsConfigs().put(entry.getKey(), new FieldConfig((String)entry.getValue()));
                continue;
            }
            ((FieldConfig)collInfo.getCollectionFieldsConfigs().get(entry.getKey())).setFieldNameAlias((String)entry.getValue());
        }
        return this.setCompleteCollectionInfo(prettygson.toJson((Object)collInfo), gcubeScope);
    }

    @DELETE
    @Path(value="/deleteCollectionFieldsAlias")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deleteCollectionFieldsAlias(@QueryParam(value="collectionID") String collectionID, @HeaderParam(value="gcube-scope") String gcubeScope) {
        if (collectionID == null || collectionID.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No collection identifier specified").build();
        }
        CacheAccessor.getIndexServiceCache().clearCompleteCache();
        Map collInfos = CacheAccessor.getIndexServiceCache().getCompleteCollectionInfo(collectionID, null);
        if (collInfos == null || collInfos.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)"No collection fields aliases were found to delete").build();
        }
        CollectionInfo collInfo = (CollectionInfo)collInfos.get(collectionID);
        for (String key : collInfo.getCollectionFieldsConfigs().keySet()) {
            ((FieldConfig)collInfo.getCollectionFieldsConfigs().get(key)).setFieldNameAlias(null);
        }
        return this.setCompleteCollectionInfo(prettygson.toJson((Object)collInfo), gcubeScope);
    }

    @POST
    @Path(value="/search")
    @Consumes(value={"application/x-www-form-urlencoded; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response search(@FormParam(value="query") String queryJson, @QueryParam(value="collectionDomain") String collectionDomain, @HeaderParam(value="gcube-scope") String gcubeScope) {
        Map mapAlias = (Map)prettygson.fromJson((String)this.getCollectionFieldsAlias("", collectionDomain, false, gcubeScope).getEntity(), new /* Unavailable Anonymous Inner Class!! */.getType());
        Map inversedMapAlias = (Map)prettygson.fromJson((String)this.getCollectionFieldsAlias("", collectionDomain, true, gcubeScope).getEntity(), new /* Unavailable Anonymous Inner Class!! */.getType());
        Map flatMapAlias = MapTransformations.flatMap((Map)mapAlias);
        Map flatInversedMapAlias = MapTransformations.flatMap((Map)inversedMapAlias);
        Map collectionInfoMap = (Map)prettygson.fromJson((String)this.getCompleteCollectionInfo("", collectionDomain, gcubeScope).getEntity(), new /* Unavailable Anonymous Inner Class!! */.getType());
        try {
            queryJson = Toolbox.decode((String)queryJson);
        }
        catch (DecoderException ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not access or apply the collection field alias names").build();
        }
        Query query = (Query)prettygson.fromJson(queryJson, Query.class);
        SearchRequestBuilder search_results = null;
        SearchResponse searchScrollResponse = null;
        boolean noneFacetType = true;
        if (query.getSearchMode() == Query.SearchMode.SEARCH) {
            search_results = IndexSearchFunctions.buildSearchRequest((Query)query, (Map)inversedMapAlias, (Map)collectionInfoMap);
            IndexFacet indexFacet = IndexFacetFunctions.buildFacetRequest((Map)collectionInfoMap);
            noneFacetType = indexFacet.isNoneFacetType();
            for (TermsBuilder aggr : indexFacet.getListOfAggregations()) {
                search_results.addAggregation((AbstractAggregationBuilder)aggr);
            }
        } else if (query.getSearchMode() == Query.SearchMode.ID) {
            search_results = IndexSearchFunctions.buildSearchIDRequest((Query)query);
        } else if (query.getSearchMode() == Query.SearchMode.SCROLL) {
            searchScrollResponse = IndexSearchFunctions.buildSearchScrollRequest((Query)query, (Map)inversedMapAlias, (Map)collectionInfoMap);
        }
        logger.debug("===========SUBMITTED QUERY========== " + query.toString());
        Search_Response searchresponse = query.getSearchMode() != Query.SearchMode.SCROLL ? IndexResponseFunctions.buildSearchResponse((SearchResponse)((SearchResponse)search_results.execute().actionGet()), (Map)inversedMapAlias, (Map)flatInversedMapAlias, (boolean)noneFacetType) : IndexResponseFunctions.buildSearchResponse((SearchResponse)searchScrollResponse, (Map)inversedMapAlias, (Map)flatInversedMapAlias, (boolean)noneFacetType);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)prettygson.toJson((Object)searchresponse)).build();
    }
}

