/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service.resources;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProperties {
    private Properties indexProps = new Properties();
    private int maxFragmentCnt;
    private int maxFragmentSize;
    private int noShards;
    private int elasticSearchPort;
    private boolean defaultSameCluster;
    private String scope;
    private String dataDir;
    private int maxResults;
    private boolean clientMode;
    private String hostname;
    private int port;
    private String ckanToken;
    private String ckanScope;
    private String ckanOrganisationNameOrID;
    private String ckanLicenceID;
    private String ckanItemProfileName;
    static final Logger logger = LoggerFactory.getLogger(ServiceProperties.class);

    public ServiceProperties() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.indexProps.load(classLoader.getResourceAsStream("deploy.properties"));
        }
        catch (IOException e) {
            logger.error("Could not find the deploy.properties file to initiate the Index Service!");
        }
        this.maxFragmentCnt = Integer.parseInt(this.indexProps.getProperty("maxFragmentCnt", "5").trim());
        this.maxFragmentSize = Integer.parseInt(this.indexProps.getProperty("maxFragmentSize", "80").trim());
        this.noShards = Integer.parseInt(this.indexProps.getProperty("noShards", "2").trim());
        this.elasticSearchPort = Integer.parseInt(this.indexProps.getProperty("elasticSearchPort", "9200").trim());
        this.defaultSameCluster = Boolean.parseBoolean(this.indexProps.getProperty("defaultSameCluster", "true").trim());
        this.dataDir = this.indexProps.getProperty("dataDir", "./index-data").trim();
        this.clientMode = Boolean.parseBoolean(this.indexProps.getProperty("clientMode", "false").trim());
        this.maxResults = Integer.parseInt(this.indexProps.getProperty("maxResults", "15").trim());
        this.scope = this.indexProps.getProperty("scope");
        this.hostname = this.indexProps.getProperty("hostname");
        if (this.hostname == null) {
            logger.error("Cannot find any hostname within deploy.properties. Are you sure you have defined it properly?");
        }
        this.port = Integer.parseInt(this.indexProps.getProperty("port", "8080"));
        this.ckanToken = this.indexProps.getProperty("ckanToken").trim();
        if (this.ckanToken == null || this.ckanToken.isEmpty()) {
            logger.error("Null or invalid token for CKAN is provided. Publishing to ckan is disabled!");
        }
        this.ckanScope = this.indexProps.getProperty("ckanScope").trim();
        if (this.ckanScope == null || this.ckanScope.isEmpty()) {
            logger.error("Null or invalid scope for CKAN is provided. Publishing to ckan is disabled!");
        }
        this.ckanOrganisationNameOrID = this.indexProps.getProperty("ckanOrganisationNameOrID").trim();
        if (this.ckanOrganisationNameOrID == null || this.ckanOrganisationNameOrID.isEmpty()) {
            logger.error("Null or invalid organisation for CKAN is provided. Publishing to ckan is disabled!");
        }
        this.ckanLicenceID = this.indexProps.getProperty("ckanLicenceID").trim();
        if (this.ckanLicenceID == null || this.ckanLicenceID.isEmpty()) {
            logger.error("Null or invalid licence id for CKAN is provided. Publishing to ckan is disabled!");
        }
        this.ckanItemProfileName = this.indexProps.getProperty("ckanItemProfileName").trim();
        if (this.ckanItemProfileName == null || this.ckanItemProfileName.isEmpty()) {
            logger.error("Null or invalid licence id for CKAN is provided. Publishing to ckan is disabled!");
        }
    }

    public int getMaxFragmentCnt() {
        return this.maxFragmentCnt;
    }

    public int getMaxFragmentSize() {
        return this.maxFragmentSize;
    }

    public int getNoShards() {
        return this.noShards;
    }

    public int getElasticSearchPort() {
        return this.elasticSearchPort;
    }

    public boolean isDefaultSameCluster() {
        return this.defaultSameCluster;
    }

    public String getScope() {
        return this.scope;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public String getCkanToken() {
        return this.ckanToken;
    }

    public String getCkanScope() {
        return this.ckanScope;
    }

    public String getCkanOrganisationNameOrID() {
        return this.ckanOrganisationNameOrID;
    }

    public String getCkanLicenceID() {
        return this.ckanLicenceID;
    }

    public String getCkanItemProfileName() {
        return this.ckanItemProfileName;
    }
}

