/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo.refinement;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Iterator;
import java.util.List;
import org.gcube.indexmanagement.geo.DataWrapper;
import org.gcube.indexmanagement.geo.GeoIndexType;
import org.gcube.indexmanagement.geo.InclusionType;
import org.gcube.indexmanagement.geo.refinement.RefinerInitializationException;
import org.gcube.indexmanagement.geo.shape.Polygon;
import org.gcube.indexmanagement.geo.shape.Rectangle;

public abstract class Refiner {
    protected Envelope query;
    protected Polygon polygon;
    protected GeoIndexType indexType = null;
    protected InclusionType containmentMethod;
    protected boolean not = false;

    public final void init(Polygon polygon, InclusionType containmentMethod, GeoIndexType indexType, boolean not, String[] args) throws RefinerInitializationException {
        this.polygon = polygon;
        Rectangle rect = polygon.getBoundingBox();
        this.query = new Envelope((double)rect.getMinX(), (double)rect.getMaxX(), (double)rect.getMinY(), (double)rect.getMaxY());
        this.containmentMethod = containmentMethod;
        this.indexType = indexType;
        this.not = not;
        this.initialize(args);
    }

    public final int refine(List<DataWrapper> entries) {
        Iterator<DataWrapper> iterator = entries.iterator();
        int removedCount = 0;
        while (iterator.hasNext()) {
            if ((this.not || this.isHit(iterator.next())) && (!this.not || !this.isHit(iterator.next()))) continue;
            iterator.remove();
            ++removedCount;
        }
        return removedCount;
    }

    protected abstract void initialize(String[] var1) throws RefinerInitializationException;

    public abstract boolean isIndexTypeCompatible(GeoIndexType var1);

    public abstract boolean isHit(DataWrapper var1);
}

