package org.gcube.indexmanagement.bdbwrapper;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.je.DatabaseEntry;

/** 
 * This class compares two Integers.
 * It compares its two arguments for order. Returns a negative integer, 
 * zero, or a positive integer as the first argument is less than, 
 * equal to, or greater than the second.
 */
public final class IntegerComparator implements java.util.Comparator<byte[]>, java.io.Serializable
{

	public IntegerComparator(){}
    /**
     * Compares its two arguments for order. Returns a negative integer,
     * zero, or a positive integer as the first argument is less than, equal to, 
     * or greater than the second.
     * @param obj1 - The first Integer to compare
     * @param obj2 - The second Integer to compare
     * @return - a negative integer, zero, or a positive integer as the first
     *           argument is less than, equal to, or greater than the second.
     */
    public int compare(byte[] obj1,
                       byte[] obj2) {
    	
    	DatabaseEntry entry1 = new DatabaseEntry();
        DatabaseEntry entry2 = new DatabaseEntry();
        entry1.setData(obj1);
        entry2.setData(obj2);
        Integer s1 = IntegerBinding.entryToInt(entry1);
        Integer s2 = IntegerBinding.entryToInt(entry2);
        return s1.compareTo(s2);
    }
}