/*
 * IndexStatistics.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:39 $
 * $Id: IndexStatistics.java,v 1.1 2007/12/20 14:37:39 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */

package org.gcube.indexmanagement.common;

import java.util.List;

/**
 * Interface for Index Statistic Generating Wrapper Classes.
 */
public interface IndexStatistics {

    /**
     * Opens the index for the statistics operation.
     * 
     * @param baseIndexDir
     * 			  the base index storage directory
     * @param indexName
     *            name of the index
     * @throws IndexException -
     *             an error opening the index
     */
    public void openIndex(String baseIndexDir, String indexName) throws IndexException;

    /**
     * Updates the index.
     * 
     * @throws IndexException -
     *             an error updating the index
     * 
     * 
     */
    public void updateIndex() throws IndexException;

    /**
     * Creates a statistics file.
     * 
     * @return String CMS ID of the statistics file
     * @throws IndexException -
     *             an error creating statistics
     * 
     */
    public String createStatistics() throws IndexException;

    /**
     * Creates a new statistics file, and merges additional statistics files
     * into it.
     * 
     * @param statisticsFileIDs
     *            <String> of identifiers for the statistics to merge into newly
     *            created statistics
     * @return String CMS ID of the merged statistics file
     * @throws IndexException -
     *             an error creating merged statistics
     * 
     */
    public String createMergedStatistics(List<String> statisticsFileIDs)
            throws IndexException;

    /**
     * Releases reserved resources.
     * 
     * @throws IndexException -
     *             an error closing the IndexStatistics isntance
     * 
     */
    public void close() throws IndexException;
}
