/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common.mergesort;

import java.util.ArrayList;
import org.gcube.indexmanagement.common.mergesort.MergeSortElement;

public class MergeSortPipe {
    private int numberOfworkers;
    private long resultsRetrieved = 0L;
    private long resultsSent = 0L;
    private long getUntil = 0L;
    private ArrayList<ArrayList<MergeSortElement>> queues;
    private boolean[] active;
    private boolean stop = false;

    public MergeSortPipe(int numberOfworkers) {
        int i;
        this.numberOfworkers = numberOfworkers;
        this.active = new boolean[numberOfworkers];
        for (i = 0; i < numberOfworkers; ++i) {
            this.active[i] = true;
        }
        this.queues = new ArrayList(numberOfworkers);
        for (i = 0; i < numberOfworkers; ++i) {
            this.queues.add(new ArrayList());
        }
    }

    public void setInActive(int workerID) {
        this.active[workerID] = false;
    }

    public boolean isActive(int workerID) {
        return this.active[workerID];
    }

    public long getResultsRetrieved() {
        return this.resultsRetrieved;
    }

    public void setResultsRetrieved(long resultsRetrieved) {
        this.resultsRetrieved = resultsRetrieved;
    }

    public long getResultsSent() {
        return this.resultsSent;
    }

    public long getGetUntil() {
        return this.getUntil;
    }

    public void setGetUntil(long getUntil) {
        this.getUntil = getUntil;
    }

    public void add(int workerID, ArrayList<MergeSortElement> elements) {
        this.queues.get(workerID).addAll(elements);
        this.resultsRetrieved += (long)elements.size();
    }

    public MergeSortElement getNext() {
        if (!this.areAllQueuesNonEmpty()) {
            return null;
        }
        double max = -1.0;
        int queueID = -1;
        for (int i = 0; i < this.numberOfworkers; ++i) {
            if (!this.isActive(i) && this.queues.get(i).size() <= 0) continue;
            MergeSortElement element = this.queues.get(i).get(0);
            if (max != -1.0 && !(element.getRank() > max)) continue;
            max = element.getRank();
            queueID = i;
        }
        if (queueID == -1) {
            this.stop = true;
            return null;
        }
        ++this.resultsSent;
        return this.queues.get(queueID).remove(0);
    }

    public void add(int workerID, MergeSortElement element) {
        this.queues.get(workerID).add(element);
        ++this.resultsRetrieved;
    }

    public boolean areAllQueuesNonEmpty() {
        for (int i = 0; i < this.numberOfworkers; ++i) {
            if (this.queues.get(i).size() != 0 || !this.active[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyWorkerLeft() {
        for (boolean isActive : this.active) {
            if (!isActive) continue;
            return true;
        }
        return false;
    }

    public boolean canWorkerPause(int workerID) {
        return this.queues.get(workerID).size() > 0 && this.getUntil != -1L && this.resultsRetrieved >= this.getUntil;
    }

    public boolean canMergeSorterPause() {
        if (this.getUntil != -1L && this.resultsRetrieved >= this.getUntil) {
            return false;
        }
        return this.isAnyWorkerLeft() && !this.areAllQueuesNonEmpty();
    }

    public boolean sendMergerNotification() {
        return !this.canMergeSorterPause();
    }

    public boolean sendWorkersNotification() {
        if (!this.areAllQueuesNonEmpty()) {
            return true;
        }
        return this.getUntil == -1L || this.resultsRetrieved < this.getUntil;
    }

    public void setStop() {
        this.stop = true;
    }

    public boolean isStoped() {
        return this.stop;
    }
}

