/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common.notifications;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.notifications.NotifierRequest;

public class NotifierRequestQueue {
    private static NotifierRequestQueue instance = null;
    private BlockingQueue<NotifierRequest> queue = new LinkedBlockingQueue<NotifierRequest>();
    private ISNotifier notifier;
    private RequestDispatcher dispatcherThread;
    static GCUBELog logger = new GCUBELog(NotifierRequestQueue.class);

    public static synchronized NotifierRequestQueue getInstance() {
        if (instance == null) {
            instance = new NotifierRequestQueue();
        }
        return instance;
    }

    private NotifierRequestQueue() {
        try {
            this.notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve ISNotifier instance!", (Throwable)e);
        }
        this.dispatcherThread = new RequestDispatcher();
        this.dispatcherThread.start();
    }

    public void add(NotifierRequest request) {
        try {
            this.queue.put(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    ISNotifier getNotifier() {
        return this.notifier;
    }

    private class RequestDispatcher
    extends Thread {
        private RequestDispatcher() {
        }

        @Override
        public void run() {
            int numReqs = 0;
            while (true) {
                NotifierRequest r = null;
                try {
                    r = (NotifierRequest)NotifierRequestQueue.this.queue.take();
                    logger.info((Object)("Index notification request dispatcer performing request of type " + r.getClass().getName() + "..."));
                    r.doRequest();
                    logger.info((Object)"Request dispatched.");
                    logger.info((Object)("Index notification request dispatcher has served " + ++numReqs + " requests."));
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

