/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo.ranking;

import java.util.Comparator;
import java.util.List;

public class Sorter {
    public static <T> void quickSort(List<T> objects, Comparator<T> comparator) {
        Sorter.quickSort(objects, 0, objects.size() - 1, 0, objects.size(), comparator);
    }

    public static <T> void partialQuickSort(List<T> objects, int start, int end, boolean isSeriallySorted, Comparator<T> comparator) {
        if (isSeriallySorted) {
            Sorter.quickSort(objects, start, objects.size() - 1, start, end, comparator);
        } else {
            Sorter.quickSort(objects, 0, objects.size() - 1, start, end, comparator);
        }
    }

    private static <T> void quickSort(List<T> objects, int left, int right, int start, int end, Comparator<T> comparator) {
        if (right > left) {
            int pivotIndex = Sorter.selectPivot(objects, left, right);
            int alteredPivotIndex = Sorter.partition(objects, left, right, pivotIndex, comparator);
            if (alteredPivotIndex > start) {
                Sorter.quickSort(objects, left, alteredPivotIndex - 1, start, end, comparator);
            }
            if (alteredPivotIndex < end) {
                Sorter.quickSort(objects, alteredPivotIndex + 1, right, start, end, comparator);
            }
        }
    }

    private static int selectPivot(List objects, int left, int right) {
        return left;
    }

    private static <T> int partition(List<T> objects, int left, int right, int pivotIndex, Comparator<T> comparator) {
        T temp = objects.get(right);
        T pivot = objects.get(pivotIndex);
        objects.set(right, pivot);
        objects.set(pivotIndex, temp);
        int currentPivotIndex = left;
        for (int i = left; i < right; ++i) {
            if (comparator.compare(objects.get(i), pivot) > 0) continue;
            temp = objects.get(currentPivotIndex);
            objects.set(currentPivotIndex, objects.get(i));
            objects.set(i, temp);
            ++currentPivotIndex;
        }
        temp = objects.get(currentPivotIndex);
        objects.set(currentPivotIndex, pivot);
        objects.set(right, temp);
        return currentPivotIndex;
    }
}

