package org.gcube.indexmanagement.bdbwrapper;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.gcube.common.core.utils.logging.GCUBELog;

import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.DatabaseEntry;

/**
 * This class represents a date whose serialization is formed according to a custom
 * date format.
 * 
 * @author Spyros Boutsis, NKUA
 * @author Vasilis Verroios, NKUA
 */
public class CustomDate extends Date implements java.io.Serializable {
	
	/** logger */
	static GCUBELog logger = new GCUBELog(CustomDate.class);
	
	/** The custom formatter */
	private SimpleDateFormat format;
	private static final String separator = ":";
	
	/**
	 * Class constructor
	 * @param date the date represented by this object
	 * @param format the custom date format
	 */
	CustomDate(String sDate, SimpleDateFormat format) throws Exception {
		super(format.parse(sDate).getTime());
		this.format = format;
	}
	
	/*
	 * (non-Javadoc)
	 * @see java.util.Date#toString()
	 */
	public String toString() {
		return format.format(this);
	}
	
	/**
	 * Encodes the given CustomDate object to an array of bytes 
	 * @return the array of bytes
	 */
	public byte[] getBytes(){
		String s = this.toString().length() + separator + this.toString() + format.toPattern();
		DatabaseEntry entry = new DatabaseEntry();
		StringBinding.stringToEntry(s, entry);
		return entry.getData();		
	}
	
	/**
	 * Reconstructs an CustomDate object from an array of bytes, produced using the getBytes method on a CustomDate object 
	 * @param data the array of bytes
	 * @return the new CustomDate object
	 */
	public static CustomDate toCustomDate(byte[] data){
		CustomDate cd = null;
		try{
		DatabaseEntry entry = new DatabaseEntry();
		entry.setData(data);
		String s = StringBinding.entryToString(entry);
		int i = Integer.parseInt(s.substring(0, s.indexOf(separator)));
		SimpleDateFormat sdf = new SimpleDateFormat(s.substring(s.indexOf(separator)+i+1)); 
		cd = new CustomDate(s.substring(s.indexOf(separator)+1, s.indexOf(separator)+i+1),sdf);
		}catch(Exception e){
			logger.error("could not convert to Custom Date", e);
		}
		return cd;
	}
}
