/**
 * FastLanguageIdPlugin.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:39 $
 * $Id: DummyLangidPlugin.java,v 1.1 2007/12/20 14:37:39 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */

package org.gcube.indexmanagement.common.linguistics.languageidplugin;

import org.gcube.indexmanagement.common.IndexException;

/**
 * The dummy class for lanugae identification.
 * This class does not recognize any language.
 */
public class DummyLangidPlugin implements LanguageIdPlugin {

    /**
     * Empty constructor.
     */
    public DummyLangidPlugin() {
    }

    /**
     * Method that initialises the implementation of the language id
     * @param configFile      The config file needed by the identify language
     * @throws                IndexException when the language_identifier can not be created
     */
    public void init(String configFile) throws IndexException {
    }

    /**
     * Detects the language in the document
     * @param  document     The document
     * @return              The ISO string of the language. The ISO string can be
     *                      converted by the language class to the "ISO enum"
     *                      The string "nolang" is returned if no language can be identified.
     *                      The string "not_enough_data" is returned if the document string is
     *                      too short.
     * @throws              IndexException in case of a failure.
     */
    public String detectLanguage(String document) throws IndexException {
        // Result is of the form
        // 3 15 fr#iso-8859-1:50
        //  1 3 10 it#iso-8859-1:46
        //  1 3 4 nb#iso-8859-1:42
        //  1 3 8 en#iso-8859-1:108
        //  2 not_enough_data
        //  12 nolang
        return "nolang";
    }


    /**
     * Detects the language in the document and
     * returns the full string of from detection algorithm.
     * @param  document     The document
     * @return              The ISO string of the
     *                      language. nolang is always returned.
     * @throws              IndexException in case of a failure.
     */
    public String detectLanguageFull(String document) throws IndexException {
        return "nolang";
    }
}
