package org.gcube.indexmanagement.featureindexlibrary.commons;

import java.util.ArrayList;

/**
 * Normalizes results
 * 
 * @author UoA
 */
public class NormalizeResults {
	/**
	 * Normalizes results
	 * 
	 * @param results The results to normalize
	 * @param indexName The name of the index
	 */
	public static void normalize(ArrayList<RankedResultElement> results,String indexName){
		float norm=results.get(results.size()-1).getRank();
		if(norm==0) norm=Float.MAX_VALUE;
		for(int i=0;i<results.size();i+=1){
			results.get(i).setRank(1-((results.get(i).getRank())/norm));
			results.get(i).setIndexName(indexName);
		}
	}
}
