/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureVectorElement;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;

public class FileBufferWriter {
    private static Logger log = Logger.getLogger(FileBufferWriter.class);
    private String file = null;
    private FileOutputStream fos = null;
    private BufferedOutputStream bos = null;
    private DataOutputStream dos = null;
    private int idlength = 0;
    private int vectorlength = 0;

    public FileBufferWriter(String file, VAFileParams params) {
        this.file = file;
        this.idlength = params.getIDLength();
        this.vectorlength = params.getVectorLength();
    }

    private void write(String id) throws Exception {
        char[] idA = id.toCharArray();
        for (int i = 0; i < idA.length; ++i) {
            this.dos.writeChar(idA[i]);
        }
    }

    private void write(float[] vector) throws Exception {
        for (int i = 0; i < vector.length; ++i) {
            this.dos.writeFloat(vector[i]);
        }
    }

    public void openForUpdate() throws Exception {
        try {
            this.fos = new FileOutputStream(this.file, true);
            this.bos = new BufferedOutputStream(this.fos);
            this.dos = new DataOutputStream(this.bos);
        }
        catch (Exception e) {
            log.error((Object)"Could not open writer. Throwing Exception", (Throwable)e);
            throw new Exception("Could not open writer");
        }
    }

    public boolean addElement(FeatureVectorElement elem) throws Exception {
        try {
            if (elem.getId().length() != this.idlength || elem.getVector().length != this.vectorlength) {
                return false;
            }
            this.write(elem.getId());
            this.write(elem.getVector());
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Could not add vector element. Throwing Exception", (Throwable)e);
            throw new Exception("Could not add vector element");
        }
    }

    public void close() throws Exception {
        try {
            this.dos.flush();
            if (this.fos != null) {
                this.fos.close();
            }
            if (this.dos != null) {
                this.dos.close();
            }
            if (this.bos != null) {
                this.bos.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not close writer. throwing Exception", (Throwable)e);
            throw new Exception("Could not close writer");
        }
    }
}

