package org.gcube.indexmanagement.featureindexlibrary.commons;

import java.util.ArrayList;
import java.util.Collections;


/**
 * Element holding top k results
 * 
 * @author UoA
 */
public class LookupBuffer {
	/**
	 * The buffer holding the results
	 */
	private ArrayList<RankedResultElement> buffer=null;
	/**
	 * The number of results to hold
	 */
	private int k=0;
	/**
	 * THe results have been normalized
	 */
	private boolean normalized=false;
	
	/**
	 * Creates a new instance
	 * 
	 * @param k The number of results
	 */
	public LookupBuffer(int k){
		this.buffer=new ArrayList<RankedResultElement>(k);
		this.k=k;
	}
	
	/**
	 * Retrieves the results
	 * 
	 * @param indexName The index name
	 * @return The results
	 */
	public ArrayList<RankedResultElement> getResults(String indexName){
		if(!this.normalized){
			NormalizeResults.normalize(this.buffer,indexName);
			this.normalized=true;
		}
		return this.buffer;
	}
	
	/**
	 * processes a new element 
	 * 
	 * @param element the element to check for addition
	 * @return The k-th max distance
	 */
	public float process(RankedResultElement element){
		if(this.buffer.size()<this.k){
			this.addToBuffer(element);
			return Float.MAX_VALUE;
		}
		else{
			this.replaceInBuffer(element);
			return this.buffer.get(this.buffer.size()-1).getRank();
		}
	}
	
	/**
	 * Adds the element in teh buffer 
	 * 
	 * @param element The element
	 */
	private void addToBuffer(RankedResultElement element){
		this.buffer.add(element);
		Collections.sort(this.buffer,new SortAscRankedResultComparator());
	}

	/**
	 * Adds an element in the buffre replacing an existing one
	 * 
	 * @param element the element
	 */
	private void replaceInBuffer(RankedResultElement element){
		this.addToBuffer(element);
		buffer.remove(this.buffer.size()-1);
	}
}
