/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.vafile.algo;

import org.apache.log4j.Logger;

public class ComputeBoundsL {
    private static Logger log = Logger.getLogger(ComputeBoundsL.class);
    private float[][] partitionPoints = null;
    private int buckets = 0;
    private float[][] dLow = null;

    public ComputeBoundsL(float[][] partitionPoints, int buckets) {
        this.partitionPoints = partitionPoints;
        this.buckets = buckets;
        this.dLow = new float[partitionPoints.length][buckets - 1];
    }

    public float getLowerBound(byte[] bitString) {
        float bound = 0.0f;
        for (int i = 0; i < bitString.length; ++i) {
            bound += this.dLow[i][bitString[i]];
        }
        return bound;
    }

    public void preCompute(float[] vector) throws Exception {
        try {
            for (int j = 0; j < this.partitionPoints.length; ++j) {
                for (int i = 0; i < this.buckets - 1; ++i) {
                    this.dLow[j][i] = vector[j] < this.getFloor(j, i) ? (this.getFloor(j, i) - vector[j]) * (this.getFloor(j, i) - vector[j]) : (vector[j] > this.getCeiling(j, i) ? (vector[j] - this.getCeiling(j, i)) * (vector[j] - this.getCeiling(j, i)) : 0.0f);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not compute Dbounds for query. Throwing Exception", (Throwable)e);
            throw new Exception("Could not compute Dbounds for query");
        }
    }

    private float getFloor(int dim, int bitString) {
        return this.partitionPoints[dim][bitString];
    }

    private float getCeiling(int dim, int bitString) {
        return this.partitionPoints[dim][bitString + 1];
    }
}

