/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.vafile.algo;

import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;

public class ApproximationGenerator {
    private static Logger log = Logger.getLogger(ApproximationGenerator.class);

    public static byte[] generate(float[][] partitionPoints, float[] vector, VAFileParams params) throws Exception {
        try {
            if (params.getVectorLength() != vector.length) {
                throw new Exception("Dimentions don't match");
            }
            byte[] bitString = new byte[params.getVectorLength()];
            for (int i = 0; i < vector.length; ++i) {
                bitString[i] = ApproximationGenerator.getDimentionBitString(partitionPoints, vector[i], i);
            }
            return bitString;
        }
        catch (Exception e) {
            log.error((Object)"Could not generate approximation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not generate approximation");
        }
    }

    private static byte getDimentionBitString(float[][] partitionPoints, float vectorPoint, int dim) throws Exception {
        if (vectorPoint < partitionPoints[dim][0]) {
            return 0;
        }
        if (partitionPoints[dim][partitionPoints[dim].length - 1] < vectorPoint) {
            return (byte)(partitionPoints[dim].length - 2);
        }
        for (int i = 0; i < partitionPoints[dim].length - 1; ++i) {
            if (!(partitionPoints[dim][i] <= vectorPoint) || !(vectorPoint <= partitionPoints[dim][i + 1])) continue;
            return (byte)i;
        }
        throw new Exception("Cound not compute bit string");
    }
}

