/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.bdbwrapper;

import com.sleepycat.bind.tuple.FloatBinding;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationStatus;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.bdbwrapper.BDBGcqlQueryContainer;
import org.gcube.indexmanagement.bdbwrapper.BDBWrapper;
import org.gcube.indexmanagement.bdbwrapper.CustomDate;
import org.gcube.indexmanagement.common.ForwardIndexField;
import org.gcube.indexmanagement.common.ForwardIndexType;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexType;
import org.gcube.indexmanagement.common.XMLTokenReplacer;
import org.gcube.indexmanagement.common.dupelimination.ResultsIdentifierSet;

public class BDBQueryExecutor
extends Thread {
    static GCUBELog logger = new GCUBELog(BDBQueryExecutor.class);
    private HashMap<String, Integer> keyTypes;
    private ForwardIndexType[] dbT;
    private Database[] db;
    private Database dbMain;
    private Comparator[] comparator;
    private LinkedHashMap<String, String> projections;
    private boolean distinct = false;
    private ArrayList<?> queries = null;
    private RecordWriter<GenericRecord> rsWriter;
    static final String delimiter = " AND ";
    static final String orderBy = " ORDERBY ";
    static final String prefix = "GET ";
    static final String gt = ">";
    static final String lt = "<";
    static final String eq = "=";
    static final String wild = "*";
    static final String termReplacer = "$";
    static final String termContainer = "\"";
    private static final long RSTIMEOUT = 10L;

    public BDBQueryExecutor(HashMap<String, Integer> keyTypes, ForwardIndexType[] dbT, Database[] db, Database dbMain, Comparator[] comparator, ArrayList<?> queries, RecordWriter<GenericRecord> rsWriter, LinkedHashMap<String, String> projections, boolean distinct) {
        this.keyTypes = keyTypes;
        this.dbT = dbT;
        this.db = db;
        this.dbMain = dbMain;
        this.comparator = comparator;
        this.rsWriter = rsWriter;
        this.queries = queries;
        this.projections = projections;
        this.distinct = distinct;
    }

    @Override
    public void run() {
        long resultsRetrieved = 0L;
        ResultsIdentifierSet resultsIdSet = new ResultsIdentifierSet();
        for (Object query : this.queries) {
            ArrayList<String> orderedList;
            LinkedHashMap<String, ArrayList<String>> keyNames;
            block72: {
                logger.debug((Object)" >>> process Query");
                logger.debug((Object)("Query received: " + query));
                keyNames = new LinkedHashMap<String, ArrayList<String>>();
                orderedList = new ArrayList<String>();
                try {
                    if (query instanceof ArrayList) {
                        if (!this.parseQuery((ArrayList)query, keyNames, orderedList)) {
                            continue;
                        }
                        break block72;
                    }
                    if (query instanceof String) {
                        if (!this.parseStringQuery((String)query, keyNames, orderedList)) {
                            continue;
                        }
                        break block72;
                    }
                    throw new Exception("Unsupported type of queries");
                }
                catch (Exception e) {
                    logger.error((Object)"exception while parsing: ", (Throwable)e);
                    return;
                }
            }
            String ordered = null;
            if (orderedList.size() > 0) {
                ordered = orderedList.get(0);
            }
            try {
                ArrayList ids = new ArrayList(keyNames.size());
                ArrayList pairs = new ArrayList(keyNames.size());
                Iterator<String> iter = keyNames.keySet().iterator();
                Integer order = null;
                int j = 0;
                while (iter.hasNext()) {
                    DatabaseEntry greater = null;
                    DatabaseEntry lower = null;
                    boolean gequal = false;
                    boolean lequal = false;
                    String keyName = iter.next();
                    if (ordered != null && ordered.equals(keyName)) {
                        order = j;
                    }
                    Integer pos = this.keyTypes.get(keyName);
                    ArrayList<String> args = keyNames.get(keyName);
                    int index = 0;
                    while (true) {
                        if (args.get(index).equals(gt)) {
                            greater = new DatabaseEntry();
                            if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.DATE) {
                                greater.setData(BDBWrapper.convertToDate(args.get(index + 2), this.dbT[pos].getKeyField().getDataTypeFormat()).getBytes());
                            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.FLOAT) {
                                FloatBinding.floatToEntry((float)BDBWrapper.convertToFloat(args.get(index + 2)), (DatabaseEntry)greater);
                            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.INT) {
                                IntegerBinding.intToEntry((int)BDBWrapper.convertToInt(args.get(index + 2)), (DatabaseEntry)greater);
                            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.STRING) {
                                StringBinding.stringToEntry((String)args.get(index + 2), (DatabaseEntry)greater);
                            }
                            gequal = args.get(index + 1).equals("1");
                        } else if (args.get(index).equals(lt)) {
                            lower = new DatabaseEntry();
                            if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.DATE) {
                                lower.setData(BDBWrapper.convertToDate(args.get(index + 2), this.dbT[pos].getKeyField().getDataTypeFormat()).getBytes());
                            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.FLOAT) {
                                FloatBinding.floatToEntry((float)BDBWrapper.convertToFloat(args.get(index + 2)), (DatabaseEntry)lower);
                            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.INT) {
                                IntegerBinding.intToEntry((int)BDBWrapper.convertToInt(args.get(index + 2)), (DatabaseEntry)lower);
                            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.STRING) {
                                StringBinding.stringToEntry((String)args.get(index + 2), (DatabaseEntry)lower);
                            }
                            lequal = args.get(index + 1).equals("1");
                        } else if (args.get(index).equals(eq)) {
                            if (!args.get(index + 1).equals("1")) break;
                            greater = new DatabaseEntry();
                            if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.DATE) {
                                greater.setData(BDBWrapper.convertToDate(args.get(index + 2), this.dbT[pos].getKeyField().getDataTypeFormat()).getBytes());
                            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.FLOAT) {
                                FloatBinding.floatToEntry((float)BDBWrapper.convertToFloat(args.get(index + 2)), (DatabaseEntry)greater);
                            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.INT) {
                                IntegerBinding.intToEntry((int)BDBWrapper.convertToInt(args.get(index + 2)), (DatabaseEntry)greater);
                            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.STRING) {
                                StringBinding.stringToEntry((String)args.get(index + 2), (DatabaseEntry)greater);
                            }
                            lower = greater;
                            gequal = true;
                            lequal = true;
                            break;
                        }
                        if (index == 3 || args.size() != 6) break;
                        index = 3;
                    }
                    DatabaseEntry keyValue = new DatabaseEntry();
                    DatabaseEntry bindKey = new DatabaseEntry();
                    Object key = null;
                    OperationStatus opSt = OperationStatus.SUCCESS;
                    Cursor cursor = this.db[pos].openCursor(null, null);
                    try {
                        if (greater != null) {
                            keyValue.setData(greater.getData());
                            opSt = cursor.getSearchKeyRange(keyValue, bindKey, null);
                            if (!gequal && this.comparator[pos].compare(keyValue.getData(), greater.getData()) == 0) {
                                opSt = cursor.getNextNoDup(keyValue, bindKey, null);
                            }
                        } else {
                            opSt = cursor.getNext(keyValue, bindKey, null);
                        }
                        HashSet<String> set = new HashSet<String>();
                        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                        while (opSt == OperationStatus.SUCCESS && (lower == null || this.comparator[pos].compare(keyValue.getData(), lower.getData()) <= 0 && (this.comparator[pos].compare(keyValue.getData(), lower.getData()) != 0 || lequal))) {
                            String id = StringBinding.entryToString((DatabaseEntry)bindKey);
                            if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.DATE) {
                                key = CustomDate.toCustomDate(keyValue.getData());
                            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.FLOAT) {
                                key = Float.valueOf(FloatBinding.entryToFloat((DatabaseEntry)keyValue));
                            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.INT) {
                                key = IntegerBinding.entryToInt((DatabaseEntry)keyValue);
                            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.STRING) {
                                key = StringBinding.entryToString((DatabaseEntry)keyValue);
                            }
                            String resolvedKey = XMLTokenReplacer.XMLResolve(key.toString());
                            String keyString = (String)map.get(id);
                            if (keyString == null) {
                                keyString = "";
                            }
                            keyString = keyString + "<key><keyname>" + keyName + "</keyname><keyvalue>" + resolvedKey + "</keyvalue></key>";
                            map.put(id, keyString);
                            set.add(id);
                            logger.debug((Object)("Found key/id:" + resolvedKey + "/" + id + " for keyname:" + keyName));
                            opSt = cursor.getNext(keyValue, bindKey, null);
                        }
                        ids.add(set);
                        pairs.add(map);
                        cursor.close();
                    }
                    catch (Exception e) {
                        cursor.close();
                        throw e;
                    }
                    ++j;
                }
                Collections.sort(ids, new Comparator<HashSet<String>>(){

                    @Override
                    public int compare(HashSet<String> a, HashSet<String> b) {
                        int sdif = a.size() - b.size();
                        return sdif;
                    }
                });
                HashSet intersection = (HashSet)ids.get(0);
                for (int i = 1; i < ids.size(); ++i) {
                    intersection.retainAll((Collection)ids.get(i));
                }
                int next = 0;
                boolean firstStep = true;
                if (ordered != null) {
                    next = order;
                }
                LinkedHashMap masterMap = null;
                for (int i = 0; i < pairs.size(); ++i) {
                    if (firstStep) {
                        masterMap = (LinkedHashMap)pairs.get(next);
                        Iterator<Object> valueIter = masterMap.keySet().iterator();
                        while (valueIter.hasNext()) {
                            if (intersection.contains(valueIter.next())) continue;
                            valueIter.remove();
                        }
                        next = next != 0 ? 0 : 1;
                        firstStep = false;
                        continue;
                    }
                    for (String id : intersection) {
                        if (!((LinkedHashMap)pairs.get(next)).containsKey(id)) continue;
                        String keyString = (String)((LinkedHashMap)pairs.get(next)).get(id);
                        String keyString2 = (String)masterMap.get(id);
                        keyString2 = keyString2 + keyString;
                        masterMap.put(id, keyString2);
                        logger.debug((Object)("Added key:" + keyString + " for id:" + id));
                    }
                    if (ordered == null || ++next != order) continue;
                    ++next;
                }
                Iterator valueIter = masterMap.keySet().iterator();
                while (valueIter.hasNext()) {
                    DatabaseEntry idEntry = new DatabaseEntry();
                    DatabaseEntry dataEntry = new DatabaseEntry();
                    String id = (String)valueIter.next();
                    String key = (String)masterMap.get(id);
                    StringBinding.stringToEntry((String)id, (DatabaseEntry)idEntry);
                    if (this.dbMain.get(null, idEntry, dataEntry, null) == OperationStatus.NOTFOUND) {
                        logger.error((Object)"Reference to actual data not found. Index is corrupted!");
                        throw new Exception("Reference to actual data not found. Index is corrupted!");
                    }
                    String data = BDBWrapper.extractValueFromEntry(StringBinding.entryToString((DatabaseEntry)dataEntry));
                    String stringXML = XMLTokenReplacer.XMLResolve(data);
                    HashMap<String, String> fieldsPresentable = BDBWrapper.getPresentationFieldsFromXML(stringXML);
                    if (this.rsWriter.getStatus() != IBuffer.Status.Open) {
                        this.rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + resultsRetrieved));
                        if (this.rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            this.rsWriter.close();
                        }
                        return;
                    }
                    boolean canSend = false;
                    GenericRecord rec = null;
                    if (this.distinct) {
                        rec = this.createRecordFromDistinctProjections(fieldsPresentable, resultsIdSet);
                        if (rec != null) {
                            canSend = true;
                        }
                    } else {
                        rec = this.createRecordFromProjections(fieldsPresentable);
                        canSend = resultsIdSet.canSend(fieldsPresentable.get("gDocCollectionLang"), fieldsPresentable.get("ObjectID"));
                    }
                    if (!canSend) continue;
                    if (IndexType.sendIndication(++resultsRetrieved)) {
                        this.rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumber", "" + resultsRetrieved));
                    }
                    while (!this.rsWriter.put((Record)rec, 10L, TimeUnit.SECONDS)) {
                        if (this.rsWriter.getStatus() == IBuffer.Status.Open) continue;
                        this.rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + resultsRetrieved));
                        if (this.rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            this.rsWriter.close();
                        }
                        return;
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)" *** exception in process Query: ", (Throwable)e);
            }
            logger.debug((Object)" <<< process Query");
        }
        try {
            this.rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + resultsRetrieved));
            if (this.rsWriter.getStatus() != IBuffer.Status.Dispose) {
                this.rsWriter.close();
            }
        }
        catch (Exception e1) {
            logger.error((Object)"could not close RSWriter", (Throwable)e1);
        }
        logger.debug((Object)" <<< processed All Queries");
    }

    private GenericRecord createRecordFromDistinctProjections(HashMap<String, String> fieldsPresentable, ResultsIdentifierSet resultsIdSet) {
        GenericRecord rec = new GenericRecord();
        ArrayList<StringField> fields = new ArrayList<StringField>();
        StringBuilder concatProjections = new StringBuilder();
        for (Map.Entry<String, String> current : this.projections.entrySet()) {
            String proj = current.getValue();
            String value = fieldsPresentable.get(proj);
            if (value == null) {
                value = "";
            }
            concatProjections.append(value.trim()).append("-");
            fields.add(new StringField(value));
        }
        if (resultsIdSet.canSend("DISTINCT", concatProjections.toString())) {
            rec.setFields(fields.toArray(new Field[fields.size()]));
            return rec;
        }
        return null;
    }

    private GenericRecord createRecordFromProjections(HashMap<String, String> fieldsPresentable) {
        GenericRecord rec = new GenericRecord();
        ArrayList<StringField> fields = new ArrayList<StringField>();
        String id = fieldsPresentable.get("ObjectID");
        if (id == null) {
            id = "NoDocID";
        }
        fields.add(new StringField(id));
        logger.trace((Object)("returning doc with ID: " + id));
        for (Map.Entry<String, String> current : this.projections.entrySet()) {
            String proj = current.getValue();
            String value = fieldsPresentable.get(proj);
            if (value == null) {
                value = "";
            }
            fields.add(new StringField(value));
        }
        rec.setFields(fields.toArray(new Field[fields.size()]));
        return rec;
    }

    private boolean parseQuery(ArrayList<BDBGcqlQueryContainer.SingleTerm> query, LinkedHashMap<String, ArrayList<String>> keyNames, ArrayList<String> orderedList) throws Exception {
        for (BDBGcqlQueryContainer.SingleTerm condition : query) {
            String term;
            String bound;
            String equals;
            String type;
            ArrayList<String> args;
            String keyName;
            logger.trace((Object)("Condition - Field: " + condition.getField() + ", Relation: " + condition.getRelation() + ", Value: " + condition.getValue()));
            if (condition.getRelation().startsWith(gt)) {
                keyName = condition.getField();
                if (this.keyTypes.get(keyName) == null) {
                    throw new IndexException("keyName: " + keyName + " was not declared when the constructor was called. " + "There is no index for this keyName");
                }
                args = keyNames.get(keyName);
                if (args == null) {
                    args = new ArrayList(3);
                }
                type = gt;
                if (!condition.getRelation().equals(gt)) {
                    equals = "1";
                    bound = condition.getValue();
                    if (bound.equals(wild)) {
                        throw new Exception("for a non equality condition the wildcard is used ");
                    }
                    term = bound;
                } else {
                    equals = "0";
                    bound = condition.getValue();
                    if (bound.equals(wild)) {
                        throw new Exception("for a non equality condition the wildcard is used: ");
                    }
                    term = bound;
                }
                try {
                    if (!this.checkAndStore(keyName, args, type, equals, term)) {
                        logger.info((Object)("Contradicting new bound for keyName: " + keyName + ", Type, equals, term: " + type + ", " + equals + ", " + term));
                        return false;
                    }
                }
                catch (Exception e) {
                    logger.fatal((Object)"Something that was not predicted happened: ", (Throwable)e);
                    throw new Exception("Something that was not predicted happened: ", e);
                }
                logger.debug((Object)("Stored condition for keyName: " + keyName + ", term: " + term));
                keyNames.put(keyName, args);
                continue;
            }
            if (condition.getRelation().startsWith(lt)) {
                keyName = condition.getField();
                if (this.keyTypes.get(keyName) == null) {
                    throw new IndexException("keyName: " + keyName + " was not declared when the constructor was called. " + "There is no index for this keyName");
                }
                args = keyNames.get(keyName);
                if (args == null) {
                    args = new ArrayList(3);
                }
                type = lt;
                if (!condition.getRelation().equals(lt)) {
                    equals = "1";
                    bound = condition.getValue();
                    if (bound.equals(wild)) {
                        throw new Exception("for a non equality condition the wildcard is used");
                    }
                    term = bound;
                } else {
                    equals = "0";
                    bound = condition.getValue();
                    if (bound.equals(wild)) {
                        throw new Exception("for a non equality condition the wildcard is used");
                    }
                    term = bound;
                }
                try {
                    if (!this.checkAndStore(keyName, args, type, equals, term)) {
                        logger.info((Object)("Contradicting new bound for keyName: " + keyName + ", Type, equals, term: " + type + ", " + equals + ", " + term));
                        return false;
                    }
                }
                catch (Exception e) {
                    logger.fatal((Object)"Something that was not predicted happened: ", (Throwable)e);
                    throw new Exception("Something that was not predicted happened: ", e);
                }
                logger.debug((Object)("Stored condition for keyName: " + keyName + ", term: " + term));
                keyNames.put(keyName, args);
                continue;
            }
            if (!condition.getRelation().equals(eq)) continue;
            keyName = condition.getField();
            if (this.keyTypes.get(keyName) == null) {
                throw new IndexException("keyName: " + keyName + " was not declared when the constructor was called. " + "There is no index for this keyName");
            }
            args = keyNames.get(keyName);
            if (args == null) {
                args = new ArrayList(3);
            }
            type = eq;
            bound = condition.getValue();
            if (bound.equals(wild)) {
                equals = "0";
                term = bound;
            } else {
                equals = "1";
                term = bound;
            }
            try {
                if (!this.checkAndStore(keyName, args, type, equals, term)) {
                    logger.info((Object)("Contradicting new bound for keyName: " + keyName + ", Type, equals, term: " + type + ", " + equals + ", " + term));
                    return false;
                }
            }
            catch (Exception e) {
                logger.fatal((Object)"Something that was not predicted happened: ", (Throwable)e);
                throw new Exception("Something that was not predicted happened: ", e);
            }
            logger.debug((Object)("Stored condition for keyName: " + keyName + ", term: " + term));
            keyNames.put(keyName, args);
        }
        return true;
    }

    private boolean parseStringQuery(String query, LinkedHashMap<String, ArrayList<String>> keyNames, ArrayList<String> orderedList) throws Exception {
        Vector<String> conditions = new Vector<String>();
        StringBuffer q = new StringBuffer(query.trim());
        String ordered = null;
        if (q.indexOf(prefix) != 0) {
            throw new Exception("Prefix:GET  is missing - Invalid query expression: " + query);
        }
        q.delete(0, q.indexOf(prefix) + prefix.length());
        if (BDBWrapper.numberOfChars(q.toString(), termContainer) % 2 == 1) {
            throw new Exception("Unmatched \" character - Invalid query expression: " + query);
        }
        int current = q.indexOf(termContainer);
        ArrayList<String> terms = new ArrayList<String>();
        while (current != -1) {
            int current2 = q.indexOf(termContainer, current + 1);
            terms.add(q.substring(current + 1, current2));
            q.delete(current, current2 + 1);
            q.insert(current, termReplacer);
            current = q.indexOf(termContainer);
        }
        logger.debug((Object)("Query after replacing terms: " + q));
        if (q.indexOf(orderBy) != -1) {
            ordered = q.substring(q.indexOf(orderBy) + orderBy.length()).trim();
            orderedList.add(ordered);
            q.delete(q.indexOf(orderBy), q.length());
            if (this.keyTypes.get(ordered) == null) {
                throw new IndexException("keyName: " + ordered + " was not declared when the constructor was called. " + "There is no index for this keyName");
            }
        }
        logger.debug((Object)("Query after removing orderby: " + q));
        while (q.indexOf(delimiter) != -1) {
            conditions.add(q.substring(0, q.indexOf(delimiter)).trim());
            q.delete(0, q.indexOf(delimiter) + delimiter.length());
        }
        conditions.add(q.toString().trim());
        for (int i = 0; i < conditions.size(); ++i) {
            String term;
            String bound;
            String equals;
            String type;
            ArrayList<String> args;
            String keyName;
            if (((String)conditions.get(i)).indexOf(gt) == -1 && ((String)conditions.get(i)).indexOf(lt) == -1 && ((String)conditions.get(i)).indexOf(eq) == -1) {
                throw new Exception("Invalid query expression: " + query);
            }
            if (((String)conditions.get(i)).indexOf(gt) != -1) {
                keyName = ((String)conditions.get(i)).substring(0, ((String)conditions.get(i)).indexOf(gt)).trim();
                if (this.keyTypes.get(keyName) == null) {
                    throw new IndexException("keyName: " + keyName + " was not declared when the constructor was called. " + "There is no index for this keyName");
                }
                args = keyNames.get(keyName);
                if (args == null) {
                    args = new ArrayList(3);
                }
                type = gt;
                if (((String)conditions.get(i)).substring(((String)conditions.get(i)).indexOf(gt) + gt.length(), ((String)conditions.get(i)).indexOf(gt) + gt.length() + eq.length()).equals(eq)) {
                    equals = "1";
                    bound = ((String)conditions.get(i)).substring(((String)conditions.get(i)).indexOf(gt) + gt.length() + eq.length()).trim();
                    if (bound.equals(wild)) {
                        throw new Exception("for a non equality condition the wildcard is used: " + (String)conditions.get(i));
                    }
                    term = (String)terms.remove(0);
                } else {
                    equals = "0";
                    bound = ((String)conditions.get(i)).substring(((String)conditions.get(i)).indexOf(gt) + gt.length()).trim();
                    if (bound.equals(wild)) {
                        throw new Exception("for a non equality condition the wildcard is used: " + (String)conditions.get(i));
                    }
                    term = (String)terms.remove(0);
                }
                try {
                    if (!this.checkAndStore(keyName, args, type, equals, term)) {
                        logger.info((Object)("Contradicting new bound for keyName: " + keyName + ", Type, equals, term: " + type + ", " + equals + ", " + term));
                        return false;
                    }
                }
                catch (Exception e) {
                    logger.fatal((Object)"Something that was not predicted happened: ", (Throwable)e);
                    throw new Exception("Something that was not predicted happened: ", e);
                }
                logger.debug((Object)("Stored condition for keyName: " + keyName + ", term: " + term));
                keyNames.put(keyName, args);
                continue;
            }
            if (((String)conditions.get(i)).indexOf(lt) != -1) {
                keyName = ((String)conditions.get(i)).substring(0, ((String)conditions.get(i)).indexOf(lt)).trim();
                if (this.keyTypes.get(keyName) == null) {
                    throw new IndexException("keyName: " + keyName + " was not declared when the constructor was called. " + "There is no index for this keyName");
                }
                args = keyNames.get(keyName);
                if (args == null) {
                    args = new ArrayList(3);
                }
                type = lt;
                if (((String)conditions.get(i)).substring(((String)conditions.get(i)).indexOf(lt) + lt.length(), ((String)conditions.get(i)).indexOf(lt) + lt.length() + eq.length()).equals(eq)) {
                    equals = "1";
                    bound = ((String)conditions.get(i)).substring(((String)conditions.get(i)).indexOf(lt) + lt.length() + eq.length()).trim();
                    if (bound.equals(wild)) {
                        throw new Exception("for a non equality condition the wildcard is used: " + (String)conditions.get(i));
                    }
                    term = (String)terms.remove(0);
                } else {
                    equals = "0";
                    bound = ((String)conditions.get(i)).substring(((String)conditions.get(i)).indexOf(lt) + lt.length()).trim();
                    if (bound.equals(wild)) {
                        throw new Exception("for a non equality condition the wildcard is used: " + (String)conditions.get(i));
                    }
                    term = (String)terms.remove(0);
                }
                try {
                    if (!this.checkAndStore(keyName, args, type, equals, term)) {
                        logger.info((Object)("Contradicting new bound for keyName: " + keyName + ", Type, equals, term: " + type + ", " + equals + ", " + term));
                        return false;
                    }
                }
                catch (Exception e) {
                    logger.fatal((Object)"Something that was not predicted happened: ", (Throwable)e);
                    throw new Exception("Something that was not predicted happened: ", e);
                }
                logger.debug((Object)("Stored condition for keyName: " + keyName + ", term: " + term));
                keyNames.put(keyName, args);
                continue;
            }
            if (((String)conditions.get(i)).indexOf(eq) == -1) continue;
            keyName = ((String)conditions.get(i)).substring(0, ((String)conditions.get(i)).indexOf(eq)).trim();
            if (this.keyTypes.get(keyName) == null) {
                throw new IndexException("keyName: " + keyName + " was not declared when the constructor was called. " + "There is no index for this keyName");
            }
            args = keyNames.get(keyName);
            if (args == null) {
                args = new ArrayList(3);
            }
            type = eq;
            bound = ((String)conditions.get(i)).substring(((String)conditions.get(i)).indexOf(eq) + eq.length()).trim();
            if (bound.equals(wild)) {
                equals = "0";
                term = bound;
            } else {
                equals = "1";
                term = (String)terms.remove(0);
            }
            try {
                if (!this.checkAndStore(keyName, args, type, equals, term)) {
                    logger.info((Object)("Contradicting new bound for keyName: " + keyName + ", Type, equals, term: " + type + ", " + equals + ", " + term));
                    return false;
                }
            }
            catch (Exception e) {
                logger.fatal((Object)"Something that was not predicted happened: ", (Throwable)e);
                throw new Exception("Something that was not predicted happened: ", e);
            }
            logger.debug((Object)("Stored condition for keyName: " + keyName + ", term: " + term));
            keyNames.put(keyName, args);
        }
        return true;
    }

    private boolean checkAndStore(String keyName, ArrayList<String> args, String type, String equals, String term) throws Exception {
        if (term.equals(wild)) {
            logger.trace((Object)"New bound is a wildcard");
            if (args.size() == 0) {
                args.add(type);
                args.add(equals);
                args.add(term);
            }
            return true;
        }
        if (args.size() == 3 && args.get(2).equals(wild)) {
            args.clear();
            args.add(type);
            args.add(equals);
            args.add(term);
            return true;
        }
        if (args.size() == 0) {
            args.add(type);
            args.add(equals);
            args.add(term);
            return true;
        }
        if (args.size() == 3) {
            String prevType = args.get(0);
            String prevEquals = args.get(1);
            String prevTerm = args.get(2);
            int comp = this.compare(keyName, prevTerm, term);
            if (type.equals(prevType) && comp == 0) {
                if (type.equals(eq)) {
                    return true;
                }
                if (equals.equals("0")) {
                    args.remove(1);
                    args.add(1, "0");
                }
                return true;
            }
            if (prevType.equals(gt) && type.equals(gt)) {
                if (comp < 0) {
                    args.clear();
                    args.add(type);
                    args.add(equals);
                    args.add(term);
                    return true;
                }
                if (comp > 0) {
                    return true;
                }
            } else if (prevType.equals(lt) && type.equals(lt)) {
                if (comp > 0) {
                    args.clear();
                    args.add(type);
                    args.add(equals);
                    args.add(term);
                    return true;
                }
                if (comp < 0) {
                    return true;
                }
            } else {
                if (prevType.equals(gt) && type.equals(lt)) {
                    if (comp > 0) {
                        return false;
                    }
                    args.add(type);
                    args.add(equals);
                    args.add(term);
                    return true;
                }
                if (prevType.equals(lt) && type.equals(gt)) {
                    if (comp < 0) {
                        return false;
                    }
                    args.add(type);
                    args.add(equals);
                    args.add(term);
                    return true;
                }
                if (prevType.equals(eq) && type.equals(gt)) {
                    return comp >= 0;
                }
                if (prevType.equals(eq) && type.equals(lt)) {
                    return comp <= 0;
                }
                if (prevType.equals(eq) && type.equals(eq)) {
                    if (comp != 0) {
                        return false;
                    }
                    logger.error((Object)"The case with same types and comp == 0 is examined before. This point should not have reached. Possible Bug. ");
                    throw new Exception("The case with same types and comp == 0 is examined before. This point should not have reached. Possible Bug. ");
                }
                if (prevType.equals(gt) && type.equals(eq)) {
                    if (comp > 0) {
                        return false;
                    }
                    args.clear();
                    args.add(type);
                    args.add(equals);
                    args.add(term);
                    return true;
                }
                if (prevType.equals(lt) && type.equals(eq)) {
                    if (comp < 0) {
                        return false;
                    }
                    args.clear();
                    args.add(type);
                    args.add(equals);
                    args.add(term);
                    return true;
                }
            }
        } else if (args.size() == 6) {
            int gtIndex = 0;
            int ltIndex = 3;
            if (args.get(0).equals(lt)) {
                gtIndex = 3;
                ltIndex = 0;
            }
            String gtEquals = args.get(gtIndex + 1);
            String gtTerm = args.get(gtIndex + 2);
            String ltEquals = args.get(ltIndex + 1);
            String ltTerm = args.get(ltIndex + 2);
            int gtComp = this.compare(keyName, gtTerm, term);
            int ltComp = this.compare(keyName, ltTerm, term);
            if (type.equals(eq)) {
                if (gtComp > 0) {
                    return false;
                }
                if (ltComp < 0) {
                    return false;
                }
                args.clear();
                args.add(type);
                args.add(equals);
                args.add(term);
                return true;
            }
            if (type.equals(lt)) {
                if (ltComp < 0) {
                    return true;
                }
                if (ltComp == 0 && ltEquals.equals("0")) {
                    return true;
                }
                if (gtComp > 0) {
                    return false;
                }
                args.remove(ltIndex);
                args.remove(ltIndex);
                args.remove(ltIndex);
                args.add(ltIndex, term);
                args.add(ltIndex, equals);
                args.add(ltIndex, type);
                return true;
            }
            if (type.equals(gt)) {
                if (gtComp > 0) {
                    return true;
                }
                if (gtComp == 0 && gtEquals.equals("0")) {
                    return true;
                }
                if (ltComp < 0) {
                    return false;
                }
                args.remove(gtIndex);
                args.remove(gtIndex);
                args.remove(gtIndex);
                args.add(gtIndex, term);
                args.add(gtIndex, equals);
                args.add(gtIndex, type);
                return true;
            }
        } else {
            throw new Exception("Bug. args size = " + args.size());
        }
        logger.warn((Object)"Normally this point should not have been reached");
        return true;
    }

    private int compare(String keyName, String term1, String term2) throws Exception {
        int pos = this.keyTypes.get(keyName);
        if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.DATE) {
            CustomDate t1 = BDBWrapper.convertToDate(term1, this.dbT[pos].getKeyField().getDataTypeFormat());
            CustomDate t2 = BDBWrapper.convertToDate(term2, this.dbT[pos].getKeyField().getDataTypeFormat());
            return t1.compareTo(t2);
        }
        if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.FLOAT) {
            Float t1 = new Float(term1);
            Float t2 = new Float(term2);
            return t1.compareTo(t2);
        }
        if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.INT) {
            Integer t1 = new Integer(term1);
            Integer t2 = new Integer(term2);
            return t1.compareTo(t2);
        }
        if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.STRING) {
            return term1.compareTo(term2);
        }
        throw new Exception("Unsupported type: " + (Object)((Object)this.dbT[pos].getKeyField().getDataType()) + ", for keyName: " + keyName);
    }

    private static int compareTestLocally(String keyName, String term1, String term2) throws Exception {
        return term1.compareTo(term2);
    }

    static boolean parseQueryTestLocally(ArrayList<BDBGcqlQueryContainer.SingleTerm> query, LinkedHashMap<String, ArrayList<String>> keyNames, ArrayList<String> orderedList) throws Exception {
        for (BDBGcqlQueryContainer.SingleTerm condition : query) {
            String term;
            String bound;
            String equals;
            String type;
            ArrayList<String> args;
            String keyName;
            if (condition.getRelation().startsWith(gt)) {
                keyName = condition.getField();
                args = keyNames.get(keyName);
                if (args == null) {
                    args = new ArrayList(3);
                }
                type = gt;
                if (!condition.getRelation().equals(gt)) {
                    equals = "1";
                    bound = condition.getValue();
                    if (bound.equals(wild)) {
                        throw new Exception("for a non equality condition the wildcard is used ");
                    }
                    term = bound;
                } else {
                    equals = "0";
                    bound = condition.getValue();
                    if (bound.equals(wild)) {
                        throw new Exception("for a non equality condition the wildcard is used: ");
                    }
                    term = bound;
                }
                try {
                    if (!BDBQueryExecutor.checkAndStoreTestLocally(keyName, args, type, equals, term)) {
                        logger.info((Object)("Contradicting new bound for keyName: " + keyName + ", Type, equals, term: " + type + ", " + equals + ", " + term));
                        return false;
                    }
                }
                catch (Exception e) {
                    logger.fatal((Object)"Something that was not predicted happened: ", (Throwable)e);
                    throw new Exception("Something that was not predicted happened: ", e);
                }
                logger.debug((Object)("Stored condition for keyName: " + keyName + ", term: " + term));
                keyNames.put(keyName, args);
                continue;
            }
            if (condition.getRelation().startsWith(lt)) {
                keyName = condition.getField();
                args = keyNames.get(keyName);
                if (args == null) {
                    args = new ArrayList(3);
                }
                type = lt;
                if (!condition.getRelation().equals(lt)) {
                    equals = "1";
                    bound = condition.getValue();
                    if (bound.equals(wild)) {
                        throw new Exception("for a non equality condition the wildcard is used");
                    }
                    term = bound;
                } else {
                    equals = "0";
                    bound = condition.getValue();
                    if (bound.equals(wild)) {
                        throw new Exception("for a non equality condition the wildcard is used");
                    }
                    term = bound;
                }
                try {
                    if (!BDBQueryExecutor.checkAndStoreTestLocally(keyName, args, type, equals, term)) {
                        logger.info((Object)("Contradicting new bound for keyName: " + keyName + ", Type, equals, term: " + type + ", " + equals + ", " + term));
                        return false;
                    }
                }
                catch (Exception e) {
                    logger.fatal((Object)"Something that was not predicted happened: ", (Throwable)e);
                    throw new Exception("Something that was not predicted happened: ", e);
                }
                logger.debug((Object)("Stored condition for keyName: " + keyName + ", term: " + term));
                keyNames.put(keyName, args);
                continue;
            }
            if (!condition.getRelation().equals(eq)) continue;
            keyName = condition.getField();
            args = keyNames.get(keyName);
            if (args == null) {
                args = new ArrayList(3);
            }
            type = eq;
            bound = condition.getValue();
            if (bound.equals(wild)) {
                equals = "0";
                term = bound;
            } else {
                equals = "1";
                term = bound;
            }
            try {
                if (!BDBQueryExecutor.checkAndStoreTestLocally(keyName, args, type, equals, term)) {
                    logger.info((Object)("Contradicting new bound for keyName: " + keyName + ", Type, equals, term: " + type + ", " + equals + ", " + term));
                    return false;
                }
            }
            catch (Exception e) {
                logger.fatal((Object)"Something that was not predicted happened: ", (Throwable)e);
                throw new Exception("Something that was not predicted happened: ", e);
            }
            logger.debug((Object)("Stored condition for keyName: " + keyName + ", term: " + term));
            keyNames.put(keyName, args);
        }
        return true;
    }

    private static boolean checkAndStoreTestLocally(String keyName, ArrayList<String> args, String type, String equals, String term) throws Exception {
        if (term.equals(wild)) {
            return true;
        }
        if (args.size() == 3 && args.get(2).equals(wild)) {
            args.clear();
            args.add(type);
            args.add(equals);
            args.add(term);
            return true;
        }
        if (args.size() == 0) {
            args.add(type);
            args.add(equals);
            args.add(term);
            return true;
        }
        if (args.size() == 3) {
            String prevType = args.get(0);
            String prevEquals = args.get(1);
            String prevTerm = args.get(2);
            int comp = BDBQueryExecutor.compareTestLocally(keyName, prevTerm, term);
            if (type.equals(prevType) && comp == 0) {
                if (type.equals(eq)) {
                    return true;
                }
                if (equals.equals("0")) {
                    args.remove(1);
                    args.add(1, "0");
                }
                return true;
            }
            if (prevType.equals(gt) && type.equals(gt)) {
                if (comp < 0) {
                    args.clear();
                    args.add(type);
                    args.add(equals);
                    args.add(term);
                    return true;
                }
                if (comp > 0) {
                    return true;
                }
            } else if (prevType.equals(lt) && type.equals(lt)) {
                if (comp > 0) {
                    args.clear();
                    args.add(type);
                    args.add(equals);
                    args.add(term);
                    return true;
                }
                if (comp < 0) {
                    return true;
                }
            } else {
                if (prevType.equals(gt) && type.equals(lt)) {
                    if (comp > 0) {
                        return false;
                    }
                    args.add(type);
                    args.add(equals);
                    args.add(term);
                    return true;
                }
                if (prevType.equals(lt) && type.equals(gt)) {
                    if (comp < 0) {
                        return false;
                    }
                    args.add(type);
                    args.add(equals);
                    args.add(term);
                    return true;
                }
                if (prevType.equals(eq) && type.equals(gt)) {
                    return comp >= 0;
                }
                if (prevType.equals(eq) && type.equals(lt)) {
                    return comp <= 0;
                }
                if (prevType.equals(eq) && type.equals(eq)) {
                    if (comp != 0) {
                        return false;
                    }
                    logger.error((Object)"The case with same types and comp == 0 is examined before. This point should not have reached. Possible Bug. ");
                    throw new Exception("The case with same types and comp == 0 is examined before. This point should not have reached. Possible Bug. ");
                }
                if (prevType.equals(gt) && type.equals(eq)) {
                    if (comp > 0) {
                        return false;
                    }
                    args.clear();
                    args.add(type);
                    args.add(equals);
                    args.add(term);
                    return true;
                }
                if (prevType.equals(lt) && type.equals(eq)) {
                    if (comp < 0) {
                        return false;
                    }
                    args.clear();
                    args.add(type);
                    args.add(equals);
                    args.add(term);
                    return true;
                }
            }
        } else if (args.size() == 6) {
            int gtIndex = 0;
            int ltIndex = 3;
            if (args.get(0).equals(lt)) {
                gtIndex = 3;
                ltIndex = 0;
            }
            String gtEquals = args.get(gtIndex + 1);
            String gtTerm = args.get(gtIndex + 2);
            String ltEquals = args.get(ltIndex + 1);
            String ltTerm = args.get(ltIndex + 2);
            int gtComp = BDBQueryExecutor.compareTestLocally(keyName, gtTerm, term);
            int ltComp = BDBQueryExecutor.compareTestLocally(keyName, ltTerm, term);
            if (type.equals(eq)) {
                if (gtComp > 0) {
                    return false;
                }
                if (ltComp < 0) {
                    return false;
                }
                args.clear();
                args.add(type);
                args.add(equals);
                args.add(term);
                return true;
            }
            if (type.equals(lt)) {
                if (ltComp < 0) {
                    return true;
                }
                if (ltComp == 0 && ltEquals.equals("0")) {
                    return true;
                }
                if (gtComp > 0) {
                    return false;
                }
                args.remove(ltIndex);
                args.remove(ltIndex);
                args.remove(ltIndex);
                args.add(ltIndex, term);
                args.add(ltIndex, equals);
                args.add(ltIndex, type);
                return true;
            }
            if (type.equals(gt)) {
                if (gtComp > 0) {
                    return true;
                }
                if (gtComp == 0 && gtEquals.equals("0")) {
                    return true;
                }
                if (ltComp < 0) {
                    return false;
                }
                args.remove(gtIndex);
                args.remove(gtIndex);
                args.remove(gtIndex);
                args.add(gtIndex, term);
                args.add(gtIndex, equals);
                args.add(gtIndex, type);
                return true;
            }
        } else {
            throw new Exception("Bug. args size = " + args.size());
        }
        logger.warn((Object)"Normally this point should not have been reached");
        return true;
    }
}

