package org.gcube.indexmanagement.common;

import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Class used to represent the ResultSet property element in FullTextIndex query
 * results.
 * 
 * @see org.diligentproject.searchservice.searchlibrary.resultset.elements.PropertyElementBase
 */
public class PropertyElementLookup extends PropertyElementBase {

    /** The ResultSet property type */
    public static String propertyType = "LookupProperty";

    /** The number of hits from the query */
    private int nrOfHits = 0;

    /**
     * Empty constructor
     */
    public PropertyElementLookup() {
        super();
    }

    /**
     * Constructor.
     * 
     * @param nrOfHits -
     *            the total number of hits for the query.
     * @throws Exception -
     *             from the super class.
     */
    public PropertyElementLookup(int nrOfHits) throws Exception {
        super();
        this.nrOfHits = nrOfHits;
        setType(PropertyElementLookup.propertyType);
    }

    /**
     * {@inheritDoc}
     */
    public void fromXML(String element) throws Exception {
        try {
            String regex = "^<lookup\\s+numberofHits=\"(\\d*)\"\\s*/>$";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(element.trim());
            nrOfHits = Integer.parseInt(m.group(1));
        } catch (Exception e) {
            throw new Exception("invalid argument (xml)", e);
        }
    }

    /**
     * {@inheritDoc}
     */
    public String toXML() {
        return "<lookup numberofHits=\"" + nrOfHits + "\"/>";
    }

}
