package org.gcube.indexmanagement.featureindexlibrary.vafile.algo;

import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;

/**
 * Generates approximation string
 * 
 * @author UoA
 */
public class ApproximationGenerator {
	/**
	 * Logger used by the class
	 */
	private static Logger log = Logger.getLogger(ApproximationGenerator.class);
	
//	public static int [][]dimCount=null;
	
	/**
	 * Generate approximation
	 * 
	 * @param partitionPoints The partition points
	 * @param vector The vector
	 * @param params The VAFile paramters
	 * @return Teh approximation
	 * @throws Exception An error
	 */
	public static byte []generate(float [][]partitionPoints,float []vector,VAFileParams params) throws Exception{
		try{
//			if(dimCount==null){
//				dimCount=new int[params.getVectorLength()][params.getBuckets()-1];
//			}
			if(params.getVectorLength()!=vector.length){
				throw new Exception("Dimentions don't match");
			}
			byte []bitString=new byte[params.getVectorLength()];
			for(int i=0;i<vector.length;i+=1){
				bitString[i]=getDimentionBitString(partitionPoints,vector[i],i);
			}
			return bitString;
		}catch(Exception e){
			log.error("Could not generate approximation. Throwing Exception",e);
			throw new Exception("Could not generate approximation");
		}
	}
	
	/**
	 * Retrieves the bit string in the given dimention
	 * 
	 * @param partitionPoints The partition points
	 * @param vectorPoint The point in the vector in that dimention
	 * @param dim The dimention
	 * @return The approximation
	 * @throws Exception An error
	 */
	private static byte getDimentionBitString(float [][]partitionPoints,float vectorPoint,int dim) throws Exception{
		if(vectorPoint<partitionPoints[dim][0]){
//		dimCount[dim][0]+=1;
			return (byte)0;
		}
		if(partitionPoints[dim][partitionPoints[dim].length-1]<vectorPoint){
//		dimCount[dim][dimCount.length-1]+=1;
			return (byte)(partitionPoints[dim].length-2);
		}
		for(int i=0;i<partitionPoints[dim].length-1;i+=1){
			if(partitionPoints[dim][i]<=vectorPoint && vectorPoint<=partitionPoints[dim][i+1]){
//			dimCount[dim][i]+=1;
				return (byte)i;
			}
		}
		throw new Exception("Cound not compute bit string");
	}
}
