/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class DecompressingInputStream
extends FilterInputStream {
    private int previous = -1;
    private int codeCount = 0;
    private int codeSize;
    private int maxCodes;
    private int remainingPart = 0;
    private int remainingSize = 0;
    private int maxAllowedCodes = 524288;
    private HashMap<Integer, Integer> codes = new HashMap();
    private int decompressedBytesIdx;
    private byte[] decompressedBytes;
    private int previousMark;
    private int codeCountMark;
    private int codeSizeMark;
    private int remainingPartMark;
    private int remainingSizeMark;
    private int decompressedBytesIdxMark;
    private byte[] decompressedBytesMark;

    public DecompressingInputStream(InputStream in) {
        super(in);
        while (this.codeCount < 256) {
            this.codes.put(this.codeCount, this.codeCount);
            ++this.codeCount;
        }
        this.decompressedBytes = new byte[0];
        this.decompressedBytesIdx = 0;
        this.setCodeSize(9);
    }

    @Override
    public int read() throws IOException {
        byte[] array = this.readDecompressed(1);
        if (array == null) {
            return -1;
        }
        return array[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        byte[] array = this.readDecompressed(len);
        if (array == null) {
            return -1;
        }
        System.arraycopy(array, 0, b, off, array.length);
        return array.length;
    }

    @Override
    public void mark(int i) {
        if (this.markSupported()) {
            this.previousMark = this.previous;
            this.codeCountMark = this.codeCount;
            this.codeSizeMark = this.codeSize;
            this.remainingPartMark = this.remainingPart;
            this.remainingSizeMark = this.remainingSize;
            this.decompressedBytesMark = new byte[this.decompressedBytes.length];
            System.arraycopy(this.decompressedBytes, 0, this.decompressedBytesMark, 0, this.decompressedBytes.length);
            this.decompressedBytesIdxMark = this.decompressedBytesIdx;
            super.mark(i);
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.markSupported()) {
            super.reset();
            this.previous = this.previousMark;
            this.codeCount = this.codeCountMark;
            this.codeSize = this.codeSizeMark;
            this.remainingPart = this.remainingPartMark;
            this.remainingSize = this.remainingSizeMark;
            this.decompressedBytes = new byte[this.decompressedBytesMark.length];
            System.arraycopy(this.decompressedBytesMark, 0, this.decompressedBytes, 0, this.decompressedBytesMark.length);
            this.decompressedBytesIdx = this.decompressedBytesIdxMark;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.skipDecompressed(n);
    }

    private byte[] readDecompressed(int len) throws IOException {
        if (this.previous == -1) {
            this.previous = this.readCode();
            if (this.previous == -1) {
                return null;
            }
            this.decompressedBytes = new byte[]{(byte)this.previous};
        }
        byte[] returnArray = new byte[len];
        int lenToCopy = Math.min(len, this.decompressedBytes.length - this.decompressedBytesIdx);
        System.arraycopy(this.decompressedBytes, this.decompressedBytesIdx, returnArray, 0, lenToCopy);
        this.decompressedBytesIdx += lenToCopy;
        for (int copiedLen = lenToCopy; copiedLen < len; copiedLen += lenToCopy) {
            int current = this.readCode();
            if (current == -1) {
                if (copiedLen > 0) {
                    byte[] lastPart = new byte[copiedLen];
                    System.arraycopy(returnArray, 0, lastPart, 0, copiedLen);
                    return lastPart;
                }
                return null;
            }
            if (this.codeCount < this.maxAllowedCodes) {
                int newCode = current == this.codeCount ? (this.previous << 8) + (this.expandCode(this.previous, this.codes)[0] & 0xFF) : (this.previous << 8) + (this.expandCode(current, this.codes)[0] & 0xFF);
                this.codes.put(this.codeCount++, newCode);
                if (this.codeCount == this.maxCodes && this.codeCount < this.maxAllowedCodes) {
                    this.setCodeSize(this.codeSize + 1);
                }
            }
            this.previous = current;
            this.decompressedBytes = this.expandCode(this.previous, this.codes);
            this.decompressedBytesIdx = 0;
            lenToCopy = Math.min(len - copiedLen, this.decompressedBytes.length - this.decompressedBytesIdx);
            System.arraycopy(this.decompressedBytes, 0, returnArray, copiedLen, lenToCopy);
            this.decompressedBytesIdx += lenToCopy;
        }
        return returnArray;
    }

    private long skipDecompressed(long len) throws IOException {
        long skippedLen;
        if (this.previous == -1) {
            this.previous = this.readCode();
            if (this.previous == -1) {
                return 0L;
            }
        }
        int lenToSkip = new Long(Math.min(len, new Integer(this.decompressedBytes.length - this.decompressedBytesIdx).longValue())).intValue();
        this.decompressedBytesIdx += lenToSkip;
        for (skippedLen = (long)lenToSkip; skippedLen < len; skippedLen += (long)lenToSkip) {
            int current = this.readCode();
            if (current == -1) {
                return skippedLen;
            }
            if (this.codeCount < this.maxAllowedCodes) {
                int newCode = current == this.codeCount ? (this.previous << 8) + (this.expandCode(this.previous, this.codes)[0] & 0xFF) : (this.previous << 8) + (this.expandCode(current, this.codes)[0] & 0xFF);
                this.codes.put(this.codeCount++, newCode);
                if (this.codeCount == this.maxCodes && this.codeCount < this.maxAllowedCodes) {
                    this.setCodeSize(this.codeSize + 1);
                }
            }
            this.previous = current;
            this.decompressedBytes = this.expandCode(this.previous, this.codes);
            this.decompressedBytesIdx = 0;
            lenToSkip = new Long(Math.min(len - skippedLen, new Integer(this.decompressedBytes.length - this.decompressedBytesIdx).longValue())).intValue();
            this.decompressedBytesIdx += lenToSkip;
        }
        return skippedLen;
    }

    private byte[] expandCode(int code, HashMap<Integer, Integer> codes) {
        int value = codes.get(code);
        if (code < 256) {
            return new byte[]{(byte)value};
        }
        byte lastValue = (byte)(value & 0xFF);
        int prevCode = value >> 8;
        byte[] prevValues = this.expandCode(prevCode, codes);
        byte[] returnValues = new byte[prevValues.length + 1];
        System.arraycopy(prevValues, 0, returnValues, 0, prevValues.length);
        returnValues[returnValues.length - 1] = lastValue;
        return returnValues;
    }

    private int readCode() throws IOException {
        while (this.remainingSize < this.codeSize) {
            int inByte = this.in.read();
            if (inByte == -1) {
                return -1;
            }
            this.remainingPart = this.remainingPart << 8 | inByte;
            this.remainingSize += 8;
        }
        int code = this.remainingPart >> this.remainingSize - this.codeSize;
        this.remainingPart &= (1 << this.remainingSize - this.codeSize) - 1;
        this.remainingSize -= this.codeSize;
        return code;
    }

    private void setCodeSize(int newSize) {
        this.codeSize = newSize;
        this.maxCodes = 1 << this.codeSize;
    }
}

