/*
 * IndexServiceConst.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:39 $
 * $Id: IndexServiceConst.java,v 1.1 2007/12/20 14:37:39 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */

package org.gcube.indexmanagement.common;

import org.globus.wsrf.config.ContainerConfig;

/**
 * Commonly used constants.
 * <p>
 * The constants contain the location of local files. Once the Storage layer in
 * the Diligent project is up and running, this class will be absolute.
 *
 */
public interface IndexServiceConst {

    /** Internal only */
//    String base_dir = ContainerConfig.getBaseDirectory();

    /** The main base dir */
//    String main_dir = base_dir
//            + "/etc/org.gcube.indexmanagement.fulltextindexmanagement/indexServiceFiles/";

    /** The updater base dir */
//    String updater_dir = base_dir
//            + "/etc/org.gcube.indexmanagement.fulltextindexupdater/indexServiceFiles/";
    
    /** The lookup base dir */
 //   String local_dir = base_dir
 //           + "/etc/org.gcube.indexmanagement.fulltextindexlookup/indexServiceFiles/";

    /** Local path where indexes are stored */
//    public static final String INDEX_DIRECTORY = main_dir + "index/";

    /** Local path where updater indices are stored */
//    public static final String UPDATER_INDEX_DIRECTORY = updater_dir + "index/";

    /** Local path where lookup index replications are stored */
//    public static final String LOCAL_INDEX_DIRECTORY = local_dir + "index/";

    /** Local path where statistics are stored */
//    public static final String STATISTICS_FILE_PATH = main_dir + "httpd-docs/statistics/";

    /**
     * The part of the URI that comes after the hostname, including port number.
     * The complete path includes a hostname, and cannot be a const.
     */
    public static final String STATISTICS_URL_EXTENSION = ":8000/statistics/";

    /** Path of the XML docs containing currently defined document types */
//    public static final String INDEX_TYPE_DIRECTORY = main_dir
//            + "XML/documentTypes/";
    
    /** Path of the XML docs containing currently defined document types
     *  for updaters
     */
//    public static final String UPDATER_INDEX_TYPE_DIRECTORY = updater_dir + "XML/documentTypes/";

    /** Path of the XML docs containing currently defined document types
     *  for lookup replications
     */
//    public static final String LOCAL_DOCUMENT_TYPE_DIRECTORY = local_dir + "XML/documentTypes/";

	/**
	 *  The name of the collection storing delta files, index state info
	 *  and index statistics
	 */
	public static final String INDEX_COLLECTION_NAME = "Index Delta Internal";

}
