/**
 * 
 */
package org.gcube.indexmanagement.common.notifications;

import java.util.LinkedList;
import java.util.List;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.informationsystem.notifier.ISNotifier.TopicData;
import org.gcube.common.core.scope.GCUBEScope;

/**
 * @author Spyros Boutsis, NKUA
 *
 */
public class IsRegisteredNotificationRequest extends NotifierRequest {

	private List<TopicData> topicList;
	private IsRegisteredCallback callback;
	
	public IsRegisteredNotificationRequest(List<TopicData> topicList, GCUBEServiceContext sctx, GCUBEScope scope, IsRegisteredCallback callback) {
		super(null, sctx, scope);
		this.topicList = new LinkedList<TopicData>(topicList);
		this.callback = callback;
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.indexmanagement.common.notifications.NotifierRequest#doRequest()
	 */
	@Override
	public void doRequest() {
		ISNotifier notifier = NotifierRequestQueue.getInstance().getNotifier();
		
		boolean bRetry = true;
		while (bRetry) {
			try {
				boolean[] result = notifier.isTopicRegistered(this.sctx, this.scope, this.topicList);
				this.callback.isRegisteredResponse(result);
				bRetry = false;
			} catch (Exception e) {
				logger.warn("Exception while querying for topic registration completion topics. Retrying...", e);
				try {
					Thread.sleep(5000);
				} catch (InterruptedException ex) { }
			}
		}
	}

}
