/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FIEnums;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.ApproximationFileEntry;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.VectorFileEntry;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.VectorFileRandomAccess;

public class IOHelper {
    private static Logger log = Logger.getLogger(VectorFileRandomAccess.class);
    private int idlength = -1;
    private int vectorlength = -1;

    public void setIDLength(int idlength) throws Exception {
        this.idlength = idlength;
    }

    public void setVectorLength(int vectorlength) throws Exception {
        this.vectorlength = vectorlength;
    }

    private void writeID(String toWrite, RandomAccessFile rand) throws Exception {
        rand.writeChars(toWrite);
    }

    private String readID(RandomAccessFile rand) throws Exception {
        char[] buf = new char[this.idlength];
        for (int i = 0; i < this.idlength; ++i) {
            buf[i] = rand.readChar();
        }
        return new String(buf);
    }

    private String readID(DataInputStream in) throws Exception {
        char[] buf = new char[this.idlength];
        for (int i = 0; i < this.idlength; ++i) {
            buf[i] = in.readChar();
        }
        return new String(buf);
    }

    private void writeString(String toWrite, RandomAccessFile rand) throws Exception {
        rand.writeInt(toWrite.toCharArray().length);
        rand.writeChars(toWrite);
    }

    private String readString(RandomAccessFile rand) throws Exception {
        int count = rand.readInt();
        char[] buf = new char[count];
        for (int i = 0; i < count; ++i) {
            buf[i] = rand.readChar();
        }
        return new String(buf);
    }

    private void writeVector(float[] toWrite, RandomAccessFile rand) throws Exception {
        for (int i = 0; i < this.vectorlength; ++i) {
            rand.writeFloat(toWrite[i]);
        }
    }

    private float[] readVector(RandomAccessFile rand) throws Exception {
        float[] vector = new float[this.vectorlength];
        for (int i = 0; i < this.vectorlength; ++i) {
            vector[i] = rand.readFloat();
        }
        return vector;
    }

    private float[] readVector(DataInputStream in) throws Exception {
        float[] vector = new float[this.vectorlength];
        for (int i = 0; i < this.vectorlength; ++i) {
            vector[i] = in.readFloat();
        }
        return vector;
    }

    private void writeFlag(boolean active, RandomAccessFile rand) throws Exception {
        rand.writeBoolean(active);
    }

    private boolean readFlag(RandomAccessFile rand) throws Exception {
        return rand.readBoolean();
    }

    private boolean readFlag(DataInputStream in) throws Exception {
        return in.readBoolean();
    }

    private void writeShort(short toWrite, RandomAccessFile rand) throws Exception {
        rand.writeShort(toWrite);
    }

    private short readShort(RandomAccessFile rand) throws Exception {
        return rand.readShort();
    }

    private void writeInt(int toWrite, RandomAccessFile rand) throws Exception {
        rand.writeInt(toWrite);
    }

    private int readInt(RandomAccessFile rand) throws Exception {
        return rand.readInt();
    }

    private void writeLong(long toWrite, RandomAccessFile rand) throws Exception {
        rand.writeLong(toWrite);
    }

    private long readLong(RandomAccessFile rand) throws Exception {
        return rand.readLong();
    }

    private void writePartitionPoints(float[][] partitionPoints, RandomAccessFile rand) throws Exception {
        for (int i = 0; i < partitionPoints.length; ++i) {
            for (int q = 0; q < partitionPoints[i].length; ++q) {
                rand.writeFloat(partitionPoints[i][q]);
            }
        }
    }

    private float[][] readPartitionPoints(int dimentions, int buckets, RandomAccessFile rand) throws Exception {
        float[][] partitionPoints = new float[dimentions][buckets];
        for (int i = 0; i < partitionPoints.length; ++i) {
            for (int q = 0; q < partitionPoints[i].length; ++q) {
                partitionPoints[i][q] = rand.readFloat();
            }
        }
        return partitionPoints;
    }

    public void writeHeader(VAFileParams params, RandomAccessFile rand) throws Exception {
        if (params.getPartitionPoints().length != params.getVectorLength() || params.getPartitionPoints()[0].length != params.getBuckets()) {
            throw new Exception("invalid partition points lengths");
        }
        try {
            rand.seek(0L);
            long start = rand.getFilePointer();
            this.writeLong(start, rand);
            this.writeString(params.getIndexName(), rand);
            this.writeString(params.getIndexID(), rand);
            this.writeString(params.getDistanceMeasure().toString(), rand);
            this.writeString(params.getFeatureName().toString(), rand);
            this.writeString(params.getStorage(), rand);
            this.writeInt(params.getIDLength(), rand);
            this.writeInt(params.getVectorLength(), rand);
            this.writeLong(params.getElementCount(), rand);
            this.writeShort(params.getBits(), rand);
            this.writeInt(params.getBuckets(), rand);
            this.writeLong(params.getApproximationEntryLength(), rand);
            this.writeLong(params.getVectorEntryLength(), rand);
            this.writePartitionPoints(params.getPartitionPoints(), rand);
            this.writeVector(params.getXSum(), rand);
            this.writeVector(params.getX2Sum(), rand);
            this.writeVector(params.getWeights(), rand);
            this.writeFlag(params.getWeighted(), rand);
            long offset = rand.getFilePointer();
            rand.seek(start);
            this.writeLong(offset, rand);
        }
        catch (Exception e) {
            log.error((Object)"Could not write header. Thrpwing Exception", (Throwable)e);
            throw new Exception("Could not write header");
        }
    }

    public void skipHeader(RandomAccessFile rand) throws Exception {
        try {
            rand.seek(0L);
            long offset = this.readLong(rand);
            rand.seek(offset);
        }
        catch (Exception e) {
            log.error((Object)"Could not skip header. Thrpwing Exception", (Throwable)e);
            throw new Exception("Could not skip header");
        }
    }

    public VAFileParams readHeader(RandomAccessFile rand) throws Exception {
        try {
            rand.seek(0L);
            this.readLong(rand);
            VAFileParams params = new VAFileParams();
            params.setIndexName(this.readString(rand));
            params.setIndexID(this.readString(rand));
            params.setDistanceMeasure(FIEnums.DistanceTypes.valueOf(this.readString(rand)));
            params.setFeatureName(this.readString(rand));
            params.setStorage(this.readString(rand));
            params.setIDLength(this.readInt(rand));
            this.idlength = params.getIDLength();
            params.setVectorLength(this.readInt(rand));
            this.vectorlength = params.getVectorLength();
            params.setElementCount(this.readLong(rand));
            params.setBits(this.readShort(rand));
            params.setBuckets(this.readInt(rand));
            params.setApproximationEntryLength(this.readLong(rand));
            params.setVectorEntryLength(this.readLong(rand));
            params.setPartitionPoints(this.readPartitionPoints(params.getVectorLength(), params.getBuckets(), rand));
            params.setXSum(this.readVector(rand));
            params.setX2Sum(this.readVector(rand));
            params.setWeights(this.readVector(rand));
            params.setWeighted(this.readFlag(rand));
            return params;
        }
        catch (Exception e) {
            log.error((Object)"Could not read header. Thrpwing Exception", (Throwable)e);
            throw new Exception("Could not read header");
        }
    }

    public void writeApproximation(ApproximationFileEntry entry, RandomAccessFile rand) throws Exception {
        try {
            this.writeFlag(entry.isActive(), rand);
            rand.write(entry.getBitString());
        }
        catch (Exception e) {
            log.error((Object)"Could not write approximation. Thrpwing Exception", (Throwable)e);
            throw new Exception("Could not write approximation");
        }
    }

    public ApproximationFileEntry readApproximation(RandomAccessFile rand) {
        try {
            byte[] bitString = new byte[this.vectorlength];
            boolean active = this.readFlag(rand);
            for (int i = 0; i < bitString.length; ++i) {
                bitString[i] = rand.readByte();
            }
            return new ApproximationFileEntry(bitString, active);
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            log.debug((Object)"Could not read apprixmiation. assuming EOF", (Throwable)e);
            return null;
        }
    }

    public ApproximationFileEntry readApproximation(DataInputStream in) {
        try {
            byte[] bitString = new byte[this.vectorlength];
            boolean active = in.readBoolean();
            for (int i = 0; i < bitString.length; ++i) {
                bitString[i] = in.readByte();
            }
            return new ApproximationFileEntry(bitString, active);
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            log.debug((Object)"Could not read apprixmiation. assuming EOF", (Throwable)e);
            return null;
        }
    }

    public void writeRecord(VectorFileEntry entry, RandomAccessFile rand) throws Exception {
        if (this.idlength != entry.getId().length() || this.vectorlength != entry.getVector().length) {
            throw new Exception("dimention length missmatch");
        }
        try {
            this.writeFlag(entry.isActive(), rand);
            this.writeID(entry.getId(), rand);
            this.writeVector(entry.getVector(), rand);
        }
        catch (Exception e) {
            log.error((Object)"Could not write record. Thrpwing Exception", (Throwable)e);
            throw new Exception("Could not write record");
        }
    }

    public VectorFileEntry readRecord(RandomAccessFile rand) {
        try {
            boolean active = this.readFlag(rand);
            String id = this.readID(rand);
            float[] vector = this.readVector(rand);
            return new VectorFileEntry(id, vector, active);
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            log.debug((Object)"Could not read record. assuming EOF", (Throwable)e);
            return null;
        }
    }

    public VectorFileEntry readRecord(DataInputStream in) {
        try {
            boolean active = this.readFlag(in);
            String id = this.readID(in);
            float[] vector = this.readVector(in);
            return new VectorFileEntry(id, vector, active);
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            log.debug((Object)"Could not read apprixmiation. assuming EOF", (Throwable)e);
            return null;
        }
    }
}

