/**
 * 
 */
package org.gcube.indexmanagement.common.notifications;

import java.util.LinkedList;
import java.util.List;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.globus.wsrf.impl.SimpleTopic;

/**
 * @author Spyros Boutsis, NKUA
 *
 */
public class UnregisterNotificationRequest extends NotifierRequest {
	
	private List<SimpleTopic> topicList;
	
	public UnregisterNotificationRequest(EndpointReferenceType epr, List<SimpleTopic> topicList, GCUBEServiceContext sctx, GCUBEScope scope) {
		super(epr, sctx, scope);
		this.topicList = new LinkedList<SimpleTopic>(topicList);
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.indexmanagement.common.notifications.NotifierRequest#doRequest()
	 */
	@Override
	public void doRequest() {
		ISNotifier notifier = NotifierRequestQueue.getInstance().getNotifier();
		
		boolean bRetry = true;
		while (bRetry) {
			try {
				notifier.unregisterISNotification(this.epr, this.topicList, this.sctx, this.scope);
				bRetry = false;
			} catch (Exception e) {
				logger.warn("Exception while trying to unregister topics. Retrying...", e);
				try {
					Thread.sleep(5000);
				} catch (InterruptedException ex) { }
			}
		}
	}
}
