/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.jdbmwrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.btree.BTree;
import jdbm.helper.IntegerComparator;
import jdbm.helper.StringComparator;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.PropertyElementForwardIndex;
import org.gcube.indexmanagement.common.XMLProfileParser;
import org.gcube.indexmanagement.common.XMLTokenReplacer;
import org.gcube.indexmanagement.jdbmwrapper.CustomDate;
import org.gcube.indexmanagement.jdbmwrapper.DateComparator;
import org.gcube.indexmanagement.jdbmwrapper.FloatComparator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class JdbmWrapper {
    private String dbPathAndName;
    private String treeName;
    private String treeDir;
    private Properties props;
    private BTree tree;
    private RecordManager recman;
    private long recid;
    static GCUBELog logger = new GCUBELog(JdbmWrapper.class);
    private Comparator comparator;
    private DbTypeEnum dbType;

    public JdbmWrapper(String treeDir, String dbName, String treeName, DbTypeEnum dbT) throws IndexException {
        this.dbType = dbT;
        logger.debug((Object)(" >>> JdbmWrapper \ntreeDir: " + treeDir + "dbName: " + dbName + "treeName: " + treeName + "dbT " + (Object)((Object)dbT)));
        this.treeName = treeName;
        this.props = new Properties();
        this.treeDir = treeDir;
        this.dbPathAndName = this.treeDir + dbName;
        try {
            this.recman = RecordManagerFactory.createRecordManager((String)this.dbPathAndName, (Properties)this.props);
            this.recid = this.recman.getNamedObject(this.treeName);
            if (this.recid != 0L) {
                logger.debug((Object)("   JdbmWrapper reload tree name " + this.dbPathAndName));
                this.tree = BTree.load((RecordManager)this.recman, (long)this.recid);
                if (this.dbType == DbTypeEnum.INT_TYPE) {
                    logger.debug((Object)"    Int database loaded");
                    this.comparator = new IntegerComparator();
                } else if (this.dbType == DbTypeEnum.FLOAT_TYPE) {
                    logger.debug((Object)"    Float database loaded");
                    this.comparator = new FloatComparator();
                } else if (this.dbType == DbTypeEnum.STRING_TYPE) {
                    logger.debug((Object)"    String database loaded");
                    this.comparator = new StringComparator();
                } else if (this.dbType == DbTypeEnum.DATE_TYPE) {
                    logger.debug((Object)"    Date database loaded");
                    this.comparator = new DateComparator();
                } else {
                    logger.error((Object)"ForwardIndex Can not create database");
                }
            } else if (this.dbType == DbTypeEnum.INT_TYPE) {
                this.tree = BTree.createInstance((RecordManager)this.recman, (Comparator)new IntegerComparator());
                this.recman.setNamedObject(this.treeName, this.tree.getRecid());
                this.comparator = new IntegerComparator();
                logger.debug((Object)"    New int datbase created ");
            } else if (this.dbType == DbTypeEnum.FLOAT_TYPE) {
                this.tree = BTree.createInstance((RecordManager)this.recman, (Comparator)new FloatComparator());
                this.recman.setNamedObject(this.treeName, this.tree.getRecid());
                this.comparator = new FloatComparator();
                logger.debug((Object)"    New float datbase created ");
            } else if (this.dbType == DbTypeEnum.STRING_TYPE) {
                this.tree = BTree.createInstance((RecordManager)this.recman, (Comparator)new StringComparator());
                this.recman.setNamedObject(this.treeName, this.tree.getRecid());
                this.comparator = new StringComparator();
                logger.debug((Object)"    New string datbase created ");
            } else if (this.dbType == DbTypeEnum.DATE_TYPE) {
                this.tree = BTree.createInstance((RecordManager)this.recman, (Comparator)new DateComparator());
                this.recman.setNamedObject(this.treeName, this.tree.getRecid());
                this.comparator = new DateComparator();
                logger.debug((Object)"    New date datbase created ");
            } else {
                logger.error((Object)" *** ForwardIndex Can not create database");
            }
            logger.debug((Object)" <<< JdbmWrapper");
        }
        catch (Exception e) {
            logger.error((Object)"db create failed ", (Throwable)e);
        }
    }

    public void close() throws Exception {
        File dataDir = new File(this.treeDir);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(JdbmWrapper.this.treeName);
            }
        };
        for (File f : dataDir.listFiles(filter)) {
            f.delete();
        }
    }

    public void insertPairInDb(Object key, Object value) throws IndexException {
        logger.debug((Object)(" >>> insertPairInDb key/value:  " + key + " / " + value));
        try {
            LinkedList valueList = this.tree.find(key) == null ? new LinkedList() : (LinkedList)this.tree.find(key);
            valueList.add(value);
            this.tree.insert(key, (Object)valueList, true);
            this.recman.commit();
            logger.debug((Object)" <<< insertPairInDb");
        }
        catch (Exception e) {
            logger.error((Object)" *** insertPairInDb error: ", (Throwable)e);
            throw new IndexException(" *** Error *** insertPair got IOException:  key/value: " + key + "/" + value + ":" + e.getMessage());
        }
    }

    public void deletePairInDb(Object key) throws IndexException {
        logger.debug((Object)(" >>> deletePairInDb: " + key));
        try {
            this.tree.remove(key);
            logger.debug((Object)" <<< deletePairInDb");
        }
        catch (Exception e) {
            logger.error((Object)(" *** deletePairInDb error for key: " + key + " message: " + e.getMessage()));
            throw new IndexException(" *** Error *** deletePair got IOException:  key: " + key + ":" + e.getMessage());
        }
    }

    public void insertRowSet(String rowset) throws IndexException {
        logger.debug((Object)(" >>> insertRowSet:\n" + rowset));
        XMLProfileParser XMLparser = new XMLProfileParser();
        String[][] fieldData = null;
        try {
            String key;
            XMLparser.readString(rowset, null);
            XMLparser.setRootNode("ROWSET");
            fieldData = XMLparser.getSubFields();
            if (fieldData[0][0].equalsIgnoreCase("insert") || fieldData[0][1].equalsIgnoreCase("insert")) {
                XMLparser.setRootNode("tuple");
                while (XMLparser.setNextField()) {
                    fieldData = XMLparser.getSubFields();
                    if (!fieldData[0][0].equals("key")) {
                        logger.error((Object)" *** insertRowSet error, insert error, key not defined");
                        throw new IndexException(" *** insertRowSet error ***: *** Error 'key' is not first field in rowset");
                    }
                    if (!fieldData[0][1].equals("value")) {
                        logger.error((Object)" *** insertRowSet error, insert error, value not defined");
                        throw new IndexException(" *** insertRowSet error ***: *** Error 'value' is not second field in rowset");
                    }
                    key = fieldData[1][0];
                    String value = fieldData[1][1];
                    if (this.dbType == DbTypeEnum.INT_TYPE) {
                        this.insertPairInDb(this.convertToInt(key), value);
                        continue;
                    }
                    if (this.dbType == DbTypeEnum.FLOAT_TYPE) {
                        this.insertPairInDb(Float.valueOf(this.convertToFloat(key)), value);
                        continue;
                    }
                    if (this.dbType == DbTypeEnum.STRING_TYPE) {
                        this.insertPairInDb(this.convertToString(key), value);
                        continue;
                    }
                    if (this.dbType != DbTypeEnum.DATE_TYPE) continue;
                    this.insertPairInDb(this.convertToDate(key), value);
                }
            }
            if (fieldData[0][0].equalsIgnoreCase("delete") || fieldData[0][1].equalsIgnoreCase("delete")) {
                XMLparser.setRootNode("tuple");
                while (XMLparser.setNextField()) {
                    fieldData = XMLparser.getSubFields();
                    if (!fieldData[0][0].equals("key")) {
                        logger.error((Object)" *** insertRowSet error, delete error, key not defined");
                        throw new IndexException(" *** deleteRowSet error ***: *** Error 'key' is not first field in rowset");
                    }
                    key = fieldData[1][0];
                    if (this.dbType == DbTypeEnum.INT_TYPE) {
                        this.deletePairInDb(this.convertToInt(key));
                        continue;
                    }
                    if (this.dbType == DbTypeEnum.FLOAT_TYPE) {
                        this.deletePairInDb(Float.valueOf(this.convertToFloat(key)));
                        continue;
                    }
                    if (this.dbType == DbTypeEnum.STRING_TYPE) {
                        this.deletePairInDb(this.convertToString(key));
                        continue;
                    }
                    if (this.dbType != DbTypeEnum.DATE_TYPE) continue;
                    this.deletePairInDb(this.convertToDate(key));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)(" *** insertRowSet error " + e.getMessage()));
            throw new IndexException(" *** insertRowSet error ***: " + e.getMessage());
        }
        logger.debug((Object)" <<< insertRowSet");
    }

    private void addToResults(RSXMLWriter writer, Object key, Object value) throws Exception {
        String xmlResult = null;
        ResultElementGeneric element = new ResultElementGeneric();
        String serializedRSElem = XMLTokenReplacer.XMLResolve((String)value);
        element.RS_fromXML(serializedRSElem);
        xmlResult = "<tuple>";
        xmlResult = xmlResult + "<key>";
        xmlResult = xmlResult + key;
        xmlResult = xmlResult + "</key>";
        xmlResult = xmlResult + "<value>";
        xmlResult = xmlResult + element.getPayload();
        xmlResult = xmlResult + "</value>";
        xmlResult = xmlResult + "</tuple>";
        ResultElementGeneric tmp = new ResultElementGeneric("1", "1", xmlResult);
        tmp.setRecordAttributes(element.getRecordAttributes());
        writer.addResults((ResultElementBase)tmp);
        logger.debug((Object)"=================================");
        logger.debug((Object)("jdbmWrapper added to lookup results: " + xmlResult));
        logger.debug((Object)"=================================");
    }

    private void addToResults(RSXMLWriter writer, Object key) throws Exception {
        String xmlResult = "<key>" + key.toString() + "</key>";
        writer.addResults((ResultElementBase)new ResultElementGeneric("1", "1", xmlResult));
        logger.debug((Object)"=================================");
        logger.debug((Object)("jdbmWrapper added to lookup results: " + xmlResult));
        logger.debug((Object)"=================================");
    }

    public String getEQ(final Object key, final boolean bKeysOnly) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getEQ for key: " + key));
                    LinkedList valueList = null;
                    try {
                        valueList = (LinkedList)JdbmWrapper.this.tree.find(key);
                        if (valueList != null) {
                            if (bKeysOnly) {
                                JdbmWrapper.this.addToResults(rsWriter, key);
                            } else {
                                ListIterator it = valueList.listIterator();
                                while (it.hasNext()) {
                                    Object value = it.next();
                                    JdbmWrapper.this.addToResults(rsWriter, key, value);
                                }
                            }
                        }
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getEQ error key: " + key + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (valueList == null) {
                        logger.debug((Object)("getEQ no result for key: " + key));
                    }
                    logger.debug((Object)" <<< getEQ");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public String getGE(final Object keyGE, final boolean bKeysOnly) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getGE for key: " + keyGE));
                    LinkedList valueList = null;
                    Tuple tuple = new Tuple(null, null);
                    try {
                        TupleBrowser browser = JdbmWrapper.this.tree.browse(keyGE);
                        while (browser.getNext(tuple)) {
                            Object nextKey = tuple.getKey();
                            if (bKeysOnly) {
                                JdbmWrapper.this.addToResults(rsWriter, nextKey);
                                continue;
                            }
                            valueList = (LinkedList)tuple.getValue();
                            ListIterator it = valueList.listIterator();
                            while (it.hasNext()) {
                                Object value = it.next();
                                JdbmWrapper.this.addToResults(rsWriter, nextKey, value);
                            }
                        }
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getGE error for key: " + keyGE + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getGE");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public String getGT(final Object keyGT, final boolean bKeysOnly) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getGT for key: " + keyGT));
                    LinkedList valueList = null;
                    Tuple tuple = new Tuple(null, null);
                    try {
                        TupleBrowser browser = JdbmWrapper.this.tree.browse(keyGT);
                        while (browser.getNext(tuple)) {
                            if (JdbmWrapper.this.comparator.compare(tuple.getKey(), keyGT) <= 0) continue;
                            Object nextKey = tuple.getKey();
                            if (bKeysOnly) {
                                JdbmWrapper.this.addToResults(rsWriter, nextKey);
                                continue;
                            }
                            valueList = (LinkedList)tuple.getValue();
                            ListIterator it = valueList.listIterator();
                            while (it.hasNext()) {
                                Object value = it.next();
                                JdbmWrapper.this.addToResults(rsWriter, nextKey, value);
                            }
                        }
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getGT error for key: " + keyGT + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getGT");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public String getLE(final Object keyLE, final boolean bKeysOnly) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getLE for key: " + keyLE));
                    LinkedList valueList = null;
                    Tuple tuple = new Tuple(null, null);
                    try {
                        TupleBrowser browser = JdbmWrapper.this.tree.browse();
                        while (browser.getNext(tuple) && JdbmWrapper.this.comparator.compare(tuple.getKey(), keyLE) <= 0) {
                            Object nextKey = tuple.getKey();
                            if (bKeysOnly) {
                                JdbmWrapper.this.addToResults(rsWriter, nextKey);
                                continue;
                            }
                            valueList = (LinkedList)tuple.getValue();
                            ListIterator it = valueList.listIterator();
                            while (it.hasNext()) {
                                Object value = it.next();
                                JdbmWrapper.this.addToResults(rsWriter, nextKey, value);
                            }
                        }
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getLE error for key: " + keyLE + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getLE");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public String getLT(final Object keyLT, final boolean bKeysOnly) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getLT for key: " + keyLT));
                    LinkedList valueList = null;
                    Tuple tuple = new Tuple(null, null);
                    try {
                        TupleBrowser browser = JdbmWrapper.this.tree.browse();
                        while (browser.getNext(tuple) && JdbmWrapper.this.comparator.compare(tuple.getKey(), keyLT) < 0) {
                            Object nextKey = tuple.getKey();
                            if (bKeysOnly) {
                                JdbmWrapper.this.addToResults(rsWriter, nextKey);
                                continue;
                            }
                            valueList = (LinkedList)tuple.getValue();
                            ListIterator it = valueList.listIterator();
                            while (it.hasNext()) {
                                Object value = it.next();
                                JdbmWrapper.this.addToResults(rsWriter, nextKey, value);
                            }
                        }
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getLT error for key: " + keyLT + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getLT");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public String getGEandLE(final Object keyGE, final Object keyLE, final boolean bKeysOnly) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getGEandLE for keyGE " + keyGE + " keyLE " + keyLE));
                    LinkedList valueList = null;
                    Tuple tuple = new Tuple(null, null);
                    try {
                        TupleBrowser browser = JdbmWrapper.this.tree.browse(keyGE);
                        while (browser.getNext(tuple) && JdbmWrapper.this.comparator.compare(tuple.getKey(), keyLE) <= 0) {
                            Object nextKey = tuple.getKey();
                            if (bKeysOnly) {
                                JdbmWrapper.this.addToResults(rsWriter, nextKey);
                                continue;
                            }
                            valueList = (LinkedList)tuple.getValue();
                            ListIterator it = valueList.listIterator();
                            while (it.hasNext()) {
                                Object value = it.next();
                                JdbmWrapper.this.addToResults(rsWriter, nextKey, value);
                            }
                        }
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getGEandLE for keyGE and keyLE: " + keyGE + " / " + keyLE + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getGEandLE");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public String getGEandLT(final Object keyGE, final Object keyLT, final boolean bKeysOnly) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getGEandLT for keyGE " + keyGE + " keyLT " + keyLT));
                    LinkedList valueList = null;
                    Tuple tuple = new Tuple(null, null);
                    try {
                        TupleBrowser browser = JdbmWrapper.this.tree.browse(keyGE);
                        while (browser.getNext(tuple) && JdbmWrapper.this.comparator.compare(tuple.getKey(), keyLT) < 0) {
                            Object nextKey = tuple.getKey();
                            if (bKeysOnly) {
                                JdbmWrapper.this.addToResults(rsWriter, nextKey);
                                continue;
                            }
                            valueList = (LinkedList)tuple.getValue();
                            ListIterator it = valueList.listIterator();
                            while (it.hasNext()) {
                                Object value = it.next();
                                JdbmWrapper.this.addToResults(rsWriter, nextKey, value);
                            }
                        }
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getGEandLT for keyGE and keyLT: " + keyGE + " / " + keyLT + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getGEandLT");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public String getGTandLE(final Object keyGT, final Object keyLE, final boolean bKeysOnly) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getGTandLE for keyGT " + keyGT + " keyLE " + keyLE));
                    LinkedList valueList = null;
                    Tuple tuple = new Tuple(null, null);
                    try {
                        TupleBrowser browser = JdbmWrapper.this.tree.browse(keyGT);
                        while (browser.getNext(tuple)) {
                            if (JdbmWrapper.this.comparator.compare(tuple.getKey(), keyGT) <= 0) continue;
                            if (JdbmWrapper.this.comparator.compare(tuple.getKey(), keyLE) > 0) break;
                            Object nextKey = tuple.getKey();
                            if (bKeysOnly) {
                                JdbmWrapper.this.addToResults(rsWriter, nextKey);
                                continue;
                            }
                            valueList = (LinkedList)tuple.getValue();
                            ListIterator it = valueList.listIterator();
                            while (it.hasNext()) {
                                Object value = it.next();
                                JdbmWrapper.this.addToResults(rsWriter, nextKey, value);
                            }
                        }
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getGTandLE for keyGT and keyLE: " + keyGT + " / " + keyLE + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getGTandLE");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public String getGTandLT(final Object keyGT, final Object keyLT, final boolean bKeysOnly) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getGTandLT for keyGT " + keyGT + " keyLT " + keyLT));
                    LinkedList valueList = null;
                    Tuple tuple = new Tuple(null, null);
                    try {
                        TupleBrowser browser = JdbmWrapper.this.tree.browse(keyGT);
                        while (browser.getNext(tuple)) {
                            if (JdbmWrapper.this.comparator.compare(tuple.getKey(), keyGT) <= 0) continue;
                            if (JdbmWrapper.this.comparator.compare(tuple.getKey(), keyLT) >= 0) break;
                            Object nextKey = tuple.getKey();
                            if (bKeysOnly) {
                                JdbmWrapper.this.addToResults(rsWriter, nextKey);
                                continue;
                            }
                            valueList = (LinkedList)tuple.getValue();
                            ListIterator it = valueList.listIterator();
                            while (it.hasNext()) {
                                Object value = it.next();
                                JdbmWrapper.this.addToResults(rsWriter, nextKey, value);
                            }
                        }
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getGTandLT for keyGT and keyLT: " + keyGT + " / " + keyLT + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" >>> getGTandLT");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public String getAllDec(final boolean bKeysOnly) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)" >>> getAllDec");
                    LinkedList valueList = null;
                    Tuple tuple = new Tuple(null, null);
                    try {
                        TupleBrowser browser = JdbmWrapper.this.tree.browse(null);
                        while (browser.getPrevious(tuple)) {
                            Object nextKey = tuple.getKey();
                            if (bKeysOnly) {
                                JdbmWrapper.this.addToResults(rsWriter, nextKey);
                                continue;
                            }
                            valueList = (LinkedList)tuple.getValue();
                            ListIterator it = valueList.listIterator();
                            while (it.hasNext()) {
                                Object value = it.next();
                                JdbmWrapper.this.addToResults(rsWriter, nextKey, value);
                            }
                        }
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getAllDec  message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" >>> getAllDec");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public String getAllInc(final boolean bKeysOnly) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)" >>> getAllInc");
                    LinkedList valueList = null;
                    Tuple tuple = new Tuple(null, null);
                    try {
                        TupleBrowser browser = JdbmWrapper.this.tree.browse();
                        while (browser.getNext(tuple)) {
                            Object nextKey = tuple.getKey();
                            if (bKeysOnly) {
                                JdbmWrapper.this.addToResults(rsWriter, nextKey);
                                continue;
                            }
                            valueList = (LinkedList)tuple.getValue();
                            ListIterator it = valueList.listIterator();
                            while (it.hasNext()) {
                                Object value = it.next();
                                JdbmWrapper.this.addToResults(rsWriter, nextKey, value);
                            }
                        }
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getAllInc  message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" >>> getAllInc");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public synchronized int mergeDeletion(File deletionFile) throws IndexException {
        try {
            logger.debug((Object)" >>> mergeDeletion");
            logger.debug((Object)" <<< mergeDeletion");
            return 0;
        }
        catch (Exception ex) {
            logger.error((Object)(" *** mergeDeletion error  message: " + ex.getMessage()));
            return 1;
        }
    }

    public synchronized int mergeAddition(File inputIndex) throws IndexException {
        logger.debug((Object)(" >>> mergeAddition file:" + inputIndex + "DBT " + (Object)((Object)this.dbType)));
        boolean index = false;
        try {
            FileInputStream inputStream = new FileInputStream(inputIndex);
            int available = inputStream.available();
            FileChannel deltaChannel = inputStream.getChannel();
            if (available > 0) {
                ByteBuffer buffer = ByteBuffer.allocate(available);
                int bytesRead = deltaChannel.read(buffer);
                buffer.flip();
                byte[] c = new byte[buffer.capacity()];
                buffer.get(c);
                String rowSet = "<ROWSET>" + new String(c, "UTF-8") + "</ROWSET>";
                logger.debug((Object)("    rowset\n" + rowSet));
                UpdateXMLParser parser = new UpdateXMLParser();
                int numAddedDocs = parser.parse(rowSet);
                logger.debug((Object)" <<< mergeAddition");
                return numAddedDocs;
            }
            logger.error((Object)(" *** mergeAddition empty file, available bytes: " + available));
            throw new IndexException(" Empty insert file received");
        }
        catch (Exception ex) {
            logger.error((Object)(" *** mergeAddition error  message: " + ex.getMessage()));
            return 0;
        }
    }

    private void addTuple(String key, String value) {
        try {
            logger.debug((Object)"=================================");
            logger.debug((Object)("jdbmWrapper.addTuple merging current index with: " + value));
            logger.debug((Object)"=================================");
            if (this.dbType == DbTypeEnum.INT_TYPE) {
                this.insertPairInDb(this.convertToInt(key), value);
            } else if (this.dbType == DbTypeEnum.FLOAT_TYPE) {
                this.insertPairInDb(Float.valueOf(this.convertToFloat(key)), value);
            } else if (this.dbType == DbTypeEnum.STRING_TYPE) {
                this.insertPairInDb(this.convertToString(key), value);
            } else if (this.dbType == DbTypeEnum.DATE_TYPE) {
                this.insertPairInDb(this.convertToDate(key), value);
            }
        }
        catch (Exception e) {
            logger.error((Object)(" *** addTuple error  message: " + e.getMessage()));
        }
    }

    private void deleteTuple(String key) {
        try {
            if (this.dbType == DbTypeEnum.INT_TYPE) {
                this.deletePairInDb(this.convertToInt(key));
            } else if (this.dbType == DbTypeEnum.FLOAT_TYPE) {
                this.deletePairInDb(Float.valueOf(this.convertToFloat(key)));
            } else if (this.dbType == DbTypeEnum.STRING_TYPE) {
                this.deletePairInDb(this.convertToString(key));
            } else if (this.dbType == DbTypeEnum.DATE_TYPE) {
                this.deletePairInDb(this.convertToDate(key));
            }
        }
        catch (Exception e) {
            logger.error((Object)(" *** deleteTuple error  message: " + e.getMessage()));
        }
    }

    private final int convertToInt(Object in) throws IndexException {
        logger.debug((Object)(" >>> convertToInt input value: " + in));
        try {
            int res = new Integer((String)in);
            logger.debug((Object)(" <<< convertToInt value: " + res));
            return res;
        }
        catch (Exception ex) {
            logger.error((Object)(" *** convertToInt error  message: " + ex.getMessage()));
            throw new IndexException(" *** convertToInt error", ex);
        }
    }

    private final float convertToFloat(Object in) throws IndexException {
        logger.debug((Object)(" >>> convertToFloat input value: " + in));
        try {
            float res = new Float((String)in).floatValue();
            logger.debug((Object)(" <<< convertToFloat float: " + res));
            return res;
        }
        catch (Exception ex) {
            logger.error((Object)(" *** convertToFloat error  message: " + ex.getMessage()));
            throw new IndexException(" *** convertToFloat error", ex);
        }
    }

    private final Date convertToDate(Object in) throws IndexException {
        logger.debug((Object)(" >>> convertToDate input value: " + in));
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            CustomDate res = new CustomDate((String)in, df);
            logger.debug((Object)(" <<< convertToDate date: " + res));
            return res;
        }
        catch (Exception ex) {
            logger.error((Object)(" *** convertToDate error  message: " + ex.getMessage()));
            throw new IndexException(" *** convertToDate error", ex);
        }
    }

    private final String convertToString(Object in) throws IndexException {
        logger.debug((Object)(" >>> convertToString input value: " + in));
        try {
            String res = new String((String)in);
            logger.debug((Object)(" <<< convertToString string: " + res));
            return res;
        }
        catch (Exception ex) {
            logger.error((Object)(" *** convertToString error  message: " + ex.getMessage()));
            throw new IndexException(" *** convertToString error", ex);
        }
    }

    public synchronized void updateIndex() throws IndexException {
        logger.debug((Object)" >>> updateIndex");
        logger.debug((Object)" <<< updateIndex");
    }

    private void printRs(String result) {
        logger.info((Object)("Result set: " + result));
    }

    private void printList(LinkedList result) {
        int hits = 0;
        String xmlResult = "<forwardIndexResult>";
        ListIterator it = result.listIterator();
        while (it.hasNext()) {
            Tuple tuple = (Tuple)it.next();
            ++hits;
            xmlResult = xmlResult + "<tuple>";
            xmlResult = xmlResult + "<key>";
            xmlResult = xmlResult + tuple.getKey();
            xmlResult = xmlResult + "</key>";
            xmlResult = xmlResult + "<value>";
            xmlResult = xmlResult + tuple.getValue();
            xmlResult = xmlResult + "</value>";
            xmlResult = xmlResult + "</tuple>";
        }
        xmlResult = xmlResult + "</forwardIndexResult>";
        logger.info((Object)xmlResult);
    }

    public static void main(String[] args) {
        boolean printRes = true;
        DbTypeEnum[] dbtAll = DbTypeEnum.values();
        try {
            int startTime = (int)Calendar.getInstance().getTimeInMillis();
            logger.info((Object)" Create Object");
            DbTypeEnum dbt = DbTypeEnum.INT_TYPE;
            JdbmWrapper db = new JdbmWrapper(".", "namedb4", "nametree4", dbt);
            db.insertPairInDb(40001, 21000);
            logger.info((Object)"Insert second 40001/21101");
            db.insertPairInDb(40001, 21101);
            logger.info((Object)"GetEQ");
            String res = db.getEQ(40001, false);
            db.printRs(res);
            db.insertPairInDb(40001, 21101);
            res = db.getEQ(40001, false);
            db.printRs(res);
            db.deletePairInDb(40001);
            db.insertPairInDb(1, 1000);
            db.insertPairInDb(100001, 1000);
            int key1 = 0;
            for (int i = 10; i < 10000; ++i) {
                db.insertPairInDb(i, i + 1000);
                res = db.getEQ(i, false);
                if (printRes) {
                    db.printRs(res);
                }
                res = db.getGE(i, false);
                if (printRes) {
                    db.printRs(res);
                }
                res = db.getGT(i, false);
                if (printRes) {
                    db.printRs(res);
                }
                res = db.getLE(i, false);
                if (printRes) {
                    db.printRs(res);
                }
                res = db.getLT(i, false);
                if (printRes) {
                    db.printRs(res);
                }
                res = db.getGEandLE(key1, i, false);
                if (printRes) {
                    db.printRs(res);
                }
                res = db.getGEandLT(key1, i, false);
                if (printRes) {
                    db.printRs(res);
                }
                res = db.getGTandLE(key1, i, false);
                if (printRes) {
                    db.printRs(res);
                }
                res = db.getGTandLT(key1, i, false);
                if (!printRes) continue;
                db.printRs(res);
            }
            long usedTime = Calendar.getInstance().getTimeInMillis() - (long)startTime;
            logger.info((Object)(" Used time: millis: " + usedTime));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    class UpdateXMLParser
    extends DefaultHandler {
        private static final String INSERT_ELEMENT = "INSERT";
        private static final String DELETE_ELEMENT = "DELETE";
        private static final String TUPLE_ELEMENT = "TUPLE";
        private static final String KEY_ELEMENT = "KEY";
        private static final String VALUE_ELEMENT = "VALUE";
        private ParserState currState = ParserState.IDLE;
        private String currKey = null;
        private String currValue = null;
        private boolean bDeletion = false;
        private Exception e = null;
        private int numDocsAdded = 0;

        public int parse(String updateData) throws Exception {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            xr.parse(new InputSource(new StringReader(updateData)));
            if (this.e != null) {
                throw this.e;
            }
            return this.numDocsAdded;
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes atts) {
            boolean bError = false;
            if (qName.equalsIgnoreCase(INSERT_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IDLE)) {
                    this.currState = ParserState.IN_INSERT;
                    this.bDeletion = false;
                } else {
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(DELETE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IDLE)) {
                    this.currState = ParserState.IN_DELETE;
                    this.bDeletion = true;
                } else {
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(TUPLE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_INSERT) || this.currState.equals((Object)ParserState.IN_DELETE)) {
                    this.currState = ParserState.IN_TUPLE;
                } else {
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(KEY_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_TUPLE)) {
                    this.currState = ParserState.IN_KEY;
                } else {
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(VALUE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_TUPLE)) {
                    this.currState = ParserState.IN_VALUE;
                } else {
                    bError = true;
                }
            }
            if (bError) {
                this.e = new Exception("Invalid XML in rowset data");
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            boolean bError = false;
            if (qName.equalsIgnoreCase(INSERT_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_INSERT)) {
                    this.currState = ParserState.IDLE;
                } else {
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(DELETE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_DELETE)) {
                    this.currState = ParserState.IDLE;
                } else {
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(TUPLE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_TUPLE)) {
                    if (this.bDeletion) {
                        if (this.currKey != null) {
                            JdbmWrapper.this.deleteTuple(this.currKey);
                            --this.numDocsAdded;
                        }
                        this.currState = ParserState.IN_DELETE;
                    } else {
                        if (this.currKey != null && this.currValue != null) {
                            JdbmWrapper.this.addTuple(this.currKey, this.currValue);
                            ++this.numDocsAdded;
                        }
                        this.currState = ParserState.IN_INSERT;
                    }
                    this.currKey = null;
                    this.currValue = null;
                } else {
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(KEY_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_KEY)) {
                    this.currState = ParserState.IN_TUPLE;
                } else {
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(VALUE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_VALUE)) {
                    this.currState = ParserState.IN_TUPLE;
                } else {
                    bError = true;
                }
            }
            if (bError) {
                this.e = new Exception("Invalid XML in rowset data");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.currState == ParserState.IN_KEY) {
                String s = new String(ch, start, length);
                this.currKey = this.currKey == null ? s : this.currKey + s;
            } else if (this.currState == ParserState.IN_VALUE) {
                String s = new String(ch, start, length);
                this.currValue = this.currValue == null ? s : this.currValue + s;
            }
        }

        @Override
        public void error(SAXParseException e1) {
            this.e = e1;
        }

        @Override
        public void fatalError(SAXParseException e1) {
            this.e = e1;
        }
    }

    private static enum ParserState {
        IDLE,
        IN_INSERT,
        IN_DELETE,
        IN_TUPLE,
        IN_KEY,
        IN_VALUE;

    }

    public static enum DbTypeEnum {
        INT_TYPE,
        FLOAT_TYPE,
        STRING_TYPE,
        DATE_TYPE;

    }
}

