/**
 * 
 */
package org.gcube.indexmanagement.common.notifications;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.utils.logging.GCUBELog;

/**
 * @author Spyros Boutsis, NKUA
 *
 */
public class NotifierRequestQueue {

	private class RequestDispatcher extends Thread {
	
		/* (non-Javadoc)
		 * @see java.lang.Thread#run()
		 */
		@Override
		public void run() {
			int numReqs = 0;
			
			while (true) {
				NotifierRequest r = null;
				try {
					r = queue.take();
					logger.info("Index notification request dispatcer performing request of type " + r.getClass().getName() + "...");
					r.doRequest();
					logger.info("Request dispatched.");
					logger.info("Index notification request dispatcher has served " + (++numReqs) + " requests.");
				} catch (Exception e) { }
			}
		}
	}
	
	
	private static NotifierRequestQueue instance = null;
	private BlockingQueue<NotifierRequest> queue;
	private ISNotifier notifier;
	private RequestDispatcher dispatcherThread;
	static GCUBELog logger = new GCUBELog(NotifierRequestQueue.class);
	
	synchronized public static NotifierRequestQueue getInstance() {
		if (instance == null)
			instance = new NotifierRequestQueue();
		return instance;
	}
	
	private NotifierRequestQueue() {
		this.queue = new LinkedBlockingQueue<NotifierRequest>();
		try {
			this.notifier = GHNContext.getImplementation(ISNotifier.class);
		} catch (Exception e) {
			logger.error("Failed to retrieve ISNotifier instance!", e);
		}
		
		this.dispatcherThread = new RequestDispatcher();
		this.dispatcherThread.start();
	}
	
	public void add(NotifierRequest request) {
		try {
			this.queue.put(request);
		} catch (Exception e) { }
	}
	
	ISNotifier getNotifier() {
		return this.notifier;
	}

}
