/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.lucenewrapper;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSBLOBWriter;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexStatistics;
import org.gcube.indexmanagement.common.ServiceContextContainer;
import org.gcube.indexmanagement.common.StatisticsFileMerger;
import org.gcube.indexmanagement.common.XMLProfileParser;

public class LuceneStatistics
implements IndexStatistics {
    static GCUBELog logger = new GCUBELog(LuceneStatistics.class);
    private ServiceContextContainer ServiceContextCont = null;
    private IndexReader reader;
    private String indexPath = null;

    public LuceneStatistics(ServiceContextContainer ServiceContextCont) {
        this.ServiceContextCont = ServiceContextCont;
    }

    @Override
    public void openIndex(String baseIndexDir, String indexName) throws IndexException {
        this.indexPath = baseIndexDir + indexName;
        try {
            this.reader = IndexReader.open((String)this.indexPath);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to open index.", (Throwable)e);
            throw new IndexException("Failed to open index.", e);
        }
    }

    @Override
    public void updateIndex() throws IndexException {
        try {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                logger.error((Object)"could not close reader while updating the Index: ", (Throwable)e);
            }
            this.reader = IndexReader.open((String)this.indexPath);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to update index.", (Throwable)e);
            throw new IndexException("Failed to update index.", e);
        }
    }

    @Override
    public String createStatistics() throws IndexException {
        try {
            ByteArrayOutputStream memorizedFile = new ByteArrayOutputStream();
            BufferedOutputStream localOutput = new BufferedOutputStream(memorizedFile, 2048);
            BufferedOutputStream out = new BufferedOutputStream(localOutput);
            this.createXMLStatistics(out);
            ((OutputStream)out).close();
            ByteArrayInputStream in = new ByteArrayInputStream(memorizedFile.toByteArray());
            RSBLOBWriter writer = RSBLOBWriter.getRSBLOBWriter();
            ResultElementBLOBGeneric blob = new ResultElementBLOBGeneric("foo", "bar", null, (InputStream)new BufferedInputStream(in));
            writer.addResults((ResultElementBLOBBase)blob);
            String stats_RS_EPR = writer.getRSLocator((RSResourceType)new RSResourceWSRFType()).getLocator();
            writer.close();
            return stats_RS_EPR;
        }
        catch (Exception e) {
            logger.error((Object)"Error while producing index statistics.", (Throwable)e);
            throw new IndexException(e);
        }
    }

    @Override
    public String createMergedStatistics(List<String> RS_EPRs) throws IndexException {
        try {
            RS_EPRs.add(this.createStatistics());
            return StatisticsFileMerger.merge(RS_EPRs, this.ServiceContextCont);
        }
        catch (Exception e) {
            logger.error((Object)"Error while producing merged index statistics.", (Throwable)e);
            throw new IndexException("Failed to create merged statistics.", e);
        }
    }

    private void createXMLStatistics(OutputStream out) throws IndexException {
        try {
            String output = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<statistics>\n";
            output = output + "<head>\n<numDocs>" + this.reader.numDocs() + "</numDocs>\n" + "<time_created>" + new Date() + "</time_created>\n</head>\n";
            output = output + "<body><terms>\n";
            out.write(output.getBytes("ISO-8859-1"), 0, output.length());
            TermEnum te = this.reader.terms();
            int termCount = 0;
            while (te.next()) {
                ++termCount;
                Term term = te.term();
                if (term.field() != "_contents") continue;
                int absCount = 0;
                TermDocs td = this.reader.termDocs(term);
                while (td.next()) {
                    absCount += td.freq();
                }
                String termElement = "  <term><t>" + XMLProfileParser.escapeForXML(term.text()) + "</t><d>" + te.docFreq() + "</d><c>" + absCount + "</c></term>\n";
                out.write(termElement.getBytes("ISO-8859-1"), 0, termElement.length());
            }
            String footer = "</terms></body>\n</statistics>\n";
            out.write(footer.getBytes("ISO-8859-1"), 0, footer.length());
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create XML statistics.", (Throwable)e);
            throw new IndexException("Failed to create XML statistics.", e);
        }
    }

    @Override
    public void close() throws IndexException {
    }
}

