/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common.notifications;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.indexmanagement.common.notifications.NotifierRequest;
import org.gcube.indexmanagement.common.notifications.NotifierRequestQueue;

public class SubscribeToNotificationRequest
extends NotifierRequest {
    private List<QName> topicList;
    private ISNotifier.BaseNotificationConsumer consumer;

    public SubscribeToNotificationRequest(List<QName> topicList, ISNotifier.BaseNotificationConsumer consumer, GCUBEServiceContext sctx, GCUBEScope scope) {
        super(null, sctx, scope);
        this.topicList = new LinkedList<QName>(topicList);
        this.consumer = consumer;
    }

    @Override
    public void doRequest() {
        ISNotifier notifier = NotifierRequestQueue.getInstance().getNotifier();
        LinkedList<ISNotifier.GCUBENotificationTopic> topics = new LinkedList<ISNotifier.GCUBENotificationTopic>();
        for (int i = 0; i < this.topicList.size(); ++i) {
            ISNotifier.GCUBENotificationTopic topic = new ISNotifier.GCUBENotificationTopic(this.topicList.get(i));
            topic.setUseRenotifier(true);
            topics.add(topic);
        }
        try {
            notifier.registerToISNotification(this.consumer, topics, (GCUBESecurityManager)this.sctx, new GCUBEScope[]{this.scope});
        }
        catch (Exception e) {
            logger.warn((Object)"Exception while trying to subscribe to topics.", (Throwable)e);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }
}

