/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.RandomAccessFile;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FileHelper;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.ApproximationFileEntry;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.IOHelper;

public class ApproximationFileRandomAccess {
    private static Logger log = Logger.getLogger(ApproximationFileRandomAccess.class);
    private VAFileParams params = null;
    private RandomAccessFile rand = null;
    private IOHelper helper = null;

    public ApproximationFileRandomAccess(VAFileParams params) throws Exception {
        try {
            this.params = params;
            this.helper = new IOHelper();
            this.helper.setIDLength(params.getIDLength());
            this.helper.setVectorLength(params.getVectorLength());
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize reader. throing Exception", (Throwable)e);
            throw new Exception("Could not initialize reader");
        }
    }

    public void open() throws Exception {
        try {
            this.rand = new RandomAccessFile(FileHelper.getVAFApproxFile(this.params.getStorage(), this.params.getIndexID()), "rw");
        }
        catch (Exception e) {
            log.error((Object)"Could not open reader. throing Exception", (Throwable)e);
            throw new Exception("Could not open reader");
        }
    }

    public void moveTo(long recNum) throws Exception {
        try {
            this.rand.seek(recNum * this.params.getApproximationEntryLength());
        }
        catch (Exception e) {
            log.error((Object)("Could not move to record " + recNum + ". throing Exception"), (Throwable)e);
            throw new Exception("Could not move to record " + recNum);
        }
    }

    public void write(ApproximationFileEntry entry) throws Exception {
        try {
            if (entry.getBitString().length != this.params.getVectorLength()) {
                throw new Exception("new entry dimentions don't match");
            }
            this.helper.writeApproximation(entry, this.rand);
        }
        catch (Exception e) {
            log.error((Object)"Could not write entry. throing Exception", (Throwable)e);
            throw new Exception("Could not write entry");
        }
    }

    public ApproximationFileEntry read() {
        return this.helper.readApproximation(this.rand);
    }

    public void close() throws Exception {
        try {
            this.rand.close();
        }
        catch (Exception e) {
            log.error((Object)"Could not close. throing Exception", (Throwable)e);
            throw new Exception("Could not close");
        }
    }
}

