/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.bdbwrapper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.bdbwrapper.BDBGcqlQueryContainer;
import org.gcube.indexmanagement.bdbwrapper.BDBQueryExecutor;
import org.gcube.indexmanagement.bdbwrapper.BDBWrapper;
import org.gcube.indexmanagement.gcqlwrapper.GcqlProcessor;
import org.gcube.indexmanagement.gcqlwrapper.GcqlQueryContainer;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLNotNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLQueryTreeManager;
import search.library.util.cql.query.tree.GCQLTermNode;
import search.library.util.cql.query.tree.Modifier;
import search.library.util.cql.query.tree.ModifierSet;

public class BDBGcqlProcessor
extends GcqlProcessor {
    private static final String DISTINCT = "distinct";
    private LinkedHashMap<String, String> projectedFields = new LinkedHashMap();
    private boolean distinct = false;
    static GCUBELog logger = new GCUBELog(BDBGcqlProcessor.class);

    public static void main(String[] args) {
        ArrayList<String> presentable = new ArrayList<String>();
        ArrayList<String> searchable = new ArrayList<String>();
        presentable.add("title");
        presentable.add("author");
        presentable.add("year");
        presentable.add("code");
        searchable.add("title");
        searchable.add("author");
        searchable.add("year");
        searchable.add("description");
        searchable.add("anotations");
        searchable.add("code");
        searchable.add("gDocCollectionID");
        searchable.add("gDocCollectionLang");
        String query = " (((((title within \"A F\") or (author within \"A F\")) not ((title within \"B D\") and (author within \"E Q\"))) and ((code exact \"124adb323456\") or (code exact \"68dc3245abe231\")) ) and ((gDocCollectionID == A) and (gDocCollectionLang == fr)))  project title author code";
        try {
            BDBGcqlQueryContainer newContainer = (BDBGcqlQueryContainer)new BDBGcqlProcessor().processQuery(presentable, searchable, query, new RRadaptor("dummy"));
            for (ArrayList<BDBGcqlQueryContainer.SingleTerm> q : newContainer.getBdbQueries()) {
                BDBQueryExecutor.parseQueryTestLocally(q, new LinkedHashMap<String, ArrayList<String>>(), new ArrayList<String>());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public GcqlQueryContainer processQuery(ArrayList<String> presentableFields, ArrayList<String> searchableFields, String gCQLQuery, RRadaptor adaptor) throws Exception {
        this.presentableFields = presentableFields;
        this.searchableFields = searchableFields;
        this.adaptor = adaptor;
        GCQLNode head = GCQLQueryTreeManager.parseGCQLString((String)gCQLQuery);
        ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> bdbQueries = this.processNode(head, false);
        return new BDBGcqlQueryContainer(bdbQueries, this.projectedFields, this.distinct);
    }

    private ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> processNode(GCQLNode node, boolean not) throws Exception {
        if (node instanceof GCQLProjectNode) {
            return this.processNode((GCQLProjectNode)node, not);
        }
        if (node instanceof GCQLAndNode) {
            return this.processNode((GCQLAndNode)node, not);
        }
        if (node instanceof GCQLNotNode) {
            return this.processNode((GCQLNotNode)node, not);
        }
        if (node instanceof GCQLOrNode) {
            return this.processNode((GCQLOrNode)node, not);
        }
        if (node instanceof GCQLTermNode) {
            return this.processNode((GCQLTermNode)node, not);
        }
        throw new Exception("This node class is not supported: " + node.getClass().toString());
    }

    private ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> processNode(GCQLProjectNode node, boolean not) throws Exception {
        Vector projections = node.getProjectIndexes();
        for (ModifierSet projection : projections) {
            if (projection.getModifiers().size() > 0 && ((Modifier)projection.getModifiers().get(0)).getType().equalsIgnoreCase(DISTINCT)) {
                this.distinct = true;
            }
            if (projection.getBase().equals("*")) {
                this.distinct = false;
                this.projectedFields.clear();
                this.projectedFields.put("*", "*");
                return this.processNode(node.subtree, not);
            }
            String fieldLabel = this.adaptor.getFieldNameById(projection.getBase());
            String projField = this.findPresentable(fieldLabel);
            if (projField == null) {
                logger.error((Object)("Not in presentable fields: " + fieldLabel + ", " + projection.getBase()));
                continue;
            }
            this.projectedFields.put(projection.getBase(), projField);
        }
        return this.processNode(node.subtree, not);
    }

    private ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> processNode(GCQLTermNode node, boolean not) throws Exception {
        ArrayList<BDBGcqlQueryContainer.SingleTerm> query1 = new ArrayList<BDBGcqlQueryContainer.SingleTerm>();
        ArrayList<BDBGcqlQueryContainer.SingleTerm> query2 = null;
        boolean found = false;
        String index = null;
        if (node.getIndex().equals("gDocCollectionID") || node.getIndex().equals("gDocCollectionLang")) {
            node.getRelation().setBase("==".toString());
            index = node.getIndex();
            found = true;
        } else {
            String fieldLabel = this.adaptor.getFieldNameById(node.getIndex());
            for (String field : this.searchableFields) {
                if (!fieldLabel.equalsIgnoreCase(field)) continue;
                index = field;
                found = true;
                break;
            }
        }
        if (!found) {
            logger.error((Object)("This field is not detected in the searchable fields: " + node.getIndex() + " , searchableFields : " + this.searchableFields));
            throw new Exception("This field is not detected in the searchable fields: " + node.getIndex());
        }
        found = false;
        for (String relation : BDBWrapper.SupportedRelations) {
            if (!node.getRelation().getBase().equalsIgnoreCase(relation.toString())) continue;
            if (relation.equals("==")) {
                String value = BDBGcqlProcessor.removeQuotes(node.getTerm());
                if (!not) {
                    query1.add(new BDBGcqlQueryContainer.SingleTerm(index, "=", value));
                    logger.debug((Object)("Term node - exact: " + index + "=" + value));
                } else {
                    if (value.equals("*")) {
                        logger.debug((Object)"Term node - exact+not+wild = empty");
                        return new ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>>();
                    }
                    query1.add(new BDBGcqlQueryContainer.SingleTerm(index, ">", value));
                    logger.debug((Object)("Term node - exact+not: " + index + ">" + value));
                    query1.add(new BDBGcqlQueryContainer.SingleTerm(index, "<", value));
                    logger.debug((Object)("Term node - exact+not: " + index + "<" + value));
                }
            } else if (relation.equals("within")) {
                String[] values = BDBGcqlProcessor.splitTerms(node.getTerm());
                if (values.length != 2) {
                    logger.error((Object)("The argument of relation within is not valid: " + node.getTerm()));
                    throw new Exception("The argument of relation within is not valid: " + node.getTerm());
                }
                if (!not) {
                    if (!values[0].equals("*")) {
                        query1.add(new BDBGcqlQueryContainer.SingleTerm(index, ">=", values[0]));
                        logger.debug((Object)("Term node - within: " + index + ">" + "=" + values[0]));
                    }
                    if (!values[1].equals("*")) {
                        query1.add(new BDBGcqlQueryContainer.SingleTerm(index, "<=", values[1]));
                        logger.debug((Object)("Term node - within: " + index + "<" + "=" + values[1]));
                    }
                    if (values[0].equals("*") && values[1].equals("*")) {
                        query1.add(new BDBGcqlQueryContainer.SingleTerm(index, "=", "*"));
                        logger.debug((Object)("Term node - within: " + index + "=" + "*"));
                    }
                } else {
                    if (!values[0].equals("*")) {
                        query1.add(new BDBGcqlQueryContainer.SingleTerm(index, "<", values[0]));
                        logger.debug((Object)("Term node - within+not: " + index + "<" + values[0]));
                    }
                    if (!values[1].equals("*")) {
                        query2 = new ArrayList<BDBGcqlQueryContainer.SingleTerm>();
                        query2.add(new BDBGcqlQueryContainer.SingleTerm(index, ">", values[1]));
                        logger.debug((Object)("OR Term node - within+not: " + index + ">" + values[1]));
                    }
                    if (values[0].equals("*") && values[1].equals("*")) {
                        logger.debug((Object)"Term node - within+not+wild= empty");
                        return new ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>>();
                    }
                }
            } else {
                logger.error((Object)("Bug! Should not reach this point. This relation seems not to be supported: " + relation));
                throw new Exception("Bug! Should not reach this point. This relation seems not to be supported: " + relation);
            }
            found = true;
            break;
        }
        if (!found) {
            logger.error((Object)("This relation is not supported by this type of Index: " + node.getRelation().getBase()));
            throw new Exception("This relation is not supported by this type of Index: " + node.getRelation().getBase());
        }
        ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> result = new ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>>();
        result.add(query1);
        if (query2 != null) {
            result.add(query2);
        }
        return result;
    }

    private ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> processNode(GCQLNotNode node, boolean not) throws Exception {
        ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> leftQueries = this.processNode(node.left, not);
        ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> rightQueries = this.processNode(node.right, !not);
        logger.debug((Object)("Not node - not: " + not));
        this.logNumberOfConditions(leftQueries);
        this.logNumberOfConditions(rightQueries);
        if (not) {
            return this.concatenateQueries(leftQueries, rightQueries);
        }
        return this.mergeQueries(leftQueries, rightQueries);
    }

    private ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> processNode(GCQLAndNode node, boolean not) throws Exception {
        ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> leftQueries = this.processNode(node.left, not);
        ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> rightQueries = this.processNode(node.right, not);
        logger.debug((Object)("And node - not: " + not));
        this.logNumberOfConditions(leftQueries);
        this.logNumberOfConditions(rightQueries);
        if (not) {
            return this.concatenateQueries(leftQueries, rightQueries);
        }
        return this.mergeQueries(leftQueries, rightQueries);
    }

    private ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> processNode(GCQLOrNode node, boolean not) throws Exception {
        ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> leftQueries = this.processNode(node.left, not);
        ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> rightQueries = this.processNode(node.right, not);
        logger.debug((Object)("Or node - not: " + not));
        this.logNumberOfConditions(leftQueries);
        this.logNumberOfConditions(rightQueries);
        if (not) {
            return this.mergeQueries(leftQueries, rightQueries);
        }
        return this.concatenateQueries(leftQueries, rightQueries);
    }

    private ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> mergeQueries(ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> leftQueries, ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> rightQueries) {
        ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> result = new ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>>();
        for (ArrayList<BDBGcqlQueryContainer.SingleTerm> leftQuery : leftQueries) {
            for (ArrayList<BDBGcqlQueryContainer.SingleTerm> rightQuery : rightQueries) {
                ArrayList<BDBGcqlQueryContainer.SingleTerm> newQuery = new ArrayList<BDBGcqlQueryContainer.SingleTerm>();
                newQuery.addAll(leftQuery);
                newQuery.addAll(rightQuery);
                result.add(newQuery);
            }
        }
        return result;
    }

    private ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> concatenateQueries(ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> leftQueries, ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> rightQueries) {
        ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> result = leftQueries;
        result.addAll(rightQueries);
        return result;
    }

    private void logNumberOfConditions(ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> conditions) {
        logger.debug((Object)("Output is an OR of " + conditions.size() + " conditions"));
        for (ArrayList<BDBGcqlQueryContainer.SingleTerm> andConditions : conditions) {
            logger.debug((Object)("This condition has " + andConditions.size() + " terms"));
        }
    }
}

