/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class CompressingOutputStream
extends FilterOutputStream {
    private int prevCode = -1;
    private int codeCount = 0;
    private int codeSize;
    private int maxCodes;
    private int remainingPart = 0;
    private int remainingSize = 0;
    private int maxAllowedCodes = 524288;
    private HashMap<Integer, Integer> codes = new HashMap();

    public CompressingOutputStream(OutputStream out) {
        super(out);
        while (this.codeCount < 256) {
            this.codes.put(this.codeCount, this.codeCount);
            ++this.codeCount;
        }
        this.setCodeSize(9);
    }

    @Override
    public void close() throws IOException {
        this.writeCode(this.prevCode);
        this.writeCode(-1);
        super.close();
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        if (off + len > bytes.length) {
            len = bytes.length - off;
        }
        if (this.prevCode == -1 && bytes.length > 0) {
            this.prevCode = bytes[0] & 0xFF;
            ++off;
        }
        for (int i = off; i < len; ++i) {
            this.compress(bytes[i] & 0xFF);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (b > 255) {
            throw new IllegalArgumentException("Value not within byte range.");
        }
        if (this.prevCode == -1) {
            this.prevCode = b;
        } else {
            this.compress(b);
        }
    }

    private void compress(int currentByte) throws IOException {
        int read = (this.prevCode << 8) + currentByte;
        Integer readCode = this.codes.get(read);
        if (readCode != null) {
            this.prevCode = readCode;
        } else {
            this.writeCode(this.prevCode);
            if (this.codeCount < this.maxAllowedCodes) {
                if (this.codeCount == this.maxCodes) {
                    this.setCodeSize(this.codeSize + 1);
                }
                this.codes.put(read, this.codeCount++);
            }
            this.prevCode = currentByte;
        }
    }

    private void writeCode(int code) throws IOException {
        if (code == -1) {
            if (this.remainingSize != 0) {
                super.write(this.remainingPart << 8 - this.remainingSize);
                this.remainingPart = 0;
                this.remainingSize = 0;
            }
            return;
        }
        this.remainingPart = this.remainingPart << this.codeSize | code;
        this.remainingSize += this.codeSize;
        while (this.remainingSize >= 8) {
            this.remainingSize -= 8;
            super.write(this.remainingPart >> this.remainingSize);
            this.remainingPart &= (1 << this.remainingSize) - 1;
        }
    }

    private void setCodeSize(int newSize) {
        this.codeSize = newSize;
        this.maxCodes = 1 << this.codeSize;
    }
}

