/*
 * IndexSearch.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:40 $
 * $Id: IndexSearch.java,v 1.1 2007/12/20 14:37:40 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */

package org.gcube.indexmanagement.common;

import java.net.URI;
import java.util.ArrayList;

import org.gcube.indexmanagement.resourceregistry.RRadaptor;

/**
 * Interface for Index Searching Wrapper Classes
 */
public interface IndexSearch {

    /**
     * Opens the index for search operations
     * 
     * @param indexDir
     * 			the base directory where indices are stored
     * @param indexName
     *            name of the index
     * @throws IndexException -
     *             an error opening the index
     */
    public void openIndex(String indexDir, String indexName) throws IndexException;

    /**
     * Updates the index.
     * 
     * @throws IndexException -
     *             an error updating the index
     * 
     */
    public void updateIndex() throws IndexException;

    /**
     * Closes the previously opened index
     * 
     * @throws IndexException -
     *             an error closing the index
     */
    public void closeIndex() throws IndexException;

    /**
     * Updates the IndexSearch' state object
     * 
     * @throws IndexException -
     *             an error setting the IndexType
     */
    public void setIndexType(FullTextIndexType idxType) throws IndexException;

    /**
     * Fills the RSClient with results from executing the queryString on an
     * index (Lucene only).
     * <p>
     * Setting client to null will print results to system.out.
     * 
     * @param queryString
     *            executed query string
     * @param isComplete
     *            indicates if the results must contain the full payload 
     * @return number of hits in index (may differe from records in resultset).
     * @throws IndexException -
     *             an error executing the query
     */
    public URI executeQuery(String queryString, boolean isComplete) throws IndexException;
    
    /**
     * Fills the RSClient with results from executing the queryString on an
     * index (Lucene only).
     * <p>
     * Setting client to null will print results to system.out.
     * 
     * @param presentable
     * 			  the field Names of the fields that are presentable in this index
     * @param searchable
     * 			  the field Names of the fields that are searchable in this index
     * @param queryString
     *            executed query string
     * @param isComplete
     *            indicates if the results must contain the full payload 
     * @return number of hits in index (may differe from records in resultset).
     * @throws IndexException -
     *             an error executing the query
     */
    public URI executeCqlQuery(ArrayList<String> presentable, ArrayList<String> searchable, 
    		String queryString, boolean isComplete, RRadaptor adaptor) throws Exception;

}
