package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.RandomAccessFile;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FileHelper;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.ApproximationFileEntry;

/**
 * Random access helper
 * 
 * @author diligent
 */
public class ApproximationFileRandomAccess {
	/**
	 * The Loger of the class
	 */
	private static Logger log = Logger.getLogger(ApproximationFileRandomAccess.class);
	/**
	 * The VAFile header params
	 */
	private VAFileParams params=null;
	/**
	 * Teh file pointer
	 */
	private RandomAccessFile rand=null;
	/**
	 * The IOHelper
	 */
	private IOHelper helper=null;
	
	/**
	 * Creates a new instance
	 * 
	 * @param params The VAFile header params
	 * @throws Exception An error
	 */
	public ApproximationFileRandomAccess(VAFileParams params) throws Exception{
		try{
			this.params=params;
			this.helper=new IOHelper();
			helper.setIDLength(params.getIDLength());
			helper.setVectorLength(params.getVectorLength());
		}catch(Exception e){
			log.error("Could not initialize reader. throing Exception",e);
			throw new Exception("Could not initialize reader");
		}
	}
	
	/**
	 * Opens 
	 * 
	 * @throws Exception An error
	 */
	public void open() throws Exception{
		try{
			rand=new RandomAccessFile(FileHelper.getVAFApproxFile(params.getStorage(),params.getIndexID()),"rw");
		}catch(Exception e){
			log.error("Could not open reader. throing Exception",e);
			throw new Exception("Could not open reader");
		}
	}
	
	/**
	 * Moves to the specified entry
	 * 
	 * @param recNum The number of entry
	 * @throws Exception An error
	 */
	public void moveTo(long recNum) throws Exception{
		try{
			rand.seek(recNum*params.getApproximationEntryLength());
		}catch(Exception e){
			log.error("Could not move to record "+recNum+". throing Exception",e);
			throw new Exception("Could not move to record "+recNum);
		}
	}
	
	/**
	 * Writer the specified entry
	 * 
	 * @param entry The entry
	 * @throws Exception An error
	 */
	public void write(ApproximationFileEntry entry) throws Exception{
		try{
			if(entry.getBitString().length!=params.getVectorLength()){
				throw new Exception("new entry dimentions don't match");
			}
			this.helper.writeApproximation(entry,rand);
		}catch(Exception e){
			log.error("Could not write entry. throing Exception",e);
			throw new Exception("Could not write entry");
		}
	}
	
	/**
	 * Reads an entry
	 * 
	 * @return The entry
	 */
	public ApproximationFileEntry read(){
		return helper.readApproximation(rand);
	}
	
	/**
	 * Closes
	 * 
	 * @throws Exception An error
	 */
	public void close() throws Exception{
		try{
			rand.close();
		}catch(Exception e){
			log.error("Could not close. throing Exception",e);
			throw new Exception("Could not close");
		}
	}
}
