package org.gcube.indexmanagement.common;

import java.util.Vector;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLTokenReplacer {
	
	private static String AMP = "&amp;";
	private static String LT = "&lt;";
	private static String GT = "&gt;";
	private static String APOS = "&apos;";
	private static String QUOT = "&quot;";
	private static String NULL = "&#x0;";
	private static String SLASH_R = "&#x0D;";
	private static char AMPReplace = '&';
	private static char LTReplace = '<';
	private static char GTReplace = '>';
	private static char APOSReplace = '\'';
	private static char QUOTReplace = '\"';
	private static char NULLReplace = '\0';
	private static char SLASH_RReplace = '\r';
	
	private static int charBlockSize = 200000;
	private static char basicChar = '&';
	@SuppressWarnings("unused")
	private static final Logger logger = LoggerFactory.getLogger(XMLTokenReplacer.class);
	
	
	public static String XMLResolve(String str) {
		String[] entities = new String[] { LT, GT, APOS, QUOT, SLASH_R, NULL, AMP };
		char[] chars = new char[] { LTReplace, GTReplace, APOSReplace, QUOTReplace, SLASH_RReplace, NULLReplace, AMPReplace };
	
		int max = maxLength(entities);
		Vector<String> strs = new Vector<String>();
		int lastIndex = -1;
		int start = 0;
		for(int i=0; i<(1 + str.length()/charBlockSize); i++)
		{
			lastIndex += charBlockSize;
			if((lastIndex+max) >= str.length())
			{
				strs.add(str.substring(start));
				break;
			}else{
				for(int j=0; j<max; j++)
					if(str.charAt(lastIndex) == basicChar)
					{
						lastIndex--;
						break;
					//if the loop is going to exit the next char won't be checked
					}else if(j < (max-1))
						lastIndex++;
				
				//lastIndex is the last char that was checked
				strs.add(str.substring(start,lastIndex+1));
			}
			start = lastIndex+1;
		}
		str = null;
		
		int size = strs.size();
		for(int i=0; i<size; i++)
			for(int j=0; j<entities.length; j++)
				strs.add(i, strs.remove(i).replaceAll(entities[j], new Character(chars[j]).toString()));
			
		StringBuffer sb = new StringBuffer();
		for(int i=0; i<size; i++)
		{
			String tmp = strs.remove(0);
			if(tmp != null)
				sb.append(tmp);
			tmp = null;
		}
		
		//log statistics for memory usage
		//Runtime rt = Runtime.getRuntime();
		//logger.debug("After Resolve---Max Memory: "+rt.maxMemory()+", Total Memory: "+rt.totalMemory()+", Free Memory: "+rt.freeMemory());
		
		return sb.toString();
	}
	
	@SuppressWarnings("unused")
	public static String XMLUnresolve(String str) {
		String[] entities = new String[] { AMP, LT, GT, APOS, QUOT, NULL, SLASH_R };
		char[] chars = new char[] { AMPReplace, LTReplace, GTReplace, APOSReplace, QUOTReplace, NULLReplace, SLASH_RReplace };
	
		int max = maxLength(entities);
		Vector<String> strs = new Vector<String>();
		int lastIndex = -1;
		int start = 0;
		for(int i=0; i<(1 + str.length()/charBlockSize); i++)
		{
			lastIndex += charBlockSize;
			if(lastIndex >= str.length())
			{
				strs.add(str.substring(start));
				break;
			}else{
				strs.add(str.substring(start,lastIndex+1));
			}
			start = lastIndex+1;
		}
		str = null;
		
		int size = strs.size();
		for(int i=0; i<size; i++)
			for(int j=0; j<entities.length; j++)
				strs.add(i, strs.remove(i).replaceAll(new Character(chars[j]).toString(), entities[j]));
		
		StringBuffer sb = new StringBuffer();
		for(int i=0; i<size; i++)
		{
			String tmp = strs.remove(0);
			if(tmp != null)
				sb.append(tmp);
			tmp = null;
		}
		//log statistics for memory usage
		//Runtime rt = Runtime.getRuntime();
		//logger.debug("After Unresolve---Max Memory: "+rt.maxMemory()+", Total Memory: "+rt.totalMemory()+", Free Memory: "+rt.freeMemory());
		
		return sb.toString();
	}
	
	public static int maxLength(String[] array)
	{
		int max = array[0].length();
		for(int i=1; i<array.length; i++)
			if(array[i].length() > max)
				max  = array[i].length();
		
		return max;			
	}

}
