/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextractor.extractors;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.utils.Locators;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.gcube.rest.index.client.exceptions.IndexException;
import org.gcube.semantic.annotator.AnnotationBase;
import org.gcube.semantic.annotator.SMARTFISH_EntityCollection;
import org.gcube.textextractor.extractors.CSVExtractor;
import org.gcube.textextractor.extractors.HTMLExtractor;
import org.gcube.textextractor.extractors.XMLExtractor;
import org.gcube.textextractor.helpers.IndexHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Test {
    private static final Logger logger = LoggerFactory.getLogger(Test.class);
    private static String base_folder = System.getProperty("user.home") + "/";
    private static String rootFolder = base_folder + "Smartfish/";
    private static String xmlRootFolder = rootFolder + "rowsets/new/";
    private static String annotation_filename_prefix = "annotation_collection";

    public static void main(String[] args) throws IOException {
        String path = "";
        String outputFilename = "";
        long starttime = System.currentTimeMillis();
        path = rootFolder + "firms";
        outputFilename = xmlRootFolder + "smartfish_xml_rowsets.xml";
        XMLExtractor xml = new XMLExtractor();
        xml.extractInfoAndWriteToFile(path, outputFilename);
        AnnotationBase.getInstance().dump(AnnotationBase.FIRMS_annotation_file_name);
        SMARTFISH_EntityCollection.getInstance().toFile();
        long endtime = System.currentTimeMillis();
        logger.info("time for XML : " + (double)(endtime - starttime) / 1000.0 + " secs");
        starttime = System.currentTimeMillis();
        path = rootFolder + "csvs";
        outputFilename = xmlRootFolder + "smartfish_csv_rowsets.xml";
        CSVExtractor csv = new CSVExtractor();
        csv.extractInfoAndWriteToFile(path, outputFilename);
        AnnotationBase.getInstance().dump(AnnotationBase.STATBASE_annotation_file_name);
        SMARTFISH_EntityCollection.getInstance().toFile();
        endtime = System.currentTimeMillis();
        logger.info("time for CSV : " + (double)(endtime - starttime) / 1000.0 + " secs");
        starttime = System.currentTimeMillis();
        path = rootFolder + "wiofish_pages/encoded";
        outputFilename = xmlRootFolder + "wiofish_html_rowsets.xml";
        HTMLExtractor html = new HTMLExtractor();
        html.extractInfoAndWriteToFile(path, outputFilename);
        AnnotationBase.getInstance().dump(AnnotationBase.WIOFISH_annotation_file_name);
        SMARTFISH_EntityCollection.getInstance().toFile();
        endtime = System.currentTimeMillis();
        logger.info("time for HTML : " + (double)(endtime - starttime) / 1000.0 + " secs");
    }

    public static void feed(String[] args) throws IOException, GRS2WriterException, IndexException {
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig("jazzman.di.uoa.gr", new ArrayList(), true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
        RecordDefinition[] defs = null;
        defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition("Rowset")})};
        final RecordWriter writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), defs, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor, 1L, TimeUnit.DAYS);
        String path = null;
        String outputFilename = null;
        String scope = "/gcube/devsec";
        IndexHelper.createCluster("/gcube/devsec", 1);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        new Thread(){

            @Override
            public void run() {
                String uri = Test.getOutput((RecordWriter<GenericRecord>)writer);
                try {
                    IndexHelper.feedIndex("/gcube/devsec", uri);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        path = "/home/alex/Smartfish/StatBase.1.csv";
        outputFilename = "/home/alex/Smartfish/rowsets/smartfish_all_rowsets.xml";
        CSVExtractor csv = new CSVExtractor();
        csv.extractInfoAndWriteToRS(path, (RecordWriter<GenericRecord>)writer);
        path = "/home/alex/Smartfish/wiofish_pages/encoded";
        outputFilename = "/home/alex/Smartfish/rowsets/smartfish_all_rowsets.xml";
        HTMLExtractor html2 = new HTMLExtractor();
        html2.extractInfoAndWriteToRS(path, (RecordWriter<GenericRecord>)writer);
        path = "/home/alex/Smartfish/firms/";
        outputFilename = "/home/alex/Smartfish/rowsets/smartfish_all_rowsets.xml";
        XMLExtractor xml = new XMLExtractor();
        xml.extractInfoAndWriteToRS(path, (RecordWriter<GenericRecord>)writer);
        writer.close();
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String getOutput(RecordWriter<GenericRecord> writer) {
        try {
            URI TCPLocator = Locators.localToTCP((URI)writer.getLocator());
            return TCPLocator.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

