/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.gcube.semantic.annotator;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.resultset.ResultSetMem;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.sparql.util.ResultSetUtils;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.ArrayUtils;
import org.apache.jena.riot.RiotWriter;
import org.apache.jena.web.DatasetGraphAccessorHTTP;
import static org.gcube.semantic.annotator.FLOD_EntityCollection.prefixes;
import org.gcube.semantic.annotator.utils.MD5Generator;

/**
 *
 * @author Claudio Baldassarre <c.baldassarre@me.com>
 */
public class SMARTFISH_EntityCollection {

    private static SMARTFISH_EntityCollection instance;
    private static DatasetGraph entityCollection_locale = DatasetGraphFactory.createMem();
    private final Node chimaeraKBnode = NodeFactory.createURI("http://smartfish.d4science.org/entities");
    private static Model m = ModelFactory.createDefaultModel();

//    private String knowledgeBase_file_path = "/home/alex/";
//    private String knowledgeBase_file_path = "/Users/cbaldassarre/NetBeansProjects/SMARTFISH/smartfish-doc-processor/";
//    private String knowledgeBase_filename = "smartfish_kb.nq";
//    private static Model unionModel = ModelFactory.createDefaultModel();
    private SMARTFISH_EntityCollection() {
        DatasetGraphAccessorHTTP kbAccressor = new DatasetGraphAccessorHTTP("http://dl051.madgik.di.uoa.gr:3030/chimaera_kb_update/data");

        Graph chimaeraGraph = kbAccressor.httpGet(chimaeraKBnode);
        if (chimaeraGraph == null) {
            chimaeraGraph = Graph.emptyGraph;
        }
        m.add(ModelUtils.triplesToStatements(GraphUtil.findAll(chimaeraGraph), m));
    }

    public static SMARTFISH_EntityCollection getInstance() {
        if (instance == null) {
            instance = new SMARTFISH_EntityCollection();
        }
        return instance;
    }

    private void addInstance(String en_name, String fr_name, String typeURI) throws NoSuchAlgorithmException {
        if ("".equals(en_name)) {
            return;
        }
        System.out.println("Adding entity to smartfish_kb for : " + en_name);
        Node graphNode = NodeFactory.createURI("http://smartfish.d4science.org/entities");
        Node typeNode = NodeFactory.createURI(typeURI);
        String entity_uri = "http://smartfish.d4science.org/entities/" + typeNode.getLocalName().toLowerCase() + "/" + MD5Generator.getMD5Sum(en_name);
        Node entity_node = NodeFactory.createURI(entity_uri);
        entityCollection_locale.add(graphNode, entity_node, RDF.type.asNode(), typeNode);
        entityCollection_locale.add(graphNode, entity_node, RDFS.label.asNode(), NodeFactory.createLiteral(en_name, "en", null));
        m.add(m.createResource(entity_uri), RDF.type, m.createResource(typeURI));
        m.add(m.createResource(entity_uri), RDFS.label, m.createLiteral(en_name, "en"));
        if (fr_name != null && !fr_name.isEmpty()) {
            entityCollection_locale.add(graphNode, entity_node, RDFS.label.asNode(), NodeFactory.createLiteral(fr_name, "fr", null));
            m.add(m.createResource(entity_uri), RDFS.label, m.createLiteral(fr_name, "fr"));
        }
    }

    public File toFile() throws FileNotFoundException {
        File f = new File("smartfish_kb.nq");
        FileOutputStream fos = new FileOutputStream(f);
        RiotWriter.createNQuads().write(fos, entityCollection_locale, null, null, entityCollection_locale.getContext());
        return f;
    }

    public File dump(File f) throws FileNotFoundException {
//        File f = new File(knowledgeBase_file_path + knowledgeBase_filename);
        FileOutputStream fos = new FileOutputStream(f);
        RiotWriter.createNQuads().write(fos, entityCollection_locale, null, null, entityCollection_locale.getContext());
        entityCollection_locale.deleteAny(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        return f;
    }

    public String getURI(String name, String resType) {
        ResultSet rs = getURIrs(name, resType);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON(bos, rs);
        return bos.toString();
    }

    public ResultSet getURIrs(String name, String resType) {
        ResultSet rs = ce4name(name, resType);
        if (rs.getRowNumber() <= 0) {
            System.out.println("SMARTFISH entity collection - NO URI FOUND for : " + name);
            addIfNotThere(name, resType);
            rs = ce4name(name, resType);
        }
        return rs;
    }

    public String getURI(String names[], String resType) {
        ResultSet[] rsList = new ResultSet[names.length];
        for (int i = 0; i < names.length; i++) {
            String name = names[i];
            if (!name.isEmpty()) {
                ResultSet rs = ce4name(name, resType);
                if (rs.getRowNumber() <= 0) {
                    System.out.println("SMARTFISH entity collection - NO URI FOUND for : " + name);
                    addIfNotThere(name, resType);
                    rs = ce4name(name, resType);
                }
                rsList[i] = rs;
            }
        }
        ResultSet rsm = ResultSetUtils.union(rsList);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON(bos, rsm);
        return bos.toString();
    }

    private ResultSet ce4name(String name, String resType) {
        String sanitized_name = sanitize(name);
        String BGP = "{"
                //                + "graph <http://smartfish.d4science.org/entities>{"
                + "?uri rdf:type <" + resType + "> ."
                + "?uri rdfs:label ?label . "
                + "BIND (str(?label) as ?label_str) "
                + "BIND (lang(?label) as ?lang) "
                + "filter(?label_str = '" + sanitized_name + "') "
                + "filter(?lang = 'en' || ?lang = 'fr')"
                //                + "}"
                + "}";
//        String queryAsk = "ASK "+ BGP;
//        boolean exisist = QueryExecutionFactory.create(prefixes + queryAsk, m).execAsk();
//        if(exisist){
        String querySelect = "  SELECT distinct ?uri ?label_str ?lang WHERE " + BGP;
        return QueryExecutionFactory.create(prefixes + querySelect, m).execSelect();
//        }
//        else
//            return null;

    }

    private boolean ask_ce4name(String name, String resType) {
        name = sanitize(name);
        System.out.println("SMARTFISH entity collection ask for : " + name);
        String query
                = "ASK "
                //                + "graph <http://smartfish.d4science.org/entities>{"
                + "{"
                + "?uri rdf:type <" + resType + "> ."
                + "?uri rdfs:label ?label . "
                + "BIND (str(?label) as ?label_str) "
                + "BIND (lang(?label) as ?lang) "
                + "filter(?label_str = '" + name + "') "
                + "filter(?lang = 'en' || ?lang = 'fr')"
                + "}";
        return QueryExecutionFactory.create(prefixes + query, m).execAsk();

    }

    public String getLabel(String uri, String lang) {
        ResultSet rs = label4uri(uri, lang);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON(bos, rs);
        return bos.toString();
    }

    public String getLabel(List<String> entitiesURIs, String lang) {
        ResultSet[] rsList = new ResultSet[entitiesURIs.size()];
        ResultSetMem rsm = new ResultSetMem();
        for (int i = 0; i < entitiesURIs.size(); i++) {
            String uri = entitiesURIs.get(i);
            ResultSet rs = label4uri(uri, lang);
        }
        if (rsList.length > 0) {
            rsm = (ResultSetMem) ResultSetUtils.union(rsList);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON(bos, rsm);
        return bos.toString();
    }

    private ResultSet label4uri(String uri, String lang) {
        String filter = "";
        String select = " select distinct ?uri ?label_str ?lang";
        String where = " where ";
//        String graph = " graph <http://smartfish.d4science.org/entities>";
        String gbpattern
                = "BIND (IRI('" + uri + "') as ?uri) "
                + " ?uri rdfs:label ?label_lang . "
                + "BIND (str(?label_lang) as ?label_str) "
                + "BIND (lang(?label_lang) as ?lang) ";

        if (!"".equals(lang)) {
            filter += "filter(?lang = '" + lang + "')";
        } else {
            filter += "filter(?lang = 'en' || ?lang = 'fr' || ?lang = 'la')";
        }
        Query q = QueryFactory.create(prefixes + select + where + "{" + gbpattern + filter + " }");
        return QueryExecutionFactory.create(q, m).execSelect();
    }

    private String sanitize(String name) {
        if (name.contains("/")) {
            name = name.split("/")[0].trim();
        }
        name = name.replace("'", "\\'");
        return name;
    }

    public static void main(String[] args) throws FileNotFoundException {
//        SMARTFISH_EntityCollection.getInstance();
//        String uri = SMARTFISH_EntityCollection.getInstance().getURI("No Vessel Used / Aucun navire utilisé", "http://www.fao.org/figis/flod/onto/vessel.owl#VesselCode");
        ResultSet ce4name = SMARTFISH_EntityCollection.getInstance().ce4name("Vanderbilt's chromis", "http://www.fao.org/figis/flod/onto/linneanspecies.owl#SpeciesCode");
        System.out.println(ResultSetFormatter.asText(ce4name));
    }

    private String addIfNotThere(String name, String resType) {
        String name_en = "";
        String name_fr = "";
        try {
            String[] names = name.split("/");
            name_en = names[0];
            try {
                name_fr = names[1];
            } catch (Exception e) {
            }
            addInstance(name_en.trim(), name_fr.trim(), resType);
//            makeUnionModel();
        } catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(SMARTFISH_EntityCollection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return name_en;
    }

    private String[] orderByPresence(String[] names, String type) {
        ArrayList<String> list = new ArrayList();
        for (int i = 0; i < names.length; i++) {
            String name = names[i];
            if (!name.isEmpty()) {

                if (!ask_ce4name(name, type)) {
                    list.add(0, name);
                } else {
                    list.add(name);
                }
            }
        }
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }
}
