/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextractor.helpers;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeTraverser;
import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.gcube.semantic.annotator.FLOD_EntityCollection;
import org.gcube.semantic.annotator.SMARTFISH_EntityCollection;
import org.gcube.textextractor.entities.Binding;
import org.gcube.textextractor.entities.CE4NameResponse;
import org.gcube.textextractor.entities.ShortenCE4NameResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractorHelper {
    private static final Logger logger = LoggerFactory.getLogger(ExtractorHelper.class);

    public static String createRowseFromFields(String documentID, String collectionID, String idxType, String lang, Map<String, String> fields) {
        StringBuilder strBuf = new StringBuilder();
        if (lang == null) {
            lang = "unknown";
        }
        strBuf.append("<ROWSET colID=\"" + collectionID + "\" idxType=\"" + idxType + "\" lang=\"" + lang + "\">\n");
        strBuf.append("\t<ROW>\n");
        for (Map.Entry<String, String> field : fields.entrySet()) {
            String name = field.getKey();
            String value = field.getValue();
            if (name.equals("language") || name.equals("documentID") || value == null || value.length() <= 0) continue;
            strBuf.append("\t\t<FIELD lang=\"" + lang + "\" name=\"" + name + "\">" + StringEscapeUtils.escapeXml((String)value) + "</FIELD>\n");
        }
        strBuf.append("\t\t<FIELD name=\"ObjectID\">" + StringEscapeUtils.escapeXml((String)documentID) + "</FIELD>\n");
        strBuf.append("\t</ROW>\n");
        strBuf.append("</ROWSET>\n");
        return strBuf.toString();
    }

    public static String fileContent(String filename) throws IOException {
        return Files.toString((File)new File(filename), (Charset)Charsets.UTF_8);
    }

    public static String removeEmptyLines(String text) {
        return text.replaceAll("\\s+", " ");
    }

    public static List<String> covertToStringList(String str) {
        return Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)str);
    }

    public static String covertToString(Collection<String> col) {
        return Joiner.on((String)", ").skipNulls().join(col);
    }

    public static void main(String[] args) {
        logger.info(ExtractorHelper.covertToString(Lists.newArrayList((Object[])new String[]{"a"})));
    }

    public static List<String> getFilenames(String path) throws FileNotFoundException {
        ArrayList filenames = Lists.newArrayList();
        File pathFile = new File(path);
        TreeTraverser tr = Files.fileTreeTraverser();
        for (File file : tr.children((Object)pathFile)) {
            if (!file.isFile()) continue;
            filenames.add(file.getAbsolutePath());
        }
        return filenames;
    }

    public static String constructURL(String name, String res_type) throws UnsupportedEncodingException {
        String url = "http://www.fao.org/figis/flod/askflod/json/ce4name.jsp";
        String params = "name=" + URLEncoder.encode(name, "UTF-8") + "&" + "res_type=" + URLEncoder.encode(res_type, "UTF-8");
        return url + "?" + params;
    }

    public static String constructURL(List<String> names, String res_type) throws UnsupportedEncodingException {
        String url = "http://www.fao.org/figis/flod/askflod/json/ce4name.jsp";
        String params = "";
        for (String name : names) {
            params = params + "name=" + URLEncoder.encode(name, "UTF-8") + "&";
        }
        params = params + "res_type=" + URLEncoder.encode(res_type, "UTF-8");
        return url + "?" + params;
    }

    public static List<ShortenCE4NameResponse> getJsonResponse(String url) throws Exception {
        logger.info("getting json response for url : " + url);
        String json = ExtractorHelper.getText(url);
        logger.info("json response for url : " + url + " is : " + json);
        return ExtractorHelper.parseJsonRequest(json);
    }

    public static List<ShortenCE4NameResponse> parseJsonRequest(String json) throws Exception {
        Gson gson = new Gson();
        CE4NameResponse annotationResponse = (CE4NameResponse)gson.fromJson(json, CE4NameResponse.class);
        ArrayList<ShortenCE4NameResponse> speciesCE4Name = new ArrayList<ShortenCE4NameResponse>();
        for (Binding b : annotationResponse.results.bindings) {
            speciesCE4Name.add(new ShortenCE4NameResponse(b));
        }
        return speciesCE4Name;
    }

    public static String transformList(List<ShortenCE4NameResponse> speciesCE4Name) {
        return ExtractorHelper.transformList(speciesCE4Name, null, null);
    }

    public static String transformList(List<ShortenCE4NameResponse> speciesCE4Name, String lang) {
        return ExtractorHelper.transformList(speciesCE4Name, null, lang);
    }

    public static String transformList(List<ShortenCE4NameResponse> speciesCE4Name, String documentURI, String lang) {
        HashSet<String> uris = new HashSet<String>();
        for (ShortenCE4NameResponse resp : speciesCE4Name) {
            uris.add(resp.uri);
        }
        ArrayList transformedList = new ArrayList();
        for (String uri : uris) {
            HashMap<String, String> transformed = new HashMap<String, String>();
            if (lang == null || "".equals(lang) || lang.equalsIgnoreCase("en")) {
                transformed.put("label_en", "");
            }
            if (lang == null || "".equals(lang) || lang.equalsIgnoreCase("fr")) {
                transformed.put("label_fr", "");
            }
            if (lang == null || "".equals(lang) || lang.equalsIgnoreCase("la")) {
                transformed.put("label_la", "");
            }
            for (ShortenCE4NameResponse resp : speciesCE4Name) {
                if (!resp.uri.equalsIgnoreCase(uri) || lang != null && !"".equals(lang) && !lang.equalsIgnoreCase(resp.lang)) continue;
                transformed.put("label_" + resp.lang, resp.label);
            }
            transformed.put("uri", uri);
            if (documentURI != null) {
                transformed.put("doc_uri", documentURI);
            }
            transformedList.add(transformed);
        }
        return new Gson().toJson(transformedList);
    }

    public static List<Map<String, String>> transformListToCE4Names(List<ShortenCE4NameResponse> speciesCE4Name) {
        HashSet<String> uris = new HashSet<String>();
        for (ShortenCE4NameResponse resp : speciesCE4Name) {
            uris.add(resp.uri);
        }
        ArrayList<Map<String, String>> transformedList = new ArrayList<Map<String, String>>();
        for (String uri : uris) {
            HashMap<String, String> transformed = new HashMap<String, String>();
            transformed.put("label_en", "");
            transformed.put("label_fr", "");
            transformed.put("label_la", "");
            for (ShortenCE4NameResponse resp : speciesCE4Name) {
                if (!resp.uri.equalsIgnoreCase(uri)) continue;
                transformed.put("label_" + resp.lang, resp.label);
            }
            transformed.put("uri", uri);
            transformedList.add(transformed);
        }
        return transformedList;
    }

    public static String queryURI(String name, String res_type) throws Exception {
        if (name == null || name.trim().length() == 0) {
            throw new Exception("empty name given");
        }
        String json = "";
        json = res_type.indexOf("smartfish.d4science.org") != -1 ? SMARTFISH_EntityCollection.getInstance().getURI(name, res_type) : FLOD_EntityCollection.getInstance().getURI(name, res_type);
        return ExtractorHelper.transformList(ExtractorHelper.parseJsonRequest(json));
    }

    public static String queryListURI(List<String> names, String res_type) throws Exception {
        if (names == null || names.size() == 0) {
            throw new Exception("empty name given");
        }
        String[] namesArr = new String[names.size()];
        namesArr = names.toArray(namesArr);
        String json = "";
        json = res_type.indexOf("smartfish.d4science.org") != -1 ? SMARTFISH_EntityCollection.getInstance().getURI(namesArr, res_type) : FLOD_EntityCollection.getInstance().getURI(namesArr, res_type);
        return ExtractorHelper.transformList(ExtractorHelper.parseJsonRequest(json));
    }

    public static String queryCountry(String name) throws Exception {
        return ExtractorHelper.queryURI(name, "http://www.fao.org/figis/flod/onto/flagstate.owl#FlagStateCode");
    }

    public static String queryCountry(List<String> names) throws Exception {
        return ExtractorHelper.queryListURI(names, "http://www.fao.org/figis/flod/onto/flagstate.owl#FlagStateCode");
    }

    public static String queryGear(String name) throws Exception {
        return ExtractorHelper.queryURI(name, "http://www.fao.org/figis/flod/onto/gear.owl#GearCode");
    }

    public static String queryVessel(String name) throws Exception {
        return ExtractorHelper.queryURI(name, "http://www.fao.org/figis/flod/onto/vessel.owl#VesselCode");
    }

    public static String querySpecies(String name) throws Exception {
        return ExtractorHelper.queryURI(name, "http://www.fao.org/figis/flod/onto/linneanspecies.owl#SpeciesCode");
    }

    public static String querySpecies(List<String> names) throws Exception {
        return ExtractorHelper.queryListURI(names, "http://www.fao.org/figis/flod/onto/linneanspecies.owl#SpeciesCode");
    }

    public static String queryAuthority(String name) throws Exception {
        throw new Exception("not implemented");
    }

    public static String querySeasonality(List<String> months) throws Exception {
        return ExtractorHelper.queryListURI(months, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#Season");
    }

    public static String queryWaterArea(List<String> months) throws Exception {
        return ExtractorHelper.queryListURI(months, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#water_area");
    }

    public static String queryLandArea(List<String> months) throws Exception {
        return ExtractorHelper.queryListURI(months, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#land_area");
    }

    public static String queryManagement(String management) throws Exception {
        return ExtractorHelper.queryURI(management, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#Management");
    }

    public static String queryManagement(List<String> managements) throws Exception {
        return ExtractorHelper.queryListURI(managements, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#Management");
    }

    public static String querySector(List<String> sectors) throws Exception {
        return ExtractorHelper.queryListURI(sectors, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#Sector");
    }

    public static String queryExploitationStatus(String status) throws Exception {
        return ExtractorHelper.queryURI(status, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#ExploitationStatus");
    }

    public static String queryExploitationStatus(List<String> statuses) throws Exception {
        return ExtractorHelper.queryListURI(statuses, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#ExploitationStatus");
    }

    public static String queryAccessControl(List<String> accessControls) throws Exception {
        return ExtractorHelper.queryListURI(accessControls, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#AccessControl");
    }

    public static String queryFishingControl(List<String> fishingControls) throws Exception {
        return ExtractorHelper.queryListURI(fishingControls, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#FishingControl");
    }

    public static String queryEnforcementMethod(List<String> enforcementMethods) throws Exception {
        return ExtractorHelper.queryListURI(enforcementMethods, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#EnforcementMethod");
    }

    public static String queryAccessRightApplicant(List<String> applicants) throws Exception {
        return ExtractorHelper.queryListURI(applicants, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#LegalEntity");
    }

    public static String queryOwnershipOfAccessRight(List<String> owners) throws Exception {
        return ExtractorHelper.queryListURI(owners, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#LegalEntity");
    }

    public static String queryTechnologyInUse(List<String> technologies) throws Exception {
        return ExtractorHelper.queryListURI(technologies, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#Technology");
    }

    public static String queryIncome(List<String> incomes) throws Exception {
        return ExtractorHelper.queryListURI(incomes, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#IncomeSource");
    }

    public static String queryPostHarvestingProcess(List<String> processes) throws Exception {
        return ExtractorHelper.queryListURI(processes, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#PostHarvestingProcess");
    }

    public static String queryRapresentativeForDecisionMaking(List<String> representatives) throws Exception {
        return ExtractorHelper.queryListURI(representatives, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#Authority");
    }

    public static String queryManagementIndicators(List<String> indicators) throws Exception {
        return ExtractorHelper.queryListURI(indicators, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#StatisticalIndicator");
    }

    public static String queryFinancingManagement(List<String> financingMgmt) throws Exception {
        return ExtractorHelper.queryListURI(financingMgmt, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#Authority");
    }

    public static String queryMarkets(List<String> markets) throws Exception {
        return ExtractorHelper.queryListURI(markets, "http://smartfish.d4science.org/ontology/1.0/smartfish.owl#MarketPlace");
    }

    public static String getText(String url) throws Exception {
        String inputLine;
        URL website = new URL(url);
        URLConnection connection = website.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    public static void enrichListField(Map<String, String> record, Map<String, String> enrichedRecord, Map<String, List<String>> uris, String fieldName, QueryWrapperList wrapper) {
        long starttime = System.currentTimeMillis();
        try {
            List<String> stringList;
            String jsonURI = null;
            if (record.get(fieldName) != null && record.get(fieldName).trim().length() > 0 && (stringList = ExtractorHelper.covertToStringList(record.get(fieldName))).size() > 0) {
                jsonURI = wrapper.doCall(stringList);
                uris.put(fieldName + "_uris", ShortenCE4NameResponse.getURIFromJSON(jsonURI));
                enrichedRecord.put(fieldName + "_uris", jsonURI);
            }
        }
        catch (Exception e) {
            logger.warn("Error processing " + fieldName + " : " + record.get(fieldName), (Throwable)e);
        }
        long endtime = System.currentTimeMillis();
        logger.info("query " + fieldName + " : " + (double)(endtime - starttime) / 1000.0 + " sec");
    }

    public static void enrichSimpleField(Map<String, String> record, Map<String, String> enrichedRecord, Map<String, List<String>> uris, String fieldName, QueryWrapperSimple wrapper) {
        long starttime = System.currentTimeMillis();
        try {
            String jsonURI = null;
            if (record.get(fieldName) != null && record.get(fieldName).trim().length() > 0) {
                jsonURI = wrapper.doCall(record.get(fieldName));
                uris.put(fieldName + "_uris", ShortenCE4NameResponse.getURIFromJSON(jsonURI));
                enrichedRecord.put(fieldName + "_uris", jsonURI);
            }
        }
        catch (Exception e) {
            logger.warn("Error processing " + fieldName + " : " + record.get(fieldName), (Throwable)e);
        }
        long endtime = System.currentTimeMillis();
        logger.info("query " + fieldName + " : " + (double)(endtime - starttime) / 1000.0 + " sec");
    }

    public static abstract class QueryWrapperSimple {
        public abstract String doCall(String var1) throws Exception;
    }

    public static abstract class QueryWrapperList {
        public abstract String doCall(List<String> var1) throws Exception;
    }
}

