/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextractor.extractors;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.gcube.semantic.annotator.AnnotationBase;
import org.gcube.semantic.annotator.utils.ANNOTATIONS;
import org.gcube.textextractor.entities.ExtractedEntity;
import org.gcube.textextractor.entities.RestExtractorEntities;
import org.gcube.textextractor.extractors.InformationExtractor;
import org.gcube.textextractor.helpers.ExtractorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTServiceExtractor
extends InformationExtractor {
    private static final Logger logger = LoggerFactory.getLogger(RESTServiceExtractor.class);
    private static Gson gson = new Gson();
    private static List<RestExtractorEntities.CountryObj> countries;

    @Override
    public String convertInfoToRowset(Map<String, String> info) {
        String documentID = info.get("documentID");
        info.remove("documentID");
        return ExtractorHelper.createRowseFromFields(documentID, "faoCollection", "SmartfishFT", info.get("language"), info);
    }

    @Override
    public Map<String, String> extractFieldsFromFile(String filename) throws Exception {
        String docID = filename;
        HashMap document = Maps.newHashMap();
        document.put("country", this.getCountryName(filename));
        document.put("provenance", "Statbase");
        try {
            List<RestExtractorEntities.IntermediateCriterionObj> intermediateCriteria = RESTServiceExtractor.getCriteria(filename);
            this.includeCriteriaInDocument(intermediateCriteria, document, docID);
            List<RestExtractorEntities.IntermediateStatisticObj> intermediateStatistics = this.getStatistics(filename);
            this.includeStatisticsInDocument(intermediateStatistics, document);
        }
        catch (Exception e) {
            logger.error("error while getting the criteria for : " + filename, (Throwable)e);
            return document;
        }
        return document;
    }

    @Override
    public Map<String, String> enrichRecord(Map<String, String> record, String filename) {
        HashMap enrichedRecord = Maps.newHashMap();
        HashMap uris = Maps.newHashMap();
        String docURI = filename;
        enrichedRecord.put("documentID", docURI);
        enrichedRecord.putAll(record);
        ExtractorHelper.enrichListField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#species"), new ExtractorHelper.QueryWrapperList(){

            @Override
            public String doCall(List<ExtractedEntity> arg) throws Exception {
                return ExtractorHelper.querySpecies(arg);
            }
        });
        ExtractorHelper.enrichListField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#statistics"), new ExtractorHelper.QueryWrapperList(){

            @Override
            public String doCall(List<ExtractedEntity> arg) throws Exception {
                return ExtractorHelper.queryStatistics(arg);
            }
        });
        ExtractorHelper.enrichSimpleField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#gear"), new ExtractorHelper.QueryWrapperSimple(){

            @Override
            public String doCall(ExtractedEntity arg) throws Exception {
                return ExtractorHelper.queryGear(arg);
            }
        });
        ExtractorHelper.enrichSimpleField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#country"), new ExtractorHelper.QueryWrapperSimple(){

            @Override
            public String doCall(ExtractedEntity arg) throws Exception {
                return ExtractorHelper.queryCountry(arg);
            }
        });
        ExtractorHelper.enrichSimpleField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#vessel"), new ExtractorHelper.QueryWrapperSimple(){

            @Override
            public String doCall(ExtractedEntity arg) throws Exception {
                return ExtractorHelper.queryVessel(arg);
            }
        });
        ExtractorHelper.enrichListField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#year"), new ExtractorHelper.QueryWrapperList(){

            @Override
            public String doCall(List<ExtractedEntity> arg) throws Exception {
                return ExtractorHelper.queryYear(arg);
            }
        });
        ExtractorHelper.enrichListField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#water_area"), new ExtractorHelper.QueryWrapperList(){

            @Override
            public String doCall(List<ExtractedEntity> arg) throws Exception {
                return ExtractorHelper.queryWaterArea(arg);
            }
        });
        ExtractorHelper.enrichListField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#land_area"), new ExtractorHelper.QueryWrapperList(){

            @Override
            public String doCall(List<ExtractedEntity> arg) throws Exception {
                return ExtractorHelper.queryLandArea(arg);
            }
        });
        try {
            this.annotate(docURI, uris);
        }
        catch (Exception ex) {
            logger.error("file : " + filename + " not found", (Throwable)ex);
        }
        return enrichedRecord;
    }

    static List<String> getDocumentUrls(String path) throws Exception {
        ArrayList documentUrls = Lists.newArrayList();
        countries = RESTServiceExtractor.getCountries(path);
        for (RestExtractorEntities.CountryObj country : countries) {
            try {
                String tableUrl = RESTServiceExtractor.createUrlForTablesQueries(path, country.id);
                logger.debug("getting tables for url : " + tableUrl);
                List<String> tablesIds = RESTServiceExtractor.getTablesIds(tableUrl);
                for (String tableId : tablesIds) {
                    logger.debug("tables : " + tablesIds);
                    String tableDataUrl = RESTServiceExtractor.createUrlForTableDataQueries(path, country.id, tableId);
                    logger.debug("tableID : " + tableDataUrl);
                    documentUrls.add(tableDataUrl);
                }
            }
            catch (Exception e) {
            }
        }
        return documentUrls;
    }

    @Override
    public List<Map<String, String>> extractInfo(String path) throws FileNotFoundException {
        List<String> documentUrls;
        int cnt = 0;
        try {
            documentUrls = RESTServiceExtractor.getDocumentUrls(path);
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
        ArrayList extractedInfo = Lists.newArrayList();
        for (String documentUrl : documentUrls) {
            logger.info("Processing documentUrl : " + ++cnt + " " + documentUrl);
            try {
                Map<String, String> info = this.extractFieldsFromFile(documentUrl);
                long part_start_time = System.currentTimeMillis();
                Map<String, String> enriched = this.enrichRecord(info, documentUrl);
                long part_end_time = System.currentTimeMillis();
                logger.info("~> field enrichment time  : " + (double)(part_end_time - part_start_time) / 1000.0 + " secs");
                extractedInfo.add(enriched);
            }
            catch (Exception e) {
                logger.error("error while extracting info from : " + documentUrl + " . will skip this documentUrl", (Throwable)e);
            }
        }
        return extractedInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<RestExtractorEntities.CountryObj> getCountries(String url) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet request = new HttpGet(url);
        HttpResponse httpResponse = client.execute((HttpUriRequest)request);
        try (InputStream responseStream = httpResponse.getEntity().getContent();){
            List countries;
            Map resp = (Map)gson.fromJson((Reader)new InputStreamReader(responseStream), new TypeToken<Map<String, List<RestExtractorEntities.CountryObj>>>(){}.getType());
            List list = countries = (List)resp.get("countries");
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<RestExtractorEntities.IntermediateCriterionObj> getCriteria(String url) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet request = new HttpGet(url);
        HttpResponse httpResponse = client.execute((HttpUriRequest)request);
        try (InputStream responseStream = httpResponse.getEntity().getContent();){
            List<RestExtractorEntities.IntermediateCriterionObj> retrievedObjs;
            RestExtractorEntities.TableDataObj resp = (RestExtractorEntities.TableDataObj)gson.fromJson((Reader)new InputStreamReader(responseStream), new TypeToken<RestExtractorEntities.TableDataObj>(){}.getType());
            List<RestExtractorEntities.IntermediateCriterionObj> list = retrievedObjs = resp.criteria;
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static RestExtractorEntities.CriterionObj getCriterionValues(String url) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet request = new HttpGet(url);
        HttpResponse httpResponse = client.execute((HttpUriRequest)request);
        try (InputStream responseStream = httpResponse.getEntity().getContent();){
            RestExtractorEntities.CriterionObj resp;
            RestExtractorEntities.CriterionObj criterionObj = resp = (RestExtractorEntities.CriterionObj)gson.fromJson((Reader)new InputStreamReader(responseStream), new TypeToken<RestExtractorEntities.CriterionObj>(){}.getType());
            return criterionObj;
        }
    }

    static List<String> getCountriesIds(String url) throws Exception {
        List<RestExtractorEntities.CountryObj> countries = RESTServiceExtractor.getCountries(url);
        ArrayList ids = Lists.newArrayList();
        for (RestExtractorEntities.CountryObj country : countries) {
            ids.add(String.valueOf(country.id));
        }
        return ids;
    }

    static String createUrlForTablesQueries(String baseUrl, String id) {
        return baseUrl + "/" + id;
    }

    static List<String> createUrlsForTablesQueries(String baseUrl, List<String> ids) {
        ArrayList urls = Lists.newArrayList();
        for (String id : ids) {
            urls.add(baseUrl + "/" + id);
        }
        return urls;
    }

    static String createUrlForCriteriaQueries(String baseUrl, String countryID, String tableID, String criterionId) {
        return baseUrl + "/" + countryID + "/tables/" + tableID + "/criteria/" + criterionId;
    }

    static String createUrlForTableDataQueries(String baseUrl, String countryID, String tableID) {
        return baseUrl + "/" + countryID + "/tables/" + tableID;
    }

    static List<String> createUrlsForTableDataQueries(String baseUrl, String countryID, List<String> ids) {
        ArrayList urls = Lists.newArrayList();
        for (String id : ids) {
            urls.add(baseUrl + "/" + countryID + "/tables/" + id);
        }
        return urls;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<String> getTablesIds(String url) throws Exception {
        ArrayList<String> listings = new ArrayList<String>();
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet request = new HttpGet(url);
        HttpResponse httpResponse = client.execute((HttpUriRequest)request);
        try (InputStream responseStream = httpResponse.getEntity().getContent();){
            Map resp = (Map)gson.fromJson((Reader)new InputStreamReader(responseStream), new TypeToken<Map<String, Object>>(){}.getType());
            List listingObjs = (List)resp.get("listing");
            for (Map listing : listingObjs) {
                Double idStr = (double)((Double)listing.get("id"));
                Integer id = idStr.intValue();
                listings.add(String.valueOf(id));
            }
            ArrayList<String> arrayList = listings;
            return arrayList;
        }
    }

    public static void main(String[] args) throws Exception {
        RESTServiceExtractor ex = new RESTServiceExtractor();
        Map<String, RestExtractorEntities.ValueObj> listAllCountriesOnce = ex.listAllCountriesOnce();
        Set<Map.Entry<String, RestExtractorEntities.ValueObj>> entrySet = listAllCountriesOnce.entrySet();
        for (Map.Entry<String, RestExtractorEntities.ValueObj> entry : entrySet) {
            System.out.println("country id : " + entry.getValue().id + " country en : " + entry.getValue().enLabel + " country fr : " + entry.getValue().frLabel);
        }
    }

    private void annotate(String filename, Map<String, List<String>> uris) throws FileNotFoundException {
        AnnotationBase annotator = AnnotationBase.getInstance();
        Set<Map.Entry<String, List<String>>> entrySet = uris.entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            List<String> uris_;
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#country") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_country(filename, uri_);
                }
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#species") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_species(filename, uri_);
                }
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#gear") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_gear(filename, uri_);
                }
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#vessel") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_vessel(filename, uri_);
                }
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#year") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_year(filename, uri_);
                }
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#water_area") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_water_area(filename, uri_);
                }
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#statistics") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_statistics(filename, uri_);
                }
            }
            if (!entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#land_area") + "_uris")) continue;
            uris_ = entry.getValue();
            for (String uri_ : uris_) {
                annotator.STATBASE_land_area(filename, uri_);
            }
        }
    }

    static String kebabCaseToCamelCase(String str) {
        str = str.replace(" ", "-");
        List w = Splitter.on((String)"-").splitToList((CharSequence)str.toLowerCase());
        StringBuilder camelCase = new StringBuilder();
        camelCase.append((String)w.get(0));
        for (int i = 1; i < w.size(); ++i) {
            camelCase.append(RESTServiceExtractor.capitalizeFirst((String)w.get(i)));
        }
        return camelCase.toString();
    }

    static String kebabCaseToSnakeCase(String str) {
        str = str.toLowerCase().replace(" ", "-");
        return str;
    }

    static String capitalizeFirst(String input) {
        String output = input.substring(0, 1).toUpperCase() + input.substring(1);
        return output;
    }

    private static Map<String, RestExtractorEntities.ValueObj> listAllCountriesOnce() throws Exception {
        HashMap<String, RestExtractorEntities.ValueObj> hashMap = new HashMap<String, RestExtractorEntities.ValueObj>();
        String path = "http://statbase.pirogprod.info:8080/statbase/rest/country";
        List<String> countriesIds = RESTServiceExtractor.getCountriesIds(path);
        for (String countryId : countriesIds) {
            String tableUrl = RESTServiceExtractor.createUrlForTablesQueries(path, countryId);
            logger.debug("getting tables for url : " + tableUrl);
            List<String> tablesIds = RESTServiceExtractor.getTablesIds(tableUrl);
            for (String tableId : tablesIds) {
                logger.debug("tables : " + tablesIds);
                String tableDataUrl = RESTServiceExtractor.createUrlForTableDataQueries(path, countryId, tableId);
                logger.debug("tableID : " + tableDataUrl);
                String countryCriteriaInTable = RESTServiceExtractor.createUrlForCriteriaQueries(path, countryId, tableId, "country");
                try {
                    RestExtractorEntities.CriterionObj criterionValues = RESTServiceExtractor.getCriterionValues(countryCriteriaInTable);
                    List<RestExtractorEntities.ValueObj> countries = criterionValues.values;
                    for (RestExtractorEntities.ValueObj country : countries) {
                        if (hashMap.containsKey(country.id.toString())) continue;
                        hashMap.put(country.id.toString(), country);
                    }
                }
                catch (Exception exception) {
                    System.out.println("does not contain country : " + countryCriteriaInTable);
                }
            }
        }
        return hashMap;
    }

    private String getCountryName(String filename) {
        String id = filename.replace("http://statbase.pirogprod.info:8080/statbase/rest/country/", "");
        id = id.split("/")[0];
        for (RestExtractorEntities.CountryObj countryObj : countries) {
            if (!countryObj.id.equals(id)) continue;
            return countryObj.label;
        }
        return "";
    }

    private void includeCriteriaInDocument(List<RestExtractorEntities.IntermediateCriterionObj> intermediateCriteria, Map<String, String> document, String docID) {
        for (RestExtractorEntities.IntermediateCriterionObj intermediateCriterion : intermediateCriteria) {
            String fieldNamePrefix = null;
            logger.debug("-----> " + intermediateCriterion.criterionName);
            if (intermediateCriterion.criterionName.equalsIgnoreCase("SPECIES") || intermediateCriterion.criterionName.equalsIgnoreCase("especes") || intermediateCriterion.criterionName.equalsIgnoreCase("espece")) {
                fieldNamePrefix = ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#species");
            } else if (intermediateCriterion.criterionName.equalsIgnoreCase("GEARS") || intermediateCriterion.criterionName.equalsIgnoreCase("GEAR") || intermediateCriterion.criterionName.equalsIgnoreCase("GEAR 1") || intermediateCriterion.criterionName.equalsIgnoreCase("GEARS 1") || intermediateCriterion.criterionName.equalsIgnoreCase("FISHING GEARS")) {
                fieldNamePrefix = ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#gear");
            } else if (intermediateCriterion.criterionName.equalsIgnoreCase("TIME") || intermediateCriterion.criterionName.equalsIgnoreCase("YEAR")) {
                fieldNamePrefix = ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#year");
            } else if (intermediateCriterion.criterionName.equalsIgnoreCase("BOAT") || intermediateCriterion.criterionName.equalsIgnoreCase("BOATS") || intermediateCriterion.criterionName.equalsIgnoreCase("VESSEL") || intermediateCriterion.criterionName.equalsIgnoreCase("VESSELS")) {
                fieldNamePrefix = ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#vessel");
            } else if (intermediateCriterion.criterionName.equalsIgnoreCase("MAR-ZONE") || intermediateCriterion.criterionName.equalsIgnoreCase("MAR-ZONE 1") || intermediateCriterion.criterionName.equalsIgnoreCase("MAR-ZONE 2")) {
                fieldNamePrefix = ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#water_area");
            } else if (intermediateCriterion.criterionName.equalsIgnoreCase("TER-ZONE") || intermediateCriterion.criterionName.equalsIgnoreCase("TER-ZONE 1")) {
                fieldNamePrefix = ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#land_area");
            }
            if (fieldNamePrefix == null) {
                logger.warn("####### no field matched for : " + intermediateCriterion.criterionName);
                continue;
            }
            logger.info("####### field matched for : " + fieldNamePrefix);
            String criterionUrl = docID + "/criteria/" + String.valueOf(intermediateCriterion.criterionId);
            document.put("documentID", docID);
            try {
                String frValuesStr;
                RestExtractorEntities.CriterionObj criterion = RESTServiceExtractor.getCriterionValues(criterionUrl);
                ArrayList engValuesList = Lists.newArrayList();
                ArrayList frValuesList = Lists.newArrayList();
                for (RestExtractorEntities.ValueObj value : criterion.values) {
                    String frLabelName = fieldNamePrefix + "_" + "_fr";
                    String frLabelValue = value.frLabel;
                    String enLabelName = fieldNamePrefix;
                    String enLabelValue = value.enLabel;
                    String enDescriptionName = fieldNamePrefix + "_" + "enDescription";
                    String enDescriptionValue = value.enDescription;
                    String frDescriptionName = fieldNamePrefix + "_" + "frDescription";
                    String frDescriptionValue = value.frDescription;
                    List<String> engValues = ExtractorHelper.removeEmptyStringsFromList(Lists.newArrayList((Object[])new String[]{enLabelValue, enDescriptionValue}));
                    List<String> frValues = ExtractorHelper.removeEmptyStringsFromList(Lists.newArrayList((Object[])new String[]{frLabelValue, frDescriptionValue}));
                    engValuesList.addAll(engValues);
                    frValuesList.addAll(frValues);
                }
                String engValuesStr = Joiner.on((String)", ").skipNulls().join((Iterable)engValuesList);
                logger.debug("will insert eng values : |" + engValuesStr + "|" + " produced by : |" + engValuesList + "|");
                if (engValuesStr != null && engValuesStr.trim().length() > 0) {
                    document.put(fieldNamePrefix, engValuesStr);
                }
                if ((frValuesStr = Joiner.on((String)", ").skipNulls().join((Iterable)frValuesList)) != null && frValuesStr.trim().length() > 0) {
                    document.put(fieldNamePrefix + "_fr", frValuesStr);
                }
                logger.info("criterion values : " + criterion.values);
                logger.info("doc : " + document);
            }
            catch (Exception e1) {
                logger.error("error while getting criteriaValues for : " + criterionUrl, (Throwable)e1);
            }
        }
    }

    private void includeStatisticsInDocument(List<RestExtractorEntities.IntermediateStatisticObj> intermediateStatistics, Map<String, String> document) {
        ArrayList<String> stat_en = new ArrayList<String>();
        ArrayList<String> stat_fr = new ArrayList<String>();
        for (RestExtractorEntities.IntermediateStatisticObj intermediateStatisticObj : intermediateStatistics) {
            String enLabel = intermediateStatisticObj.name;
            String frLabel = intermediateStatisticObj.name;
            stat_en.add(enLabel);
            stat_fr.add(frLabel);
        }
        document.put(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#statistics"), Joiner.on((String)",").skipNulls().join(stat_en));
        document.put(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#statistics") + "_fr", Joiner.on((String)",").skipNulls().join(stat_fr));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<RestExtractorEntities.IntermediateStatisticObj> getStatistics(String url) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet request = new HttpGet(url);
        HttpResponse httpResponse = client.execute((HttpUriRequest)request);
        try (InputStream responseStream = httpResponse.getEntity().getContent();){
            List<RestExtractorEntities.IntermediateStatisticObj> retrievedObjs;
            RestExtractorEntities.TableDataObj resp = (RestExtractorEntities.TableDataObj)gson.fromJson((Reader)new InputStreamReader(responseStream), new TypeToken<RestExtractorEntities.TableDataObj>(){}.getType());
            List<RestExtractorEntities.IntermediateStatisticObj> list = retrievedObjs = resp.statistics;
            return list;
        }
    }
}

