/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.semantic.annotator;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.modify.request.QuadDataAcc;
import com.hp.hpl.jena.sparql.modify.request.UpdateClear;
import com.hp.hpl.jena.sparql.modify.request.UpdateCreate;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.resultset.ResultSetMem;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.sparql.util.ResultSetUtils;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jena.riot.RiotWriter;
import org.apache.jena.web.DatasetGraphAccessorHTTP;
import org.gcube.semantic.annotator.FLOD_EntityCollection;
import org.gcube.textextractor.entities.ExtractedEntity;

public class SMARTFISH_EntityCollection {
    private static SMARTFISH_EntityCollection instance;
    private static DatasetGraph entityCollection_locale;
    private static String NS;
    private final Node chimaeraKBnode = NodeFactory.createURI((String)"http://smartfish.d4science.org/entities");
    private static Model m;
    private final String remoteUpdateEndpoint = "http://dl051.madgik.di.uoa.gr:3030/chimaera_kb_update/update";
    private final DatasetGraphAccessorHTTP kbAccressor;
    private HashMap registry = new HashMap();

    private SMARTFISH_EntityCollection() {
        System.out.println("Initializing SMARTFISH EntityCollection");
        this.kbAccressor = new DatasetGraphAccessorHTTP("http://dl051.madgik.di.uoa.gr:3030/chimaera_kb_update/data");
        Graph chimaeraGraph = null;
        if (chimaeraGraph == null) {
            chimaeraGraph = Graph.emptyGraph;
        }
        m.add(ModelUtils.triplesToStatements((Iterator)GraphUtil.findAll((Graph)chimaeraGraph), (Model)m));
        System.out.println("Finalized initialization SMARTFISH EntityCollection");
    }

    public static SMARTFISH_EntityCollection getInstance() {
        if (instance == null) {
            instance = new SMARTFISH_EntityCollection();
        }
        return instance;
    }

    private String addInstance(ExtractedEntity e, String typeURI) throws NoSuchAlgorithmException {
        System.out.println("Adding entity to smartfish_kb for : " + e.toString());
        Node graphNode = NodeFactory.createURI((String)"http://smartfish.d4science.org/entities");
        Node typeNode = NodeFactory.createURI((String)typeURI);
        String entity_uri = NS + typeNode.getLocalName().toLowerCase() + "/" + e.uri_localName;
        Node entity_node = NodeFactory.createURI((String)entity_uri);
        entityCollection_locale.add(graphNode, entity_node, RDF.type.asNode(), typeNode);
        m.add(m.createResource(entity_uri), RDF.type, (RDFNode)m.createResource(typeURI));
        if (e.en_name != null && !e.en_name.isEmpty()) {
            entityCollection_locale.add(graphNode, entity_node, RDFS.label.asNode(), NodeFactory.createLiteral((String)e.en_name, (String)"en", (boolean)false));
            m.add(m.createResource(entity_uri), RDFS.label, (RDFNode)m.createLiteral(e.en_name, "en"));
        }
        if (e.fr_name != null && !e.fr_name.isEmpty()) {
            entityCollection_locale.add(graphNode, entity_node, RDFS.label.asNode(), NodeFactory.createLiteral((String)e.fr_name, (String)"fr", (boolean)false));
            m.add(m.createResource(entity_uri), RDFS.label, (RDFNode)m.createLiteral(e.fr_name, "fr"));
        }
        return entity_uri;
    }

    public File toFile() throws UnsupportedEncodingException, FileNotFoundException {
        File f = new File("smartfish_kb.nq");
        FileOutputStream fos = new FileOutputStream(f);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF8");
        RiotWriter.createNTriples().write((OutputStream)fos, entityCollection_locale.getGraph(this.chimaeraKBnode), null, null, Context.emptyContext);
        return f;
    }

    public void toRemoteGraph() throws FileNotFoundException {
        Node tempGraph = NodeFactory.createURI((String)(this.chimaeraKBnode.toString() + "_temp"));
        if (this.kbAccressor.httpGet(tempGraph) == null) {
            UpdateCreate create = new UpdateCreate(tempGraph, false);
            UpdateExecutionFactory.createRemoteForm((Update)create, (String)"http://dl051.madgik.di.uoa.gr:3030/chimaera_kb_update/update").execute();
        }
        UpdateClear clear = new UpdateClear(tempGraph);
        UpdateExecutionFactory.createRemoteForm((Update)clear, (String)"http://dl051.madgik.di.uoa.gr:3030/chimaera_kb_update/update").execute();
        UpdateDataInsert insert = new UpdateDataInsert(this.makeAcc(tempGraph));
        UpdateExecutionFactory.createRemoteForm((Update)insert, (String)"http://dl051.madgik.di.uoa.gr:3030/chimaera_kb_update/update").execute();
    }

    public File dump(File f) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(f);
        RiotWriter.createNQuads().write((OutputStream)fos, entityCollection_locale, null, null, entityCollection_locale.getContext());
        entityCollection_locale.deleteAny(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        return f;
    }

    public String getURI(ExtractedEntity e, String resType) {
        ResultSet rs = this.getURIrs(e, resType);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)bos, (ResultSet)rs);
        return bos.toString();
    }

    public ResultSet getURIrs(ExtractedEntity e, String resType) {
        String ref_name = e.en_name.isEmpty() ? e.fr_name : e.en_name;
        this.addIfNotThere(e, resType);
        ResultSet rs = this.ce4name(ref_name, resType);
        return rs;
    }

    public String getURI(ExtractedEntity[] ees, String resType) {
        ResultSet[] rsList = new ResultSet[ees.length];
        for (int i = 0; i < ees.length; ++i) {
            ExtractedEntity e = ees[i];
            if (e.isEmpty()) continue;
            rsList[i] = this.getURIrs(e, resType);
        }
        ResultSet rsm = ResultSetUtils.union((ResultSet[])rsList);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)bos, (ResultSet)rsm);
        return bos.toString();
    }

    private ResultSet ce4name(String name, String resType) {
        String sanitized_name = this.sanitize(name);
        String BGP = "{?uri rdf:type <" + resType + "> ." + "?uri rdfs:label ?label . " + "filter(str(?label) = '" + sanitized_name + "') " + "?uri rdfs:label ?label_lang . " + "BIND (str(?label_lang) as ?label_str) " + "BIND (lang(?label_lang) as ?lang) " + "filter(?lang = 'en' || ?lang = 'fr' )" + "}";
        String querySelect = " SELECT distinct ?uri ?label_str ?lang WHERE " + BGP;
        return QueryExecutionFactory.create((String)(FLOD_EntityCollection.prefixes + querySelect), (Model)m).execSelect();
    }

    public String getLabel(String uri, String lang) {
        ResultSet rs = this.label4uri(uri, lang);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)bos, (ResultSet)rs);
        return bos.toString();
    }

    public String getLabel(List<String> entitiesURIs, String lang) {
        ResultSet[] rsList = new ResultSet[entitiesURIs.size()];
        ResultSetMem rsm = new ResultSetMem();
        for (int i = 0; i < entitiesURIs.size(); ++i) {
            String uri = entitiesURIs.get(i);
            ResultSet rs = this.label4uri(uri, lang);
        }
        if (rsList.length > 0) {
            rsm = (ResultSetMem)ResultSetUtils.union((ResultSet[])rsList);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)bos, (ResultSet)rsm);
        return bos.toString();
    }

    private ResultSet label4uri(String uri, String lang) {
        String filter = "";
        String select = " select distinct ?uri ?label_str ?lang";
        String where = " where ";
        String gbpattern = "BIND (IRI('" + uri + "') as ?uri) " + " ?uri rdfs:label ?label_lang . " + "BIND (str(?label_lang) as ?label_str) " + "BIND (lang(?label_lang) as ?lang) ";
        filter = !"".equals(lang) ? filter + "filter(?lang = '" + lang + "')" : filter + "filter(?lang = 'en' || ?lang = 'fr' || ?lang = 'la')";
        Query q = QueryFactory.create((String)(FLOD_EntityCollection.prefixes + select + where + "{" + gbpattern + filter + " }"));
        return QueryExecutionFactory.create((Query)q, (Model)m).execSelect();
    }

    private String sanitize(String name) {
        if (name.contains("/")) {
            name = name.split("/")[0].trim();
        }
        name = name.replace("'", "\\'");
        return name;
    }

    public static void main(String[] args) throws FileNotFoundException {
        SMARTFISH_EntityCollection.getInstance().toRemoteGraph();
    }

    private ExtractedEntity addIfNotThere(ExtractedEntity e, String resType) {
        try {
            Node typeNode = NodeFactory.createURI((String)resType);
            String entity_uri = NS + typeNode.getLocalName().toLowerCase() + "/" + e.uri_localName;
            if (!e.isEmpty() && !this.registry.containsKey(entity_uri)) {
                String eUri = this.addInstance(e, resType);
                this.registry.put(eUri, e);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(SMARTFISH_EntityCollection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return e;
    }

    private QuadDataAcc makeAcc(Node gNode) {
        Iterator find = entityCollection_locale.find();
        QuadDataAcc quadDataAcc = new QuadDataAcc();
        quadDataAcc.setGraph(gNode);
        while (find.hasNext()) {
            Quad quad = (Quad)find.next();
            quadDataAcc.addQuad(quad);
        }
        return quadDataAcc;
    }

    static {
        entityCollection_locale = DatasetGraphFactory.createMem();
        NS = "http://smartfish.d4science.org/entities/";
        m = ModelFactory.createDefaultModel();
    }
}

