/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.index;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.gcube.index.Index;
import org.gcube.index.entities.AutocompleteResponse;
import org.gcube.index.entities.SearchResponse;
import org.gcube.index.entities.Snippet;
import org.gcube.index.entities.Title;
import org.gcube.index.exceptions.BadRequestException;
import org.gcube.index.exceptions.InternalServerErrorException;
import org.gcube.rest.commons.helpers.JSONConverter;
import org.gcube.rest.index.client.IndexClient;
import org.gcube.rest.index.client.exceptions.IndexException;
import org.gcube.semantic.annotator.utils.ANNOTATIONS;
import org.jboss.resteasy.annotations.GZIP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
public class Index {
    private static final Gson gson = new Gson();
    public static final String CACHED_FILEPATH_PROP = "cached_filepath";
    private String scope = null;
    public String cachedFilepath;
    private IndexClient indexClient = null;
    private List<String> projectedFields = new ArrayList();
    private String collectionID;
    private List<String> searchFields;
    private String projections;
    private List<String> autocompleteProjectedFields = new ArrayList();
    private List<String> autocompleteProjectedFields2 = new ArrayList();
    private String autocompleteCollectionID;
    private List<String> autocompleteSearchFields;
    private List<String> autocompleteSearchFields2;
    private String autocompleteProjections;
    private String autocompleteProjections2;
    private List<String> autocompleteLabelFields;
    private String snippetField;
    private static final Logger logger = LoggerFactory.getLogger(Index.class);
    private static Index INSTANCE = new Index();
    static final Set<String> reservedKeywords = Sets.newHashSet((Object[])new String[]{"and", "or", "not", "prox", "fuse", "sortby", "project"});
    static final List<String> reservedSymbols = Lists.newArrayList((Object[])new String[]{",", ".", "-", "&", ")", "(", "]", "[", "=", "==", ">", "<", "<=", ">=", "<>", "/"});
    static final CharSequence reservedSymbolsCharset = Joiner.on((String)"").join((Iterable)reservedSymbols);

    public static Index getInstance() {
        return INSTANCE;
    }

    private Index() {
        this.readPropertyFile();
        this.renewProxy();
        this.createProjections();
    }

    static String createProjectionString(List<String> projectionFields) {
        1 predicate = new /* Unavailable Anonymous Inner Class!! */;
        ArrayList fields = Lists.newArrayList((Iterable)Iterables.filter(projectionFields, (Predicate)predicate));
        return Joiner.on((String)" ").join((Iterable)fields);
    }

    private void createProjections() {
        this.projections = Index.createProjectionString((List)this.projectedFields);
        this.autocompleteProjections = Index.createProjectionString((List)this.autocompleteProjectedFields);
        this.autocompleteProjections2 = Index.createProjectionString((List)this.autocompleteProjectedFields2);
    }

    private void readPropertyFile() {
        try {
            Properties prop = new Properties();
            try (InputStream is = Resources.getResource((String)"index.properties").openStream();){
                prop.load(is);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("could not load property file  : deploy.properties");
            }
            this.scope = prop.getProperty("scope");
            this.cachedFilepath = prop.getProperty("cached_filepath");
            this.collectionID = prop.getProperty("collectionID");
            this.searchFields = Splitter.on((String)",").trimResults().splitToList((CharSequence)prop.getProperty("searchFields"));
            this.snippetField = prop.getProperty("snippetField");
            this.projectedFields = Splitter.on((String)",").trimResults().splitToList((CharSequence)prop.getProperty("projectedFields"));
            this.autocompleteCollectionID = prop.getProperty("autocompleteCollectionID");
            this.autocompleteSearchFields = Splitter.on((String)",").trimResults().splitToList((CharSequence)prop.getProperty("autocompleteSearchFields"));
            this.autocompleteSearchFields2 = Splitter.on((String)",").trimResults().splitToList((CharSequence)prop.getProperty("autocompleteSearchFields2"));
            this.autocompleteProjectedFields = Splitter.on((String)",").trimResults().splitToList((CharSequence)prop.getProperty("autocompleteProjectedFields"));
            this.autocompleteProjectedFields2 = Splitter.on((String)",").trimResults().splitToList((CharSequence)prop.getProperty("autocompleteProjectedFields2"));
            this.autocompleteLabelFields = Splitter.on((String)",").trimResults().splitToList((CharSequence)prop.getProperty("autocompleteLabelFields"));
        }
        catch (Exception e) {
            logger.error("error while reading property file");
        }
    }

    private synchronized void renewProxy() {
        try {
            this.indexClient = new IndexClient.Builder().scope(this.scope).build();
        }
        catch (IndexException e) {
            logger.error("Error while renewing the client");
        }
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response query(@QueryParam(value="query") String query, @QueryParam(value="count") @DefaultValue(value="10") Integer count, @QueryParam(value="from") @DefaultValue(value="0") Integer from, @QueryParam(value="snippet") @DefaultValue(value="false") Boolean snippet, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty, @QueryParam(value="overridenSearchFields") List<String> overridenSearchFields, @QueryParam(value="concept_filter") List<String> conceptFilter) {
        String msg = null;
        Response.Status status = null;
        try {
            msg = this.queryAPI(query, count, from, snippet, pretty, overridenSearchFields, conceptFilter);
            status = Response.Status.OK;
        }
        catch (BadRequestException e) {
            logger.warn("error while querying : " + query, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"msg", (Object)("query " + query + " not valid"));
            status = Response.Status.BAD_REQUEST;
        }
        catch (InternalServerErrorException e) {
            logger.warn("error while querying : " + query, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"msg", (Object)"please retry");
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    public String queryAPI(String query, Integer count, Integer from, Boolean snippet, Boolean pretty, List<String> overridenSearchFields, List<String> conceptFilter) throws BadRequestException, InternalServerErrorException {
        long starttime = System.currentTimeMillis();
        String fullQuery = Index.constructFullQueryForQuery((String)query, (String)this.collectionID, (String)this.projections, (String)this.snippetField, overridenSearchFields, (List)this.searchFields, (Integer)count, (Boolean)snippet);
        long endtime = System.currentTimeMillis();
        logger.info("query construction time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        String msg = null;
        logger.info("full query : " + fullQuery);
        starttime = System.currentTimeMillis();
        List records = null;
        try {
            records = this.indexClient.queryAndReadClientSide(fullQuery, null, from, count, Boolean.valueOf(false));
            logger.info("num of records retrieved : " + records.size());
        }
        catch (IndexException e) {
            logger.error("error while querying for : " + fullQuery, (Throwable)e);
            this.renewProxy();
            throw new InternalServerErrorException((Throwable)e);
        }
        endtime = System.currentTimeMillis();
        logger.info("time to query : " + (double)(endtime - starttime) / 1000.0 + " secs");
        if (records.size() == 0) {
            logger.info("no records found");
            this.renewProxy();
            throw new InternalServerErrorException("no records found");
        }
        starttime = System.currentTimeMillis();
        try {
            msg = this.postProcess(query, records, count, pretty, snippet, conceptFilter);
        }
        catch (Exception e) {
            logger.error("error while post processing the results for : " + fullQuery, (Throwable)e);
            this.renewProxy();
            throw new InternalServerErrorException((Throwable)e);
        }
        endtime = System.currentTimeMillis();
        logger.info("post process time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        return msg;
    }

    @GET
    @Path(value="/getDoc")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getDoc(@QueryParam(value="doc_uri") String doc_uri, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty) {
        String msg = null;
        Response.Status status = null;
        try {
            msg = this.getDocAPI(doc_uri, pretty);
            status = Response.Status.OK;
        }
        catch (BadRequestException e) {
            logger.warn("error while getDoc : " + doc_uri, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"msg", (Object)("doc_uri " + doc_uri + " not valid"));
            status = Response.Status.BAD_REQUEST;
        }
        catch (InternalServerErrorException e) {
            logger.warn("error while getDoc : " + doc_uri, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"msg", (Object)"please retry");
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    @GET
    @Path(value="/getDocs")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response getDocs(@QueryParam(value="doc_uris") List<String> doc_uris, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty, @QueryParam(value="count") @DefaultValue(value="10") Integer count, @QueryParam(value="from") @DefaultValue(value="0") Integer from) {
        String msg = null;
        Response.Status status = null;
        try {
            msg = this.getDocsAPI(doc_uris, pretty, count, from);
            status = Response.Status.OK;
        }
        catch (InternalServerErrorException e) {
            logger.warn("error while getDocs : " + doc_uris, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"msg", (Object)"please retry");
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    public String getDocsAPI(List<String> doc_uris, Boolean pretty, Integer count, Integer from) throws InternalServerErrorException {
        if (Index.checkIfConceptFilterIsEmpty(doc_uris)) {
            logger.info("doc_uris list is null or empty");
            return JSONConverter.convertToJSON(new ArrayList(), (boolean)pretty);
        }
        long starttime = System.currentTimeMillis();
        String fullQuery = Index.constructFullQueryForGetDocs(doc_uris, (String)this.collectionID, (String)this.projections);
        long endtime = System.currentTimeMillis();
        logger.info("full query : " + fullQuery);
        String msg = null;
        List records = null;
        try {
            records = this.indexClient.queryAndReadClientSide(fullQuery, null, from, count, Boolean.valueOf(false));
            logger.info("records found : " + records.size());
        }
        catch (IndexException e) {
            logger.error("error while querying for : " + fullQuery, (Throwable)e);
            this.renewProxy();
            throw new InternalServerErrorException((Throwable)e);
        }
        endtime = System.currentTimeMillis();
        logger.info("time to query : " + (double)(endtime - starttime) / 1000.0 + " secs");
        if (records.size() == 0) {
            logger.info("no records found");
            this.renewProxy();
            throw new InternalServerErrorException("no records found");
        }
        starttime = System.currentTimeMillis();
        try {
            msg = this.postProcess("", records, count, pretty, Boolean.valueOf(false), null);
        }
        catch (Exception e) {
            logger.error("error while postprocessing the results for : " + fullQuery, (Throwable)e);
            this.renewProxy();
            throw new InternalServerErrorException((Throwable)e);
        }
        endtime = System.currentTimeMillis();
        logger.info("post process time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        return msg;
    }

    @GET
    @Path(value="/autocomplete")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response autocomplete(@QueryParam(value="query") String query, @QueryParam(value="lang") String lang, @QueryParam(value="count") @DefaultValue(value="10") Integer count, @QueryParam(value="from") @DefaultValue(value="0") Integer from, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty) {
        String msg = null;
        Response.Status status = null;
        try {
            msg = this.autocompleteAPI(query, lang, count, from, pretty);
            status = Response.Status.OK;
        }
        catch (BadRequestException e) {
            logger.warn("error while autocomplete : " + query, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"msg", (Object)("query " + query + " not valid"));
            status = Response.Status.BAD_REQUEST;
        }
        catch (InternalServerErrorException e) {
            logger.warn("error while autocomplete : " + query, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"msg", (Object)"please retry");
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    public String autocompleteAPI(String query, String lang, Integer count, Integer from, Boolean pretty) throws BadRequestException, InternalServerErrorException {
        String msg = null;
        long starttime = System.currentTimeMillis();
        String fullQuery = Index.constructFullQueryForAutocomplete((String)query, (String)this.autocompleteCollectionID, (String)lang, (List)this.autocompleteSearchFields, (String)this.autocompleteProjections);
        long endtime = System.currentTimeMillis();
        logger.info("full query : " + fullQuery);
        List records = null;
        try {
            records = this.indexClient.queryAndReadClientSide(fullQuery, null, from, count, Boolean.valueOf(false));
            logger.info("records found : " + records.size());
        }
        catch (IndexException e) {
            logger.error("error while querying for : " + fullQuery, (Throwable)e);
            this.renewProxy();
            throw new InternalServerErrorException((Throwable)e);
        }
        endtime = System.currentTimeMillis();
        logger.info("time to query : " + (double)(endtime - starttime) / 1000.0 + " secs");
        if (records.size() == 0) {
            logger.info("no records found");
            this.renewProxy();
            throw new InternalServerErrorException("no records found");
        }
        starttime = System.currentTimeMillis();
        try {
            msg = this.postProcessAutocomplete(query, records, count, pretty);
        }
        catch (Exception e) {
            logger.error("error while post processing the autocomplete for : " + fullQuery, (Throwable)e);
            this.renewProxy();
            throw new InternalServerErrorException((Throwable)e);
        }
        endtime = System.currentTimeMillis();
        logger.info("post process time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        return msg;
    }

    @GET
    @Path(value="/autocomplete_title")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response autocompleteTitle(@QueryParam(value="query") String query, @QueryParam(value="lang") String lang, @QueryParam(value="count") @DefaultValue(value="10") Integer count, @QueryParam(value="from") @DefaultValue(value="0") Integer from, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty) {
        String msg = null;
        Response.Status status = null;
        try {
            msg = this.autocompleteTitleAPI(query, lang, count, from, pretty);
            status = Response.Status.OK;
        }
        catch (BadRequestException e) {
            logger.warn("error while autocompleteTitle : " + query, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"msg", (Object)("query " + query + " not valid"));
            status = Response.Status.BAD_REQUEST;
        }
        catch (InternalServerErrorException e) {
            logger.warn("error while autocompleteTitle : " + query, (Throwable)e);
            msg = JSONConverter.convertToJSON((String)"msg", (Object)"please retry");
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)msg).build();
    }

    public String autocompleteTitleAPI(String query, String lang, Integer count, Integer from, Boolean pretty) throws BadRequestException, InternalServerErrorException {
        long starttime = System.currentTimeMillis();
        String fullQuery = Index.constructFullQueryForAutocomplete((String)query, (String)this.autocompleteCollectionID, (String)lang, (List)this.autocompleteSearchFields2, (String)this.autocompleteProjections2);
        long endtime = System.currentTimeMillis();
        logger.info("full query : " + fullQuery);
        List records = null;
        String msg = null;
        try {
            records = this.indexClient.queryAndReadClientSide(fullQuery, null, from, count, Boolean.valueOf(false));
            logger.info("record found : " + records.size());
        }
        catch (IndexException e) {
            logger.error("error while querying for : " + fullQuery, (Throwable)e);
            this.renewProxy();
            throw new InternalServerErrorException((Throwable)e);
        }
        endtime = System.currentTimeMillis();
        logger.info("time to query : " + (double)(endtime - starttime) / 1000.0 + " secs");
        if (records.size() == 0) {
            logger.info("no records found");
            this.renewProxy();
            throw new InternalServerErrorException("no records found");
        }
        starttime = System.currentTimeMillis();
        try {
            msg = this.postProcessAutocompleteTitle(query, records, count, pretty);
        }
        catch (Exception e) {
            logger.error("error while postprocessing autocomplete title for : " + fullQuery, (Throwable)e);
            this.renewProxy();
            throw new InternalServerErrorException((Throwable)e);
        }
        endtime = System.currentTimeMillis();
        logger.info("post process time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        return msg;
    }

    private String postProcess(List<Map<String, String>> records, Boolean pretty) {
        return this.postProcess("", records, Integer.valueOf(-1), pretty, Boolean.valueOf(false), null);
    }

    private String postProcess(String qterm, List<Map<String, String>> records, Integer count, Boolean pretty, Boolean includeSnippet, List<String> conceptFilter) {
        long starttime = System.currentTimeMillis();
        long endtime = System.currentTimeMillis();
        logger.info("conceptFilter      : " + conceptFilter);
        if (conceptFilter != null) {
            logger.info("conceptFilter size : " + conceptFilter.size());
        }
        ArrayList<SearchResponse> results = new ArrayList<SearchResponse>();
        starttime = System.currentTimeMillis();
        int cnt = 0;
        for (Map<String, String> record : records) {
            if (cnt++ >= count) break;
            try {
                String id;
                String[] parts;
                SearchResponse sr = new SearchResponse();
                sr.qterm = qterm;
                sr.score = Double.valueOf(record.get("rank"));
                sr.uri = record.get("ObjectID");
                sr.uri = StringEscapeUtils.unescapeXml((String)sr.uri);
                String provenance = record.get("provenance");
                provenance = Index.escapeResults((String)provenance);
                provenance = provenance.toLowerCase();
                if (provenance.equalsIgnoreCase("StatBase")) {
                    parts = sr.uri.split("/");
                    id = null;
                    if (parts != null && parts.length > 0) {
                        id = parts[parts.length - 1];
                    }
                    sr.seealso = this.cachedFilepath + "statbase/" + id + ".jpg";
                    sr.prov.put("label", "statbase");
                    sr.prov.put("uri", "http://smartfish.collection/statbase");
                } else if (provenance.equalsIgnoreCase("WIOFish")) {
                    parts = sr.uri.split("/");
                    id = null;
                    if (parts != null && parts.length > 0) {
                        id = parts[parts.length - 1];
                    }
                    sr.seealso = this.cachedFilepath + "wiofish/" + id + ".html";
                    sr.prov.put("label", "wiofish");
                    sr.prov.put("uri", "http://smartfish.collection/wiofish");
                    sr.uri = "http://smartfish.collection/wiofish/" + id;
                } else if (provenance.equalsIgnoreCase("FIRMS")) {
                    parts = sr.uri.split("/");
                    id = null;
                    if (parts != null && parts.length > 0) {
                        id = parts[parts.length - 1];
                    }
                    sr.seealso = this.cachedFilepath + "firms/" + id + ".xml";
                    sr.prov.put("label", "firms");
                    sr.prov.put("uri", "http://smartfish.collection/firms");
                    sr.uri = "http://smartfish.collection/firms/" + id;
                } else {
                    logger.info("NO provenance found for : " + provenance);
                }
                sr.country = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#country"));
                sr.gear = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#gear"));
                sr.vessel = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#vessel"));
                sr.management = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#management"));
                sr.status = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#status"));
                sr.access_control = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#access_control"));
                sr.fishing_control = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#fishing_control"));
                sr.enforcement_method = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#enforcement_method"));
                sr.sector = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#sector"));
                sr.other_income_source = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#other_income_source"));
                sr.market = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#market"));
                sr.post_processing_method = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#post_processing_method"));
                sr.management_indicator = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#management_indicator"));
                sr.finance_mgmt_authority = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#finance_mgmt_authority"));
                sr.species = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#species"));
                sr.bycatch = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#bycatch"));
                sr.target = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#target"));
                sr.thretened = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#thretened"));
                sr.discard = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#discard"));
                sr.seasonality = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#seasonality"));
                sr.decision_maker = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#decision_maker"));
                sr.owner_of_access_right = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#owner_of_access_right"));
                sr.applicant_for_access_right = Index.getRecordValue(conceptFilter, record, (String)ANNOTATIONS.getLocalName((String)"http://www.fao.org/figis/onto/smartfish/annotation.owl#applicant_for_access_right"));
                if (!Strings.isNullOrEmpty((String)record.get("technology_used"))) {
                    String technology = record.get("technology_used");
                    technology = Index.escapeResults((String)technology);
                    List techList = Splitter.on((String)",").trimResults().splitToList((CharSequence)technology);
                    if (techList.size() > 0) {
                        sr.technology = techList;
                    }
                }
                Title docTitle = new Title();
                docTitle.title = record.get("title");
                docTitle.title = Index.escapeResults((String)docTitle.title);
                sr.titles = Arrays.asList(docTitle);
                if (includeSnippet.booleanValue()) {
                    ArrayList snippets = Lists.newArrayList((Iterable)Splitter.on((String)"...").split((CharSequence)record.get(this.snippetField)));
                    sr.snippets = new ArrayList();
                    for (String snippetText : snippets) {
                        sr.snippets.add(new Snippet(Index.escapeResults((String)snippetText.trim()).trim()));
                    }
                    if (sr.snippets.size() == 0) {
                        sr.snippets = null;
                    }
                }
                results.add(sr);
            }
            catch (NullPointerException e) {
                logger.error("error while postprocessing the record : " + record);
                logger.error("", (Throwable)e);
            }
        }
        endtime = System.currentTimeMillis();
        logger.info("time to read records : " + (double)(endtime - starttime) / 1000.0 + " secs");
        starttime = System.currentTimeMillis();
        String msg = JSONConverter.convertToJSON(results, (boolean)pretty);
        endtime = System.currentTimeMillis();
        logger.info("time to conver to json : " + (double)(endtime - starttime) / 1000.0 + " secs");
        return msg;
    }

    private static boolean checkIfConceptFilterIsEmpty(List<String> conceptFilter) {
        return conceptFilter == null || conceptFilter.size() == 0 || conceptFilter.size() == 1 && Strings.isNullOrEmpty((String)conceptFilter.get(0));
    }

    private String postProcessAutocomplete(String qterm, List<Map<String, String>> records, Integer count, Boolean pretty) {
        long starttime = System.currentTimeMillis();
        long endtime = System.currentTimeMillis();
        ArrayList<AutocompleteResponse> results = new ArrayList<AutocompleteResponse>();
        starttime = System.currentTimeMillis();
        int cnt = 0;
        for (Map<String, String> record : records) {
            if (cnt++ >= count) break;
            try {
                AutocompleteResponse ar = new AutocompleteResponse();
                ar.qterm = qterm;
                ar.score = Double.valueOf(record.get("rank"));
                ar.uri = Index.escapeResults((String)record.get("ObjectID"));
                ar.doc_uri = Index.escapeResults((String)record.get("doc_uri"));
                ArrayList<String> fields = new ArrayList<String>();
                for (String labelField : this.autocompleteLabelFields) {
                    String payload = Index.escapeResults((String)record.get(labelField));
                    fields.add(payload);
                }
                logger.info("autocomplete returned : " + fields);
                ar.label = this.getMatchedLabel(fields, qterm.split("\\s+"));
                results.add(ar);
            }
            catch (Exception e) {
                logger.error("error while postprocessing the record : " + record);
            }
        }
        endtime = System.currentTimeMillis();
        logger.info("time to read records : " + (double)(endtime - starttime) / 1000.0 + " secs");
        starttime = System.currentTimeMillis();
        String msg = JSONConverter.convertToJSON(results, (boolean)pretty);
        endtime = System.currentTimeMillis();
        logger.info("time to conver to json : " + (double)(endtime - starttime) / 1000.0 + " secs");
        return msg;
    }

    private String getMatchedLabel(List<String> fields, String[] terms) {
        return this.getMatchedLabel(fields, Arrays.asList(terms));
    }

    private String getMatchedLabel(List<String> fields, List<String> terms) {
        logger.info("matching fields : " + fields);
        return StringUtils.join((Collection)this.getMatchedList(fields, terms), (String)" ");
    }

    private List<String> getMatchedList(List<String> fields, List<String> terms) {
        ArrayList<String> matchedList = new ArrayList<String>();
        for (String field : fields) {
            String matched = this.matchField(field, terms, true);
            logger.info("matched field for : " + field + " : " + matched);
            if (matched == null) continue;
            matchedList.add(matched);
        }
        ArrayList<String> restFields = new ArrayList<String>(fields);
        restFields.removeAll(matchedList);
        for (String field : restFields) {
            String matched = this.matchField(field, terms, false);
            logger.info("matched field for : " + field + " : " + matched);
            if (matched == null) continue;
            matchedList.add(matched);
        }
        return matchedList;
    }

    private String matchField(String field, List<String> terms, boolean onlyStart) {
        if (field.contains(",")) {
            return this.matchMultiValueField(field, terms, onlyStart);
        }
        return this.matchSingleValueField(field, terms, onlyStart);
    }

    private String matchMultiValueField(String multiValueField, List<String> terms, boolean onlyStart) {
        for (String term : terms) {
            for (String field : Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)multiValueField)) {
                if (!(onlyStart ? field.toLowerCase().startsWith(term.toLowerCase()) : field.toLowerCase().contains(term.toLowerCase()))) continue;
                return field;
            }
        }
        return null;
    }

    private String matchSingleValueField(String field, List<String> terms, boolean onlyStart) {
        for (String term : terms) {
            if (!(onlyStart ? field.toLowerCase().startsWith(term.toLowerCase()) : field.toLowerCase().contains(term.toLowerCase()))) continue;
            return field;
        }
        return null;
    }

    private String postProcessAutocompleteTitle(String qterm, List<Map<String, String>> records, Integer count, Boolean pretty) {
        long starttime = System.currentTimeMillis();
        long endtime = System.currentTimeMillis();
        logger.info("time to init stream : " + (double)(endtime - starttime) / 1000.0 + " secs");
        ArrayList<AutocompleteResponse> results = new ArrayList<AutocompleteResponse>();
        starttime = System.currentTimeMillis();
        int cnt = 0;
        for (Map<String, String> record : records) {
            if (cnt++ >= count) break;
            try {
                AutocompleteResponse ar = new AutocompleteResponse();
                ar.qterm = qterm;
                ar.score = Double.valueOf(record.get("rank"));
                ar.uri = Index.escapeResults((String)record.get("ObjectID"));
                ar.doc_uri = Index.escapeResults((String)record.get("doc_uri"));
                ar.label = Index.escapeResults((String)record.get("title"));
                results.add(ar);
            }
            catch (Exception e) {
                logger.error("error while postprocessing the record : " + record);
            }
        }
        endtime = System.currentTimeMillis();
        logger.info("time to read records : " + (double)(endtime - starttime) / 1000.0 + " secs");
        starttime = System.currentTimeMillis();
        String msg = JSONConverter.convertToJSON(results, (boolean)pretty);
        endtime = System.currentTimeMillis();
        logger.info("time to convert to json : " + (double)(endtime - starttime) / 1000.0 + " secs");
        return msg;
    }

    public String getDocAPI(String doc_uri, Boolean pretty) throws InternalServerErrorException, BadRequestException {
        long starttime = System.currentTimeMillis();
        String fullQuery = Index.constructFullQueryForGetDoc((String)doc_uri, (String)this.collectionID, (String)this.projections);
        long endtime = System.currentTimeMillis();
        String msg = null;
        logger.info("full query : " + fullQuery);
        List records = null;
        try {
            records = this.indexClient.queryAndReadClientSide(fullQuery, null, Boolean.valueOf(false));
            logger.info("records found : " + records.size());
        }
        catch (IndexException e) {
            logger.error("error while querying for : " + fullQuery, (Throwable)e);
            this.renewProxy();
            throw new InternalServerErrorException((Throwable)e);
        }
        endtime = System.currentTimeMillis();
        logger.info("time to query : " + (double)(endtime - starttime) / 1000.0 + " secs");
        if (records.size() == 0) {
            logger.info("no records found");
            this.renewProxy();
            throw new InternalServerErrorException("no records found");
        }
        starttime = System.currentTimeMillis();
        try {
            msg = this.postProcess(records, pretty);
        }
        catch (Exception e) {
            logger.error("error while postprocessing the results for : " + fullQuery, (Throwable)e);
            this.renewProxy();
            throw new InternalServerErrorException((Throwable)e);
        }
        endtime = System.currentTimeMillis();
        logger.info("post process time : " + (double)(endtime - starttime) / 1000.0 + " secs");
        return msg;
    }

    private static String constructFullQueryForQuery(String query, String collectionID, String projectionsString, String snippetField, List<String> overridenSearchFields, List<String> searchFields, Integer count, Boolean snippet) throws BadRequestException {
        logger.info("received query : " + query);
        logger.info("count : " + count);
        query = Index.sanitizeQuery((String)query);
        logger.info("sanitized query : " + query);
        if (query.contains("*") || query.contains("+") || query.contains(".")) {
            throw new BadRequestException();
        }
        boolean exactQuery = query.startsWith("\"") && query.endsWith("\"");
        List<String> fieldsToBeSearched = null;
        if (overridenSearchFields != null && overridenSearchFields.size() > 0) {
            fieldsToBeSearched = overridenSearchFields;
            logger.info("Using overridenSearchFields");
        } else {
            fieldsToBeSearched = searchFields;
            logger.info("Using default searchFields");
        }
        logger.info("fieldsToBeSearched : " + fieldsToBeSearched);
        List terms = null;
        terms = exactQuery ? Lists.newArrayList((Object[])new String[]{query}) : Splitter.on((CharMatcher)CharMatcher.WHITESPACE).trimResults().splitToList((CharSequence)query);
        ArrayList<String> relations = new ArrayList<String>();
        for (String term : terms) {
            for (String field : fieldsToBeSearched) {
                relations.add(field + " = " + term);
            }
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("gDocCollectionID == ").append(collectionID).append(" AND ").append("(").append(Joiner.on((String)" OR ").join(relations)).append(")").append(" project ").append(projectionsString);
        if (snippet.booleanValue()) {
            strBuf.append(" ").append(snippetField);
        }
        return strBuf.toString();
    }

    private static String constructFullQueryForGetDocs(List<String> doc_uris, String collectionID, String projectionsStr) {
        ArrayList<String> relations = new ArrayList<String>();
        for (String docUri : doc_uris) {
            relations.add("ObjectID = \"" + docUri + "\"");
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("gDocCollectionID == ").append(collectionID).append(" AND ").append("(").append(Joiner.on((String)" OR ").join(relations)).append(")").append(" project ").append(projectionsStr);
        return strBuf.toString();
    }

    private static String constructFullQueryForAutocomplete(String query, String collectionID, String lang, List<String> autocompleteSearchFields, String autocompleteProjectionStr) throws BadRequestException {
        logger.info("received query : " + query);
        query = Index.sanitizeQuery((String)query);
        logger.info("sanitized query : " + query);
        if (query.contains("*") || query.contains("+") || query.contains(".")) {
            throw new BadRequestException();
        }
        List terms = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).trimResults().splitToList((CharSequence)query);
        ArrayList<String> relations = new ArrayList<String>();
        for (String term : terms) {
            for (String field : autocompleteSearchFields) {
                relations.add(field + " = " + term);
            }
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("(").append("gDocCollectionID == ").append(collectionID);
        if (lang != null) {
            strBuf.append(" AND ").append("gDocCollectionLang == ").append("\"").append(lang).append("\"").append(")");
        }
        strBuf.append(" AND ").append("(").append(Joiner.on((String)" OR ").join(relations)).append(")").append(" project ").append(autocompleteProjectionStr);
        return strBuf.toString();
    }

    private static String constructFullQueryForGetDoc(String doc_uri, String collectionID, String projectionsStr) throws BadRequestException {
        logger.info("received doc_uri : " + doc_uri);
        doc_uri = Index.sanitizeQuery((String)doc_uri);
        logger.info("sanitized doc_uri : " + doc_uri);
        if (doc_uri.contains("*") || doc_uri.contains("+") || doc_uri.contains(".")) {
            throw new BadRequestException();
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("gDocCollectionID == ").append(collectionID).append(" AND ").append("ObjectID = ").append("\"").append(doc_uri).append("\"").append(" project ").append(projectionsStr);
        return strBuf.toString();
    }

    public static void main(String[] args) {
        String query = null;
        query = "abc or (cdb)";
        query = " \"abc or (cdb) and lpo \" paok or (pao) \"()()()\" ";
        System.out.println(Index.sanitizeQuery((String)query));
        query = "\"asc\"";
        System.out.println(Index.sanitizeQuery((String)query));
    }

    static String sanitizeQuery(String query) {
        List q = Splitter.on((String)"\"").trimResults().splitToList((CharSequence)query);
        if (q.size() % 2 != 1) {
            logger.warn("number of quotes should be even");
            throw new IllegalArgumentException("number of quotes should be even");
        }
        ArrayList sanitizedQuery = Lists.newArrayList();
        String subTerm = null;
        for (int i = 0; i != q.size(); ++i) {
            subTerm = (String)q.get(i);
            if (i % 2 == 0) {
                sanitizedQuery.addAll(Index.sanitizeSubQuery((String)subTerm));
                continue;
            }
            sanitizedQuery.add("\"" + subTerm + "\"");
        }
        return Joiner.on((String)" ").join((Iterable)sanitizedQuery);
    }

    static List<String> sanitizeSubQuery(String query) {
        String sanitized = query;
        String queryWithoutSymbols = CharMatcher.anyOf((CharSequence)reservedSymbolsCharset).replaceFrom((CharSequence)sanitized, (CharSequence)"");
        List terms = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().trimResults().splitToList((CharSequence)queryWithoutSymbols);
        ArrayList sanitizedTerms = Lists.newArrayList();
        for (String term : terms) {
            if (reservedKeywords.contains(term.toLowerCase())) {
                sanitizedTerms.add("\"" + term + "\"");
                continue;
            }
            sanitizedTerms.add(term);
        }
        return sanitizedTerms;
    }

    static List<String> sanitizeSubQuery2(String query) {
        String sanitized = StringEscapeUtils.escapeHtml((String)query);
        String queryWithoutSymbols = CharMatcher.anyOf((CharSequence)reservedSymbolsCharset).replaceFrom((CharSequence)sanitized, (CharSequence)"");
        List terms = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().trimResults().splitToList((CharSequence)queryWithoutSymbols);
        return terms;
    }

    static String escapeResults(String result) {
        return StringEscapeUtils.unescapeXml((String)StringEscapeUtils.unescapeHtml((String)result));
    }

    private static List<Map<String, String>> getRecordValue(List<String> conceptFilter, Map<String, String> record, String fieldName) {
        List resp = null;
        if (Index.checkIfConceptFilterIsEmpty(conceptFilter) || conceptFilter.contains(fieldName)) {
            String country = record.get(fieldName + "_uris");
            country = Index.escapeResults((String)country);
            try {
                resp = (List)gson.fromJson(country, new /* Unavailable Anonymous Inner Class!! */.getType());
                return resp;
            }
            catch (Exception e) {
                logger.info("error parsing country : " + country);
            }
        }
        return null;
    }
}

