/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.storagehandling;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.indexmanagement.common.IndexLookupWSResource;
import org.gcube.indexmanagement.common.IndexNotificationConsumer;
import org.gcube.indexmanagement.common.IndexWSResource;
import org.gcube.indexmanagement.storagehandling.DeltaListManagementWrapper;
import org.gcube.indexmanagement.storagehandling.IndexReplicator;
import org.gcube.indexmanagement.storagehandling.RemoteDeltaListManager;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaActionType;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaFileInfoType;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaListManagerCreatedNotificationMessageType;
import org.gcube.indexmanagement.storagehandling.stubs.UpdateNotificationMessageType;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.core.notification.SubscriptionManager;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.oasis.wsn.PauseSubscription;
import org.oasis.wsn.ResumeSubscription;
import org.oasis.wsrf.lifetime.Destroy;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class DeltaFileConsumer {
    private static GCUBELog logger = new GCUBELog(DeltaFileConsumer.class);
    private IndexReplicator replicator;
    private String deltaCollectionID = null;
    private int deltaListStartIdx;
    private DeltaListManagementWrapper indexManager;
    private IndexNotificationConsumer additionNotificationConsumer;
    private IndexNotificationConsumer deletionNotificationConsumer;
    private IndexNotificationConsumer removalNotificationConsumer;
    private IndexNotificationConsumer managerCreationNotificationConsumer;
    private SubscriptionManager additionSubscription;
    private SubscriptionManager deletionSubscription;
    private SubscriptionManager removalSubscription;
    private SubscriptionManager managerCreationSubscription;
    private boolean doesHandleAdditions = true;
    private boolean doesHandleDeletions = true;
    private boolean enforceStrictOrder = true;
    private IndexLookupWSResource resource;
    private LinkedList<DeltaData> downloadQueue;
    private IndexReplicatorThread replicatorThread;
    private List<DeltaFileInfoType> deltaFileList;
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    public DeltaFileConsumer() {
    }

    public DeltaFileConsumer(IndexLookupWSResource resource, IndexReplicator replicator, int startIdx) throws Exception {
        this(resource, replicator, new RemoteDeltaListManager(resource.getIndexID(), resource.getServiceContext(), resource.getManagementResourceNamespace()), startIdx, true);
    }

    private DeltaFileConsumer(IndexLookupWSResource resource, IndexReplicator replicator, DeltaListManagementWrapper indexManager, int startIdx, boolean subscribeForUpdates) throws Exception {
        this.deltaFileList = new LinkedList<DeltaFileInfoType>();
        this.initialize(resource, replicator, indexManager, startIdx, subscribeForUpdates);
        this.synchronizeWithIndexManager();
        this.replicatorThread.start();
    }

    private void initialize(IndexLookupWSResource resource, IndexReplicator replicator, DeltaListManagementWrapper indexManager, int startIdx, boolean subscribeForUpdates) throws Exception {
        GCUBEServiceContext ctx = resource.getServiceContext();
        this.replicator = replicator;
        this.indexManager = indexManager;
        this.downloadQueue = new LinkedList();
        this.resource = resource;
        this.deltaListStartIdx = startIdx;
        this.additionNotificationConsumer = new AdditionConsumerNotification(ctx.getScope());
        this.deletionNotificationConsumer = new DeletionConsumerNotification(ctx.getScope());
        this.removalNotificationConsumer = new RemovalConsumerNotification(ctx.getScope());
        this.managerCreationNotificationConsumer = new ManagerCreationConsumerNotification(ctx.getScope());
        this.deltaCollectionID = indexManager.getDeltaCollectionID();
        if (subscribeForUpdates) {
            this.subscribeForDeltaListChanges();
        }
        this.subscribeForManagerCreation();
        this.subscribeForIndexRemoval();
        this.replicatorThread = new IndexReplicatorThread();
        ctx.setScope((Thread)this.replicatorThread, ctx.getScope());
        ctx.useCredentials((Thread)this.replicatorThread, new SecurityCredentials[]{ctx.getCredentials()});
    }

    public void storeState(ObjectOutputStream oos) {
        try {
            if (this.indexManager.isEmpty()) {
                oos.writeBoolean(false);
            } else {
                oos.writeBoolean(true);
                oos.writeObject(ObjectSerializer.toString((Object)this.indexManager.getIndexManagerEPR(), (QName)new QName(this.resource.getNamespace(), "indexManagerEPR")));
            }
            oos.writeBoolean(this.doesHandleAdditions);
            oos.writeBoolean(this.doesHandleDeletions);
            oos.writeBoolean(this.enforceStrictOrder);
            oos.writeInt(this.deltaFileList.size());
            for (int i = 0; i < this.deltaFileList.size(); ++i) {
                oos.writeObject(this.deltaFileList.get(i));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to store DeltaFileConsumer state.", (Throwable)e);
        }
    }

    public void loadState(ObjectInputStream ois, boolean firstLoad, IndexLookupWSResource resource, IndexReplicator replicator, int startIdx) throws Exception {
        logger.debug((Object)">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Starting DeltaFileConsumer state loading");
        RemoteDeltaListManager remoteDeltaManager = null;
        boolean bCreateWithEPR = false;
        String sIndexManagerEPR = null;
        boolean bReadIndexManagerEPR = ois.readBoolean();
        if (bReadIndexManagerEPR) {
            sIndexManagerEPR = (String)ois.readObject();
            if (!firstLoad) {
                bCreateWithEPR = true;
            }
        }
        if (bCreateWithEPR) {
            logger.info((Object)("A manager EPR was stored in the DeltaFileConsumer's state. Going to use it: " + sIndexManagerEPR));
            EndpointReferenceType indexManagerEPR = (EndpointReferenceType)ObjectDeserializer.deserialize((InputSource)new InputSource(new StringReader(sIndexManagerEPR)), EndpointReferenceType.class);
            remoteDeltaManager = new RemoteDeltaListManager(resource.getIndexID(), indexManagerEPR, resource.getServiceContext());
        } else {
            logger.info((Object)"Not using a stored manager EPR, will search for one.");
            remoteDeltaManager = new RemoteDeltaListManager(resource.getIndexID(), resource.getServiceContext(), resource.getManagementResourceNamespace());
        }
        this.doesHandleAdditions = ois.readBoolean();
        this.doesHandleDeletions = ois.readBoolean();
        this.enforceStrictOrder = ois.readBoolean();
        this.deltaFileList = new LinkedList<DeltaFileInfoType>();
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            this.deltaFileList.add((DeltaFileInfoType)ois.readObject());
        }
        this.initialize(resource, replicator, remoteDeltaManager, startIdx, true);
        this.replicatorThread.start();
        logger.debug((Object)"<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< DeltaFileConsumer state loading done.");
    }

    private int findFirstMissedUpdate(DeltaFileInfoType[] producerDeltaFileList) {
        int minCommonListLen = Math.min(producerDeltaFileList.length, this.deltaFileList.size());
        if (minCommonListLen == producerDeltaFileList.length && this.deltaFileList.size() != producerDeltaFileList.length) {
            logger.info((Object)"Remote producer delta file list is smaller than the local list. The whole index will be rebuilt.");
            return 0;
        }
        for (int i = 0; i < minCommonListLen; ++i) {
            if (this.deltaFileList.get(i).equals((Object)producerDeltaFileList[i])) continue;
            logger.info((Object)"Differences found between the remote producer delta file list and the local list, and the size of the producer list is less than or equal to the size of the local list. The whole index will be rebuilt.");
            return 0;
        }
        if (producerDeltaFileList.length > this.deltaFileList.size()) {
            logger.info((Object)"Remote producer delta file list is larger than the local list, and the two lists are identical up to the length of the local list. The extra delta files found in the producer list will be mergedwith the local index.");
            return this.deltaFileList.size();
        }
        logger.info((Object)"The remote producer's list and the local consumer's list are identical, no merging need to be done.");
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void synchronizeWithIndexManager() throws Exception {
        logger.info((Object)"Starting DeltaFileConsumer synchronization with DeltaListManager's file list...");
        if (!this.indexManager.isEmpty()) {
            DeltaFileInfoType[] producerDeltaFileList = this.indexManager.getDeltaFileList();
            logger.info((Object)("Remote producer's delta file list contains " + producerDeltaFileList.length + " deltas."));
            logger.info((Object)("Local consumer's delta file list contains " + this.deltaFileList.size() + " deltas."));
            LinkedList<DeltaData> linkedList = this.downloadQueue;
            synchronized (linkedList) {
                int listSize;
                int firstDeltaToMerge = 0;
                if (this.deltaFileList.size() > 0) {
                    logger.info((Object)"-----------------------------> 1");
                    firstDeltaToMerge = this.findFirstMissedUpdate(producerDeltaFileList);
                    logger.info((Object)"-----------------------------> 2");
                    if (firstDeltaToMerge == 0) {
                        this.replicator.clearIndex();
                    }
                    logger.info((Object)"-----------------------------> 3");
                }
                logger.info((Object)"-----------------------------> 4");
                if (firstDeltaToMerge != -1 && (listSize = producerDeltaFileList.length - firstDeltaToMerge) > 0) {
                    logger.info((Object)"-----------------------------> 5");
                    for (int i = firstDeltaToMerge; i < producerDeltaFileList.length; ++i) {
                        this.addDeltaToDownloadQueue(i, producerDeltaFileList[i]);
                    }
                    this.downloadQueue.notifyAll();
                    logger.info((Object)"-----------------------------> 6");
                    logger.info((Object)"-----------------------------> 7");
                }
                logger.info((Object)"DeltaFileConsumer synchronization with DeltaListManager's file list done!");
            }
        } else {
            logger.warn((Object)"Remote DeltaListManager is empty, synchronization aborted.");
        }
    }

    public void setDoesHandleAdditions(boolean doesHandleAdditions) throws Exception {
        if (this.additionSubscription != null) {
            this.doesHandleAdditions = doesHandleAdditions;
            if (doesHandleAdditions) {
                this.additionSubscription.pauseSubscription(new PauseSubscription());
            } else {
                this.additionSubscription.resumeSubscription(new ResumeSubscription());
            }
        }
    }

    public void setDoesHandleDeletions(boolean doesHandleDeletions) throws Exception {
        if (this.deletionSubscription != null) {
            this.doesHandleDeletions = doesHandleDeletions;
            if (doesHandleDeletions) {
                this.deletionSubscription.pauseSubscription(new PauseSubscription());
            } else {
                this.deletionSubscription.resumeSubscription(new ResumeSubscription());
            }
        }
    }

    public void setEnforceStrictOrder(boolean enforceStrictOrder) throws Exception {
        this.enforceStrictOrder = enforceStrictOrder;
    }

    private DeltaFileInfoType getDeltaInfoFromQueue(int idx) {
        for (int i = 0; i < this.downloadQueue.size(); ++i) {
            if (this.downloadQueue.get((int)i).idx != idx) continue;
            return this.downloadQueue.remove((int)idx).info;
        }
        return null;
    }

    private File cmsDownload(String indexID) throws Exception {
        File downloadedFile = new File(this.resource.getIndexDataDirectory() + uuidGen.nextUUID() + ".zip");
        try {
            if (this.deltaCollectionID == null) {
                logger.error((Object)"No Delta collection ID is retrieved.. Trying again");
                this.deltaCollectionID = this.indexManager.getDeltaCollectionID();
            }
            if (this.deltaCollectionID == null) {
                logger.error((Object)"There is no delta collection ID during delta file download from CMS ");
                throw new Exception("No delta collection ID during delta file download from CMS ");
            }
            ScopeProvider.instance.set(this.resource.getServiceContext().getScope().toString());
            IClient client = new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
            downloadedFile.getParentFile().mkdirs();
            String remoteFile = indexID;
            String localFile = downloadedFile.getAbsolutePath();
            logger.info((Object)("GET local : " + localFile + " , remote : " + remoteFile));
            client.get().LFile(localFile).RFileById(remoteFile);
            logger.info((Object)("Downloaded file of size: " + downloadedFile.length()));
        }
        catch (Exception e) {
            throw new Exception("Failed to download delta file from CMS.", e);
        }
        return downloadedFile;
    }

    private File unzipIndex(File index, String targetDir) throws Exception {
        ZipFile zip = new ZipFile(index, 1);
        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
        File extractedFile = null;
        File returnFile = null;
        ZipEntry entry = null;
        String fullEntryName = null;
        String entryName = null;
        String uid = uuidGen.nextUUID();
        while (zipEntries.hasMoreElements()) {
            int len;
            File parent;
            entry = zipEntries.nextElement();
            logger.debug((Object)("Unzipping entry: " + entry.getName()));
            entryName = uid;
            int start = entry.getName().indexOf(47);
            if (start != -1) {
                entryName = entryName + entry.getName().substring(start);
            }
            if (!(parent = (extractedFile = new File(fullEntryName = targetDir + entryName)).getParentFile()).exists()) {
                parent.mkdir();
            }
            if (entry.isDirectory()) continue;
            BufferedInputStream entryIn = new BufferedInputStream(zip.getInputStream(entry), 2048);
            BufferedOutputStream entryOut = new BufferedOutputStream(new FileOutputStream(extractedFile), 2048);
            byte[] buffer = new byte[2048];
            while ((len = entryIn.read(buffer)) >= 0) {
                entryOut.write(buffer, 0, len);
            }
            entryIn.close();
            entryOut.close();
        }
        if (entry != null) {
            int directoryNameEnd = entryName.indexOf(47);
            returnFile = directoryNameEnd != -1 ? new File(targetDir + entryName.substring(0, directoryNameEnd)) : extractedFile;
        }
        return returnFile;
    }

    private void mergeDeltaFile(DeltaFileInfoType deltaInfo) throws Exception {
        logger.info((Object)("In mergeDeltaFile deltaFileID : " + deltaInfo.getDeltaFileID()));
        if (deltaInfo.getDeltaAction().equals((Object)DeltaActionType.Addition) && this.doesHandleAdditions) {
            File zip = this.cmsDownload(deltaInfo.getDeltaFileID());
            logger.info((Object)("downloaded update file: " + zip.getAbsolutePath()));
            File deltaFile = null;
            deltaFile = this.unzipIndex(zip, this.resource.getIndexDataDirectory());
            logger.info((Object)("unzipped addition update file to: " + deltaFile.getAbsolutePath()));
            zip.delete();
            long before = Calendar.getInstance().getTimeInMillis();
            this.replicator.mergeAddition(deltaFile, deltaInfo.getDeltaFileID(), deltaInfo.getDocumentCount());
            long after = Calendar.getInstance().getTimeInMillis();
            if (!this.deleteDirectory(deltaFile)) {
                logger.info((Object)("Addition complete, but was unable to completely delete temporary directory: " + deltaFile.getAbsolutePath()));
            } else {
                logger.info((Object)("Addition of \"" + deltaInfo.getDeltaFileID() + "\"completed in " + (after - before) + "ms and the temporary directory \"" + deltaFile.getAbsolutePath() + "\" was deleted."));
            }
            this.addDeltaFileToList(deltaInfo);
        } else if (deltaInfo.getDeltaAction().equals((Object)DeltaActionType.Deletion) && this.doesHandleDeletions) {
            File zip = this.cmsDownload(deltaInfo.getDeltaFileID());
            logger.info((Object)("downloaded update file: " + zip.getAbsolutePath()));
            File deltaFile = null;
            deltaFile = this.unzipIndex(zip, this.resource.getIndexDataDirectory());
            logger.info((Object)("unzipped deletion update file to: " + deltaFile.getAbsolutePath()));
            zip.delete();
            long before = Calendar.getInstance().getTimeInMillis();
            this.replicator.mergeDeletion(deltaFile, deltaInfo.getDeltaFileID(), deltaInfo.getDocumentCount());
            long after = Calendar.getInstance().getTimeInMillis();
            if (!this.deleteDirectory(deltaFile)) {
                logger.info((Object)("Deletion complete, but was unable to completely delete temporary directory: " + deltaFile.getAbsolutePath()));
            } else {
                logger.info((Object)("Deletion of \"" + deltaInfo.getDeltaFileID() + "\"completed in " + (after - before) + "ms and the temporary directory \"" + deltaFile.getAbsolutePath() + "\" was deleted."));
            }
            this.addDeltaFileToList(deltaInfo);
        }
    }

    private void addDeltaFileToList(DeltaFileInfoType deltaFileInfo) {
        this.deltaFileList.add(deltaFileInfo);
    }

    private void subscribeForDeltaListChanges() {
        try {
            this.additionSubscription = this.indexManager.subscribeForAdditions(this.additionNotificationConsumer);
            logger.debug((Object)"Consumer subscribed for addition notification.");
            this.deletionSubscription = this.indexManager.subscribeForDeletions(this.deletionNotificationConsumer);
            logger.debug((Object)"Consumer subscribed for deletion notification.");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to subscribe for delta list changes.", (Throwable)e);
        }
    }

    private void subscribeForIndexRemoval() {
        try {
            this.removalSubscription = this.indexManager.subscribeForIndexRemoval(this.removalNotificationConsumer);
            logger.debug((Object)"Consumer subscribed for removal notification.");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to subscribe for index removal", (Throwable)e);
        }
    }

    private void subscribeForManagerCreation() {
        try {
            this.managerCreationSubscription = this.indexManager.subscribeForManagerCreation(this.managerCreationNotificationConsumer);
            logger.debug((Object)"Consumer subscribed for manager creation notification.");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to subscribe for manager creation", (Throwable)e);
        }
    }

    private boolean deleteDirectory(File dir) {
        if (dir.canRead()) {
            String[] files;
            if (dir.isDirectory() && (files = dir.list()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    this.deleteDirectory(new File(dir, files[i]));
                }
            }
            return dir.delete();
        }
        return false;
    }

    private void addDeltaToDownloadQueue(int deltaFileIdx, DeltaFileInfoType deltaFileInfo) {
        for (DeltaData data : this.downloadQueue) {
            if (!data.info.getDeltaFileID().equalsIgnoreCase(deltaFileInfo.getDeltaFileID())) continue;
            logger.info((Object)("The DeltaFile with id: " + deltaFileInfo.getDeltaFileID() + ", is already in the queue."));
            return;
        }
        this.downloadQueue.addFirst(new DeltaData(deltaFileInfo, deltaFileIdx));
        logger.info((Object)("DeltaFileConsumer added " + deltaFileInfo.getDeltaAction().getValue() + " " + deltaFileInfo.getDeltaFileID() + " (#" + deltaFileIdx + ") to download queue."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdateNotification(UpdateNotificationMessageType notification) {
        logger.info((Object)("Update notification received (idxID: " + this.resource.getIndexID()));
        if (notification != null) {
            LinkedList<DeltaData> linkedList = this.downloadQueue;
            synchronized (linkedList) {
                this.addDeltaToDownloadQueue(notification.getDeltaFileIdx(), notification.getDeltaFileInfo());
                this.downloadQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleManagerCreationNotification(DeltaListManagerCreatedNotificationMessageType notification) {
        try {
            Object object = this.downloadQueue;
            synchronized (object) {
                this.downloadQueue.clear();
            }
            object = this.indexManager;
            synchronized (object) {
                logger.info((Object)"Connecting consumer to newly-created manager");
                EndpointReferenceType managerEPR = notification.getEndpointReference();
                this.indexManager.setIndexManagerEPR(managerEPR);
                this.resource.setConnectionID(this.indexManager.connectLookup());
                this.indexManager.notifyAll();
            }
            this.synchronizeWithIndexManager();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to set the new delta list manager EPR, received by notification.");
        }
    }

    public void close() throws Exception {
        if (this.additionSubscription != null) {
            this.additionSubscription.destroy(new Destroy());
        }
        if (this.deletionSubscription != null) {
            this.deletionSubscription.destroy(new Destroy());
        }
        if (this.removalSubscription != null) {
            this.removalSubscription.destroy(new Destroy());
        }
        if (this.managerCreationSubscription != null) {
            this.managerCreationSubscription.destroy(new Destroy());
        }
        this.replicatorThread.interrupt();
    }

    private void destroyResource() throws Exception {
        try {
            this.resource.getPorttypeContext().getWSHome().remove((ResourceKey)this.resource.getID());
        }
        catch (Exception e) {
            logger.error((Object)"Error while removing the index lookup resource.", (Throwable)e);
            throw new Exception("Error while removing the index lookup resource.", e);
        }
    }

    public class ManagerCreationConsumerNotification
    extends IndexNotificationConsumer {
        public ManagerCreationConsumerNotification(GCUBEScope scope) {
            super((IndexWSResource)DeltaFileConsumer.this.resource, scope);
        }

        protected void onNewNotification(ISNotifier.NotificationEvent event) {
            logger.debug((Object)("DeltaFileConsumer received manager creation notification (idxID: " + DeltaFileConsumer.this.resource.getIndexID() + ")."));
            Element message = null;
            try {
                message = (Element)((ISNotifier.NotificationMessage)event.getPayload()).getMessageObject();
                DeltaListManagerCreatedNotificationMessageType notification = (DeltaListManagerCreatedNotificationMessageType)ObjectDeserializer.toObject((Element)message, DeltaListManagerCreatedNotificationMessageType.class);
                DeltaFileConsumer.this.handleManagerCreationNotification(notification);
            }
            catch (Exception e) {
                logger.error((Object)"Error while deserializing manager creation notification.", (Throwable)e);
            }
        }
    }

    public class RemovalConsumerNotification
    extends IndexNotificationConsumer {
        public RemovalConsumerNotification(GCUBEScope scope) {
            super((IndexWSResource)DeltaFileConsumer.this.resource, scope);
        }

        protected void onNewNotification(ISNotifier.NotificationEvent event) {
            logger.debug((Object)("DeltaFileConsumer received index removal notification (idxID: " + DeltaFileConsumer.this.resource.getIndexID() + ")."));
            try {
                DeltaFileConsumer.this.destroyResource();
            }
            catch (Exception e) {
                logger.error((Object)"Error while handling index removal notification.", (Throwable)e);
            }
        }
    }

    public class DeletionConsumerNotification
    extends IndexNotificationConsumer {
        public DeletionConsumerNotification(GCUBEScope scope) {
            super((IndexWSResource)DeltaFileConsumer.this.resource, scope);
        }

        protected void onNewNotification(ISNotifier.NotificationEvent event) {
            logger.debug((Object)("DeltaFileConsumer received deletion notification (idxID: " + DeltaFileConsumer.this.resource.getIndexID() + ")."));
            Element message = null;
            try {
                message = (Element)((ISNotifier.NotificationMessage)event.getPayload()).getMessageObject();
                UpdateNotificationMessageType notification = (UpdateNotificationMessageType)ObjectDeserializer.toObject((Element)message, UpdateNotificationMessageType.class);
                DeltaFileConsumer.this.handleUpdateNotification(notification);
            }
            catch (Exception e) {
                logger.error((Object)"Error while receiving delta file deletion notification.", (Throwable)e);
            }
        }
    }

    public class AdditionConsumerNotification
    extends IndexNotificationConsumer {
        public AdditionConsumerNotification(GCUBEScope scope) {
            super((IndexWSResource)DeltaFileConsumer.this.resource, scope);
        }

        protected void onNewNotification(ISNotifier.NotificationEvent event) {
            logger.debug((Object)("DeltaFileConsumer received addition notification (idxID: " + DeltaFileConsumer.this.resource.getIndexID() + ")."));
            Element message = null;
            try {
                message = (Element)((ISNotifier.NotificationMessage)event.getPayload()).getMessageObject();
                UpdateNotificationMessageType notification = (UpdateNotificationMessageType)ObjectDeserializer.toObject((Element)message, UpdateNotificationMessageType.class);
                DeltaFileConsumer.this.handleUpdateNotification(notification);
            }
            catch (Exception e) {
                logger.error((Object)"Error while receiving delta file addition notification.", (Throwable)e);
            }
        }
    }

    private class DeltaData {
        public DeltaFileInfoType info;
        public int idx;

        public DeltaData(DeltaFileInfoType info, int idx) {
            this.info = info;
            this.idx = idx;
        }

        public boolean equals(Object obj) {
            try {
                DeltaData otherData = (DeltaData)obj;
                return this.idx == otherData.idx && this.info.equals((Object)otherData.info);
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    class IndexReplicatorThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            DeltaListManagementWrapper deltaListManagementWrapper = DeltaFileConsumer.this.indexManager;
            synchronized (deltaListManagementWrapper) {
                if (DeltaFileConsumer.this.indexManager.isEmpty()) {
                    try {
                        Thread.yield();
                        if (Thread.currentThread().isInterrupted()) {
                            logger.debug((Object)"Consumer thread cancelled before wait.");
                            return;
                        }
                        logger.info((Object)"Consumer is not currently connected to a manager. Going to wait until manager creation...");
                        DeltaFileConsumer.this.indexManager.wait();
                    }
                    catch (InterruptedException e) {
                        logger.debug((Object)"Consumer thread cancelled while waiting.");
                        return;
                    }
                }
            }
            int nextIdx = DeltaFileConsumer.this.deltaFileList.size();
            boolean bDownloadedNewData = false;
            while (true) {
                try {
                    while (true) {
                        LinkedList linkedList = DeltaFileConsumer.this.downloadQueue;
                        synchronized (linkedList) {
                            DeltaFileInfoType deltaInfo;
                            if (DeltaFileConsumer.this.downloadQueue.size() == 0) {
                                if (bDownloadedNewData) {
                                    DeltaFileConsumer.this.resource.store();
                                }
                                try {
                                    Thread.yield();
                                    if (Thread.currentThread().isInterrupted()) {
                                        logger.debug((Object)"Consumer thread cancelled before wait.");
                                        return;
                                    }
                                    logger.info((Object)"DeltaFileConsumer waiting... ");
                                    DeltaFileConsumer.this.downloadQueue.wait();
                                }
                                catch (InterruptedException e) {
                                    logger.debug((Object)"Consumer thread cancelled while waiting.");
                                    return;
                                }
                            }
                            DeltaData delta = (DeltaData)DeltaFileConsumer.this.downloadQueue.removeLast();
                            bDownloadedNewData = false;
                            logger.info((Object)("DeltaFileConsumer fetching DeltaInfo... Received " + delta.idx + ", expected " + (DeltaFileConsumer.this.enforceStrictOrder ? Integer.valueOf(nextIdx) : "any")));
                            if (!DeltaFileConsumer.this.enforceStrictOrder) {
                                deltaInfo = delta.info;
                                logger.info((Object)("Merging deltafile: " + delta.idx));
                                DeltaFileConsumer.this.mergeDeltaFile(deltaInfo);
                                bDownloadedNewData = true;
                            } else {
                                while (nextIdx <= delta.idx) {
                                    Thread.yield();
                                    if (Thread.currentThread().isInterrupted()) {
                                        logger.debug((Object)"Consumer thread cancelled in merge loop.");
                                        return;
                                    }
                                    if (delta.idx != nextIdx) {
                                        deltaInfo = DeltaFileConsumer.this.getDeltaInfoFromQueue(nextIdx);
                                        if (deltaInfo == null) {
                                            deltaInfo = DeltaFileConsumer.this.indexManager.getDeltaFileInfo(nextIdx);
                                        }
                                    } else {
                                        deltaInfo = delta.info;
                                    }
                                    logger.info((Object)("Merging deltafile: " + nextIdx));
                                    DeltaFileConsumer.this.mergeDeltaFile(deltaInfo);
                                    bDownloadedNewData = true;
                                    ++nextIdx;
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)" Error downloading or merging delta file.", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

