/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.icproxy.resources;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="ServiceEndpoint")
public class ServiceEndpointResource {
    private static final Logger log = LoggerFactory.getLogger(ServiceEndpointResource.class);

    @GET
    @Path(value="/{category}/{name}")
    @Produces(value={"application/xml"})
    public List<ServiceEndpoint> retrieve(@NotNull @PathParam(value="name") String resourceName, @NotNull @PathParam(value="category") String resourceCategory) {
        log.info("ServiceEndpoint called with category {} and name {} in scope {}", new Object[]{resourceCategory, resourceName, ScopeProvider.instance.get()});
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List endpoints = client.submit((Query)this.getQuery(resourceName, resourceCategory));
        log.debug("retrieved resources are " + endpoints.size());
        return endpoints;
    }

    @GET
    @Path(value="/{category}/{name}/Result/{result:([^$\\?]+)}")
    @Produces(value={"text/xml"})
    public String retrieveCustom(@NotNull @PathParam(value="name") String resourceName, @NotNull @PathParam(value="category") String resourceCategory, @NotNull @PathParam(value="result") String resultXPath) {
        log.info("ServiceEndpoint called with category {} and name {} and result {} in scope {}", new Object[]{resourceCategory, resourceName, resultXPath, ScopeProvider.instance.get()});
        SimpleQuery query = this.getQuery(resourceName, resourceCategory);
        if (resultXPath.startsWith("/")) {
            query.setResult("$resource" + resultXPath);
        } else {
            query.setResult("$resource/" + resultXPath);
        }
        DiscoveryClient client = ICFactory.client();
        List endpoints = client.submit((Query)query);
        StringBuilder builder = new StringBuilder("<Results>");
        for (String single : endpoints) {
            builder.append("<Result>").append(single.replaceAll("\n", "")).append("</Result>");
        }
        builder.append("</Results>");
        log.debug("retrieved resources are " + endpoints.size());
        return builder.toString();
    }

    private SimpleQuery getQuery(String resourceName, String resourceCategory) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition(String.format("$resource/Profile/Name/text() eq '%s'", resourceName));
        query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'", resourceCategory));
        return query;
    }
}

