package org.gcube.informationsystem.icproxy.resources;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.util.List;

import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.icproxy.swagger.Bootstrap;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.slf4j.LoggerFactory;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Path("ServiceEndpoint")
@Api(value="ServiceEndpoint", authorizations={@Authorization(value = Bootstrap.GCUBE_TOKEN_IN_QUERY_DEF), @Authorization(value = Bootstrap.GCUBE_TOKEN_IN_HEADER_DEF)})
public class ServiceEndpointResource {
	
	private static final org.slf4j.Logger log = LoggerFactory.getLogger(ServiceEndpointResource.class);

	@GET
	@Path("/{category}/{name}")
	@Produces(MediaType.APPLICATION_XML)
	@ApiOperation(value = "Retrieve a Service Endpoint by specifying the category and the name within the path", response=String.class, 
	notes="Retrieve a Service Endpoint by specifying the category and the name within the path. For example: "
			+ "/icproxy/gcube/service/ServiceEndpoint/Portal/SocialNetworking retrieves the Service Endpoint having category Portal and name SocialNetworking."
			, nickname="get-service-endpoint-by-category-and-name")
	public List<ServiceEndpoint> retrieve(@NotNull @PathParam("name") String resourceName, 
			@NotNull @PathParam("category") String resourceCategory) {
		log.info("ServiceEndpoint called with category {} and name {} in scope {}",resourceCategory, resourceName, ScopeProvider.instance.get());
		
		DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);

		List<ServiceEndpoint> endpoints = client.submit(getQuery(resourceName, resourceCategory));
		log.debug("retrieved resources are "+endpoints.size());
		return endpoints; 
	}

	//the usage of this is not clear, commenting this for the moment
//	@GET
//	@Path("/{category}/{name}/Result/{result:([^$\\?]+)}")
//	@Produces(MediaType.TEXT_XML)
//	@ApiOperation(value = "Retrieve a Service Endpoint by specifying the category and the name within the path. A filter can be added too.", response=String.class, 
//	notes="Retrieve a Service Endpoint by specifying the category and the name within the path.  A filter can be added by using the 'result' query parameter passing an XPath.For example: "
//			+ "/icproxy/gcube/service/ServiceEndpoint/Portal/SocialNetworking/Result retrieves the Service Endpoint having category Portal and name SocialNetworking."
//			, nickname="get-service-endpoint-by-category-and-name-and-filter")
//	public String retrieveCustom(@NotNull @PathParam("name") String resourceName, 
//			@NotNull @PathParam("category") String resourceCategory, @NotNull @PathParam("result") String resultXPath) {
//		log.info("ServiceEndpoint called with category {} and name {} and result {} in scope {}"
//				,resourceCategory, resourceName, resultXPath, ScopeProvider.instance.get());
//		
//		SimpleQuery query = getQuery(resourceName, resourceCategory);
//				
//		if (resultXPath.startsWith("/"))
//			query.setResult("$resource"+resultXPath);
//		else
//			query.setResult("$resource/"+resultXPath);
//		
//		DiscoveryClient<String> client = client();
//		List<String> endpoints = client.submit(query);
//		StringBuilder builder = new StringBuilder("<Results>");
//		for (String single: endpoints)
//			builder.append("<Result>").append(single.replaceAll("\n", "")).append("</Result>");
//		
//		builder.append("</Results>");
//		
//		log.debug("retrieved resources are "+endpoints.size());
//		return builder.toString(); 
//	}

	private SimpleQuery getQuery(String resourceName, String resourceCategory){
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		query.addCondition(String.format("$resource/Profile/Name/text() eq '%s'",resourceName));
		query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'",resourceCategory));
		return query;
	}
	
}
